/*
 * Decompiled with CFR 0.152.
 */
package jemu.util.ass;

import jemu.core.Util;
import jemu.core.device.Device;
import jemu.ui.JEMU;
import jemu.util.ass.EditorPanel;
import jemu.util.ass.Interface;
import jemu.util.ass.MathParser;

public class Z80Assembler {
    public boolean DEBUG = false;
    public int[] address = new int[65552];
    public byte[] output = new byte[65552];
    public int lowest = 65538;
    public int highest = 0;
    public static String[] EQU = new String[5000];
    public static String[] EQULABEL = new String[5000];
    public int equ;
    public static int maxequ;
    public String[] UndocumentedOpcodes = new String[]{"ADD IXH", "ADD IXL", "ADC IXH", "ADC IXL", "SBC IXH", "SBC IXL", "ADD IYH", "ADD IYL", "ADC IYH", "ADC IYL", "SBC IYH", "SBC IYL", "LD R,A", "LD A,R", "LD PC,IXH", "LD PC,IX", "SLL B", "SLL C", "SLL D", "SLL E", "SLL H", "SLL L", "SLL (HL)", "SLL A", "INC IXH", "DEC IXH", "LD IXH,N", "INC IXL", "DEC IXL", "LD IXL,N", "LD B,IXH", "LD B,IXL", "LD C,IXH", "LD C,IXL", "LD D,IXH", "LD D,IXL", "LD E,IXH", "LD E,IXL", "LD IXH,B", "LD IXH,C", "LD IXH,D", "LD IXH,E", "LD IXH,IXH", "LD IXH,IXL", "LD IXH,A", "LD IXL,B", "LD IXL,C", "LD IXL,D", "LD IXL,E", "LD IXL,IXH", "LD IXL,IXL", "LD IXL,A", "LD A,IXH", "LD A,IXL", "ADD A,IXH", "ADD A,IXL", "ADC A,IXH", "ADC A,IXL", "SUB IXH", "SUB IXL", "SBC A,IXH", "SBC A,IXL", "AND IXH", "AND IXL", "XOR IXH", "XOR IXL", "OR IXH", "OR IXL", "CP IXH", "CP IXL", "INC IYH", "DEC IYH", "LD IYH,N", "INC IYL", "DEC IYL", "LD IYL,N", "LD B,IYH", "LD B,IYL", "LD C,IYH", "LD C,IYL", "LD D,IYH", "LD D,IYL", "LD E,IYH", "LD E,IYL", "LD IYH,B", "LD IYH,C", "LD IYH,D", "LD IYH,E", "LD IYH,IYH", "LD IYH,IYL", "LD IYH,A", "LD IYL,B", "LD IYL,C", "LD IYL,D", "LD IYL,E", "LD IYL,IYH", "LD IYL,IYL", "LD IYL,A", "LD A,IYH", "LD A,IYL", "ADD A,IYH", "ADD A,IYL", "ADC A,IYH", "ADC A,IYL", "SUB IYH", "SUB IYL", "SBC A,IYH", "SBC A,IYL", "AND IYH", "AND IYL", "XOR IYH", "XOR IYL", "OR IYH", "OR IYL", "CP IYH", "CP IYL"};
    public String[] UndocumentedValues = new String[]{"DD84", "DD85", "DD8C", "DD8D", "DD9C", "DD9D", "FD84", "FD85", "FD8C", "FD8D", "FD9C", "FD9D", "ED4F", "ED5F", "DDE9", "DDE9", "CB30", "CB31", "CB32", "CB33", "CB34", "CB35", "CB36", "CB37", "DD24", "DD25", "DD26XX", "DD2C", "DD2D", "DD2EXX", "DD44", "DD45", "DD4C", "DD4D", "DD54", "DD55", "DD5C", "DD5D", "DD60", "DD61", "DD62", "DD63", "DD64", "DD65", "DD67", "DD68", "DD69", "DD6A", "DD6B", "DD6C", "DD6D", "DD6F", "DD7C", "DD7D", "DD84", "DD85", "DD8C", "DD8D", "DD94", "DD95", "DD9C", "DD9D", "DDA4", "DDA5", "DDAC", "DDAD", "DDB4", "DDB5", "DDBC", "DDBD", "FD24", "FD25", "FD26XX", "FD2C", "FD2D", "FD2EXX", "FD44", "FD45", "FD4C", "FD4D", "FD54", "FD55", "FD5C", "FD5D", "FD60", "FD61", "FD62", "FD63", "FD64", "FD65", "FD67", "FD68", "FD69", "FD6A", "FD6B", "FD6C", "FD6D", "FD6F", "FD7C", "FD7D", "FD84", "FD85", "FD8C", "FD8D", "FD94", "FD95", "FD9C", "FD9D", "FDA4", "FDA5", "FDAC", "FDAD", "FDB4", "FDB5", "FDBC", "FDBD"};
    public String[] Opcodes = new String[]{"BRK", "BREAK", "NOP", "LD BC,N", "LD (BC),A", "INC BC", "INC B", "DEC B", "LD B,N", "RLCA", "EX AF,AF'", "ADD HL,BC", "LD A,(BC)", "DEC BC", "INC C", "DEC C", "LD C,N", "RRCA", "DJNZ $+N", "LD DE,NN", "LD (DE),A", "INC DE", "INC D", "DEC D", "LD D,N", "RLA", "JR $+N", "ADD HL,DE", "LD A,(DE)", "DEC DE", "INC E", "DEC E", "LD E,N", "RRA", "JR NZ,$+N", "LD HL,NN", "LD (NN),HL", "INC HL", "INC H", "DEC H", "LD H,N", "DAA", "JR Z,$+N", "ADD HL,HL", "LD HL,(NN)", "DEC HL", "INC L", "DEC L", "LD L,N", "CPL", "JR NC,$+N", "LD SP,NN", "LD (NN),A", "INC SP", "INC (HL)", "DEC (HL)", "LD (HL),N", "SCF", "JR C,$+N", "ADD HL,SP", "LD A,(NN)", "DEC SP", "INC A", "DEC A", "LD A,N", "CCF", "LD B,B", "LD B,C", "LD B,D", "LD B,E", "LD B,H", "LD B,L", "LD B,(HL)", "LD B,A", "LD C,B", "LD C,C", "LD C,D", "LD C,E", "LD C,H", "LD C,L", "LD C,(HL)", "LD C,A", "LD D,B", "LD D,C", "LD D,D", "LD D,E", "LD D,H", "LD D,L", "LD D,(HL)", "LD D,A", "LD E,B", "LD E,C", "LD E,D", "LD E,E", "LD E,H", "LD E,L", "LD E,(HL)", "LD E,A", "LD H,B", "LD H,C", "LD H,D", "LD H,E", "LD H,H", "LD H,L", "LD H,(HL)", "LD H,A", "LD L,B", "LD L,C", "LD L,D", "LD L,E", "LD L,H", "LD L,L", "LD L,(HL)", "LD L,A", "LD (HL),B", "LD (HL),C", "LD (HL),D", "LD (HL),E", "LD (HL),H", "LD (HL),L", "HALT", "LD (HL),A", "LD A,B", "LD A,C", "LD A,D", "LD A,E", "LD A,H", "LD A,L", "LD A,(HL)", "LD A,A", "ADD A,B", "ADD B", "ADD A,C", "ADD C", "ADD A,D", "ADD D", "ADD A,E", "ADD E", "ADD A,H", "ADD H", "ADD A,L", "ADD L", "ADD A,(HL)", "ADD (HL)", "ADD A,A", "ADD A", "ADC A,B", "ADC B", "ADC A,C", "ADC C", "ADC A,D", "ADC D", "ADC A,E", "ADC E", "ADC A,H", "ADC H", "ADC A,L", "ADC L", "ADC A,(HL)", "ADC (HL)", "ADC A,A", "ADC A", "SUB B", "SUB C", "SUB D", "SUB E", "SUB H", "SUB L", "SUB (HL)", "SUB A", "SBC B", "SBC C", "SBC D", "SBC E", "SBC H", "SBC L", "SBC (HL)", "SBC A", "AND B", "AND C", "AND D", "AND E", "AND H", "AND L", "AND (HL)", "AND A", "XOR B", "XOR C", "XOR D", "XOR E", "XOR H", "XOR L", "XOR (HL)", "XOR A", "OR B", "OR C", "OR D", "OR E", "OR H", "OR L", "OR (HL)", "OR A", "CP B", "CP C", "CP D", "CP E", "CP H", "CP L", "CP (HL)", "CP A", "RET NZ", "POP BC", "JP NZ,$+3", "JP $+3", "CALL NZ,NN", "PUSH BC", "ADD A,N", "RST 0", "RET Z", "RET", "JP Z,$+3", "RLC B", "RLC C", "RLC D", "RLC E", "RLC H", "RLC L", "RLC (HL)", "RLC A", "RRC B", "RRC C", "RRC D", "RRC E", "RRC H", "RRC L", "RRC (HL)", "RRC A", "RL B", "RL C", "RL D", "RL E", "RL H", "RL L", "RL (HL)", "RL A", "RR B", "RR C", "RR D", "RR E", "RR H", "RR L", "RR (HL)", "RR A", "SLA B", "SLA C", "SLA D", "SLA E", "SLA H", "SLA L", "SLA (HL)", "SLA A", "SRA B", "SRA C", "SRA D", "SRA E", "SRA H", "SRA L", "SRA (HL)", "SRA A", "SRL B", "SRL C", "SRL D", "SRL E", "SRL H", "SRL L", "SRL (HL)", "SRL A", "BIT 0,B", "BIT 0,C", "BIT 0,D", "BIT 0,E", "BIT 0,H", "BIT 0,L", "BIT 0,(HL)", "BIT 0,A", "BIT 1,B", "BIT 1,C", "BIT 1,D", "BIT 1,E", "BIT 1,H", "BIT 1,L", "BIT 1,(HL)", "BIT 1,A", "BIT 2,B", "BIT 2,C", "BIT 2,D", "BIT 2,E", "BIT 2,H", "BIT 2,L", "BIT 2,(HL)", "BIT 2,A", "BIT 3,B", "BIT 3,C", "BIT 3,D", "BIT 3,E", "BIT 3,H", "BIT 3,L", "BIT 3,(HL)", "BIT 3,A", "BIT 4,B", "BIT 4,C", "BIT 4,D", "BIT 4,E", "BIT 4,H", "BIT 4,L", "BIT 4,(HL)", "BIT 4,A", "BIT 5,B", "BIT 5,C", "BIT 5,D", "BIT 5,E", "BIT 5,H", "BIT 5,L", "BIT 5,(HL)", "BIT 5,A", "BIT 6,B", "BIT 6,C", "BIT 6,D", "BIT 6,E", "BIT 6,H", "BIT 6,L", "BIT 6,(HL)", "BIT 6,A", "BIT 7,B", "BIT 7,C", "BIT 7,D", "BIT 7,E", "BIT 7,H", "BIT 7,L", "BIT 7,(HL)", "BIT 7,A", "RES 0,B", "RES 0,C", "RES 0,D", "RES 0,E", "RES 0,H", "RES 0,L", "RES 0,(HL)", "RES 0,A", "RES 1,B", "RES 1,C", "RES 1,D", "RES 1,E", "RES 1,H", "RES 1,L", "RES 1,(HL)", "RES 1,A", "RES 2,B", "RES 2,C", "RES 2,D", "RES 2,E", "RES 2,H", "RES 2,L", "RES 2,(HL)", "RES 2,A", "RES 3,B", "RES 3,C", "RES 3,D", "RES 3,E", "RES 3,H", "RES 3,L", "RES 3,(HL)", "RES 3,A", "RES 4,B", "RES 4,C", "RES 4,D", "RES 4,E", "RES 4,H", "RES 4,L", "RES 4,(HL)", "RES 4,A", "RES 5,B", "RES 5,C", "RES 5,D", "RES 5,E", "RES 5,H", "RES 5,L", "RES 5,(HL)", "RES 5,A", "RES 6,B", "RES 6,C", "RES 6,D", "RES 6,E", "RES 6,H", "RES 6,L", "RES 6,(HL)", "RES 6,A", "RES 7,B", "RES 7,C", "RES 7,D", "RES 7,E", "RES 7,H", "RES 7,L", "RES 7,(HL)", "RES 7,A", "SET 0,B", "SET 0,C", "SET 0,D", "SET 0,E", "SET 0,H", "SET 0,L", "SET 0,(HL)", "SET 0,A", "SET 1,B", "SET 1,C", "SET 1,D", "SET 1,E", "SET 1,H", "SET 1,L", "SET 1,(HL)", "SET 1,A", "SET 2,B", "SET 2,C", "SET 2,D", "SET 2,E", "SET 2,H", "SET 2,L", "SET 2,(HL)", "SET 2,A", "SET 3,B", "SET 3,C", "SET 3,D", "SET 3,E", "SET 3,H", "SET 3,L", "SET 3,(HL)", "SET 3,A", "SET 4,B", "SET 4,C", "SET 4,D", "SET 4,E", "SET 4,H", "SET 4,L", "SET 4,(HL)", "SET 4,A", "SET 5,B", "SET 5,C", "SET 5,D", "SET 5,E", "SET 5,H", "SET 5,L", "SET 5,(HL)", "SET 5,A", "SET 6,B", "SET 6,C", "SET 6,D", "SET 6,E", "SET 6,H", "SET 6,L", "SET 6,(HL)", "SET 6,A", "SET 7,B", "SET 7,C", "SET 7,D", "SET 7,E", "SET 7,H", "SET 7,L", "SET 7,(HL)", "SET 7,A", "CALL Z,NN", "CALL NN", "ADC A,N", "RST &8", "RET NC", "POP DE", "JP NC,$+3", "OUT (N),A", "CALL NC,NN", "PUSH DE", "SUB N", "RST &10", "RET C", "EXX", "JP C,$+3", "IN A,(N)", "CALL C,NN", "ADD IX,BC", "ADD IX,DE", "LD IX,NN", "LD (NN),IX", "INC IX", "ADD IX,IX", "LD IX,(NN)", "DEC IX", "INC (IX+N)", "DEC (IX+N)", "LD (IX+N),N", "ADD IX,SP", "LD B,(IX+N)", "LD C,(IX+N)", "LD D,(IX+N)", "LD E,(IX+N)", "LD H,(IX+N)", "LD L,(IX+N)", "LD (IX+N),B", "LD (IX+N),C", "LD (IX+N),D", "LD (IX+N),E", "LD (IX+N),H", "LD (IX+N),L", "LD (IX+N),A", "LD A,(IX+N)", "ADD A,(IX+N)", "ADC A,(IX+N)", "SUB (IX+N)", "SBC A,(IX+N)", "AND (IX+N)", "XOR (IX+N)", "OR (IX+N)", "CP (IX+N)", "RLC (IX+N)", "RRC (IX+N)", "RL (IX+N)", "RR (IX+N)", "SLA (IX+N)", "SRA (IX+N)", "BIT 0,(IX+N)", "BIT 1,(IX+N)", "BIT 2,(IX+N)", "BIT 3,(IX+N)", "BIT 4,(IX+N)", "BIT 5,(IX+N)", "BIT 6,(IX+N)", "BIT 7,(IX+N)", "RES 0,(IX+N)", "RES 1,(IX+N)", "RES 2,(IX+N)", "RES 3,(IX+N)", "RES 4,(IX+N)", "RES 5,(IX+N)", "RES 6,(IX+N)", "RES 7,(IX+N)", "SET 0,(IX+N)", "SET 1,(IX+N)", "SET 2,(IX+N)", "SET 3,(IX+N)", "SET 4,(IX+N)", "SET 5,(IX+N)", "SET 6,(IX+N)", "SET 7,(IX+N)", "POP IX", "EX (SP),IX", "PUSH IX", "JP (IX)", "LD SP,IX", "SBC A,N", "RST &18", "RET PO", "POP HL", "JP PO,$+3", "EX (SP),HL", "CALL PO,NN", "PUSH HL", "AND N", "RST &20", "RET PE", "JP (HL)", "JP PE,$+3", "EX DE,HL", "EX HL,DE", "CALL PE,NN", "IN B,(C)", "OUT (C),B", "SBC HL,BC", "LD (NN),BC", "NEG", "RETN", "IM 0", "LD I,A", "IN C,(C)", "OUT (C),C", "ADC HL,BC", "LD BC,(NN)", "RETI", "IN D,(C)", "OUT (C),D", "SBC HL,DE", "LD (NN),DE", "IM 1", "LD A,I", "IN E,(C)", "OUT (C),E", "ADC HL,DE", "LD DE,(NN)", "IM 2", "IN H,(C)", "OUT (C),H", "SBC HL,HL", "RRD", "IN L,(C)", "OUT (C),L", "ADC HL,HL", "RLD", "SBC HL,SP", "LD (NN),SP", "IN A,(C)", "OUT (C),A", "ADC HL,SP", "LD SP,(NN)", "LDI", "CPI", "INI", "OUTI", "LDD", "CPD", "IND", "OUTD", "LDIR", "CPIR", "INIR", "OTIR", "LDDR", "CPDR", "INDR", "OTDR", "XOR N", "RST &28", "RET P", "POP AF", "JP P,$+3", "DI", "CALL P,NN", "PUSH AF", "OR N", "RST &30", "RET M", "LD SP,HL", "JP M,$+3", "EI", "CALL M,NN", "ADD IY,BC", "ADD IY,DE", "LD IY,NN", "LD (NN),IY", "INC IY", "ADD IY,IY", "LD IY,(NN)", "DEC IY", "INC (IY+N)", "DEC (IY+N)", "LD (IY+N),N", "ADD IY,SP", "LD B,(IY+N)", "LD C,(IY+N)", "LD D,(IY+N)", "LD E,(IY+N)", "LD H,(IY+N)", "LD L,(IY+N)", "LD (IY+N),B", "LD (IY+N),C", "LD (IY+N),D", "LD (IY+N),E", "LD (IY+N),H", "LD (IY+N),L", "LD (IY+N),A", "LD A,(IY+N)", "ADD A,(IY+N)", "ADC A,(IY+N)", "SUB (IY+N)", "SBC A,(IY+N)", "AND (IY+N)", "XOR (IY+N)", "OR (IY+N)", "CP (IY+N)", "RLC (IY+N)", "RRC (IY+N)", "RL (IY+N)", "RR (IY+N)", "SLA (IY+N)", "SRA (IY+N)", "BIT 0,(IY+N)", "BIT 1,(IY+N)", "BIT 2,(IY+N)", "BIT 3,(IY+N)", "BIT 4,(IY+N)", "BIT 5,(IY+N)", "BIT 6,(IY+N)", "BIT 7,(IY+N)", "RES 0,(IY+N)", "RES 1,(IY+N)", "RES 2,(IY+N)", "RES 3,(IY+N)", "RES 4,(IY+N)", "RES 5,(IY+N)", "RES 6,(IY+N)", "RES 7,(IY+N)", "SET 0,(IY+N)", "SET 1,(IY+N)", "SET 2,(IY+N)", "SET 3,(IY+N)", "SET 4,(IY+N)", "SET 5,(IY+N)", "SET 6,(IY+N)", "SET 7,(IY+N)", "POP IY", "EX (SP),IY", "PUSH IY", "JP (IY)", "LD SP,IY", "CP N", "RST &38"};
    public String[] Values = new String[]{"F7", "EDFF", "00", "01XXXX", "02", "03", "04", "05", "06XX", "07", "08", "09", "0A", "0B", "0C", "0D", "0EXX", "0F", "10XX", "11XXXX", "12", "13", "14", "15", "16XX", "17", "18XX", "19", "1A", "1B", "1C", "1D", "1EXX", "1F", "20XX", "21XXXX", "22XXXX", "23", "24", "25", "26XX", "27", "28XX", "29", "2AXXXX", "2B", "2C", "2D", "2EXX", "2F", "30XX", "31XXXX", "32XXXX", "33", "34", "35", "36XX", "37", "38XX", "39", "3AXXXX", "3B", "3C", "3D", "3EXX", "3F", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F", "80", "80", "81", "81", "82", "82", "83", "83", "84", "84", "85", "85", "86", "86", "87", "87", "88", "88", "89", "89", "8A", "8A", "8B", "8B", "8C", "8C", "8D", "8D", "8E", "8E", "8F", "8F", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9A", "9B", "9C", "9D", "9E", "9F", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "AA", "AB", "AC", "AD", "AE", "AF", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "BA", "BB", "BC", "BD", "BE", "BF", "C0", "C1", "C2E300", "C3E600", "C4XXXX", "C5", "C6XX", "C7", "C8", "C9", "CAF200", "CB00", "CB01", "CB02", "CB03", "CB04", "CB05", "CB06", "CB07", "CB08", "CB09", "CB0A", "CB0B", "CB0C", "CB0D", "CB0E", "CB0F", "CB10", "CB11", "CB12", "CB13", "CB14", "CB15", "CB16", "CB17", "CB18", "CB19", "CB1A", "CB1B", "CB1C", "CB1D", "CB1E", "CB1F", "CB20", "CB21", "CB22", "CB23", "CB24", "CB25", "CB26", "CB27", "CB28", "CB29", "CB2A", "CB2B", "CB2C", "CB2D", "CB2E", "CB2F", "CB38", "CB39", "CB3A", "CB3B", "CB3C", "CB3D", "CB3E", "CB3F", "CB40", "CB41", "CB42", "CB43", "CB44", "CB45", "CB46", "CB47", "CB48", "CB49", "CB4A", "CB4B", "CB4C", "CB4D", "CB4E", "CB4F", "CB50", "CB51", "CB52", "CB53", "CB54", "CB55", "CB56", "CB57", "CB58", "CB59", "CB5A", "CB5B", "CB5C", "CB5D", "CB5E", "CB5F", "CB60", "CB61", "CB62", "CB63", "CB64", "CB65", "CB66", "CB67", "CB68", "CB69", "CB6A", "CB6B", "CB6C", "CB6D", "CB6E", "CB6F", "CB70", "CB71", "CB72", "CB73", "CB74", "CB75", "CB76", "CB77", "CB78", "CB79", "CB7A", "CB7B", "CB7C", "CB7D", "CB7E", "CB7F", "CB80", "CB81", "CB82", "CB83", "CB84", "CB85", "CB86", "CB87", "CB88", "CB89", "CB8A", "CB8B", "CB8C", "CB8D", "CB8E", "CB8F", "CB90", "CB91", "CB92", "CB93", "CB94", "CB95", "CB96", "CB97", "CB98", "CB99", "CB9A", "CB9B", "CB9C", "CB9D", "CB9E", "CB9F", "CBA0", "CBA1", "CBA2", "CBA3", "CBA4", "CBA5", "CBA6", "CBA7", "CBA8", "CBA9", "CBAA", "CBAB", "CBAC", "CBAD", "CBAE", "CBAF", "CBB0", "CBB1", "CBB2", "CBB3", "CBB4", "CBB5", "CBB6", "CBB7", "CBB8", "CBB9", "CBBA", "CBBB", "CBBC", "CBBD", "CBBE", "CBBF", "CBC0", "CBC1", "CBC2", "CBC3", "CBC4", "CBC5", "CBC6", "CBC7", "CBC8", "CBC9", "CBCA", "CBCB", "CBCC", "CBCD", "CBCE", "CBCF", "CBD0", "CBD1", "CBD2", "CBD3", "CBD4", "CBD5", "CBD6", "CBD7", "CBD8", "CBD9", "CBDA", "CBDB", "CBDC", "CBDD", "CBDE", "CBDF", "CBE0", "CBE1", "CBE2", "CBE3", "CBE4", "CBE5", "CBE6", "CBE7", "CBE8", "CBE9", "CBEA", "CBEB", "CBEC", "CBED", "CBEE", "CBEF", "CBF0", "CBF1", "CBF2", "CBF3", "CBF4", "CBF5", "CBF6", "CBF7", "CBF8", "CBF9", "CBFA", "CBFB", "CBFC", "CBFD", "CBFE", "CBFF", "CCXXXX", "CDXXXX", "CEXX", "CF", "D0", "D1", "D2F002", "D3XX", "D4XXXX", "D5", "D6XX", "D7", "D8", "D9", "DAFE02", "DBXX", "DCXXXX", "DD09", "DD19", "DD21XXXX", "DD22XXXX", "DD23", "DD29", "DD2AXXXX", "DD2B", "DD34XX", "DD35XX", "DD36XXXX", "DD39", "DD46XX", "DD4EXX", "DD56XX", "DD5EXX", "DD66XX", "DD6EXX", "DD70XX", "DD71XX", "DD72XX", "DD73XX", "DD74XX", "DD75XX", "DD77XX", "DD7EXX", "DD86XX", "DD8EXX", "DD96XX", "DD9EXX", "DDA6XX", "DDAEXX", "DDB6XX", "DDBEXX", "DDCBXX06", "DDCBXX0E", "DDCBXX16", "DDCBXX1E", "DDCBXX26", "DDCBXX2E", "DDCBXX46", "DDCBXX4E", "DDCBXX56", "DDCBXX5E", "DDCBXX66", "DDCBXX6E", "DDCBXX76", "DDCBXX7E", "DDCBXX86", "DDCBXX8E", "DDCBXX96", "DDCBXX9E", "DDCBXXA6", "DDCBXXAE", "DDCBXXB6", "DDCBXXBE", "DDCBXXC6", "DDCBXXCE", "DDCBXXD6", "DDCBXXDE", "DDCBXXE6", "DDCBXXEE", "DDCBXXF6", "DDCBXXFE", "DDE1", "DDE3", "DDE5", "DDE9", "DDF9", "DEXX", "DF", "E0", "E1", "E2F103", "E3", "E4XXXX", "E5", "E6XX", "E7", "E8", "E9", "EAFE03", "EB", "EB", "ECXXXX", "ED40", "ED41", "ED42", "ED43XXXX", "ED44", "ED45", "ED46", "ED47", "ED48", "ED49", "ED4A", "ED4BXXXX", "ED4D", "ED50", "ED51", "ED52", "ED53XXXX", "ED56", "ED57", "ED58", "ED59", "ED5A", "ED5BXXXX", "ED5E", "ED60", "ED61", "ED62", "ED67", "ED68", "ED69", "ED6A", "ED6F", "ED72", "ED73XXXX", "ED78", "ED79", "ED7A", "ED7BXXXX", "EDA0", "EDA1", "EDA2", "EDA3", "EDA8", "EDA9", "EDAA", "EDAB", "EDB0", "EDB1", "EDB2", "EDB3", "EDB8", "EDB9", "EDBA", "EDBB", "EEXX", "EF", "F0", "F1", "F28204", "F3", "F4XXXX", "F5", "F6XX", "F7", "F8", "F9", "FA8F04", "FB", "FCXXXX", "FD09", "FD19", "FD21XXXX", "FD22XXXX", "FD23", "FD29", "FD2AXXXX", "FD2B", "FD34XX", "FD35XX", "FD36XXXX", "FD39", "FD46XX", "FD4EXX", "FD56XX", "FD5EXX", "FD66XX", "FD6EXX", "FD70XX", "FD71XX", "FD72XX", "FD73XX", "FD74XX", "FD75XX", "FD77XX", "FD7EXX", "FD86XX", "FD8EXX", "FD96XX", "FD9EXX", "FDA6XX", "FDAEXX", "FDB6XX", "FDBEXX", "FDCBXX06", "FDCBXX0E", "FDCBXX16", "FDCBXX1E", "FDCBXX26", "FDCBXX2E", "FDCBXX46", "FDCBXX4E", "FDCBXX56", "FDCBXX5E", "FDCBXX66", "FDCBXX6E", "FDCBXX76", "FDCBXX7E", "FDCBXX86", "FDCBXX8E", "FDCBXX96", "FDCBXX9E", "FDCBXXA6", "FDCBXXAE", "FDCBXXB6", "FDCBXXBE", "FDCBXXC6", "FDCBXXCE", "FDCBXXD6", "FDCBXXDE", "FDCBXXE6", "FDCBXXEE", "FDCBXXF6", "FDCBXXFE", "FDE1", "FDE3", "FDE5", "FDE9", "FDF9", "FEXX", "FF"};
    protected int pos = 0;
    protected String out;
    int startoff;
    int endoff;
    boolean err = false;
    String checkstring;
    protected static boolean labelfound;
    public static int actualPass;
    public int launch = 0;
    public int baslaunch = 0;
    public int bascall = 0;
    public int limit = 65535;
    public boolean hasorg = false;
    public boolean skip = false;
    public static String[] labels;
    public static String[] labeladdresses;
    protected static int label;
    public static int maxlabel;
    String[] replace;

    public String getPos() {
        return Util.hex((short)this.startoff) + "  ";
    }

    protected void setBreakpoint(String address) {
        try {
            String addressb = MathParser.parseMath(address);
            int breakp = Integer.parseInt(addressb);
            JEMU.debugger.setBreakpoint(breakp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkIF(String in) {
        if ((in = in.substring(3)).contains(" XOR ") || in.contains(" AND ") || in.contains(" OR ")) {
            int A = Integer.parseInt(this.parseMath(in));
            this.skip = A == 0;
            return;
        }
        if ((in = in.replace(" ", "")).contains("<=")) {
            int B;
            String[] inn = in.split("<=");
            String a = inn[0];
            String b = inn[1];
            int A = Integer.parseInt(this.parseMath(a));
            this.skip = A > (B = Integer.parseInt(this.parseMath(b)));
        } else if (in.contains(">=")) {
            int B;
            String[] inn = in.split(">=");
            String a = inn[0];
            String b = inn[1];
            int A = Integer.parseInt(this.parseMath(a));
            this.skip = A < (B = Integer.parseInt(this.parseMath(b)));
        } else if (in.contains("!=")) {
            int B;
            String[] inn = in.split("!=");
            String a = inn[0];
            String b = inn[1];
            int A = Integer.parseInt(this.parseMath(a));
            this.skip = A == (B = Integer.parseInt(this.parseMath(b)));
        } else if (in.contains("<>")) {
            int B;
            String[] inn = in.split("<>");
            String a = inn[0];
            String b = inn[1];
            int A = Integer.parseInt(this.parseMath(a));
            this.skip = A == (B = Integer.parseInt(this.parseMath(b)));
        } else if (in.contains("<")) {
            int B;
            String[] inn = in.split("<");
            String a = inn[0];
            String b = inn[1];
            int A = Integer.parseInt(this.parseMath(a));
            this.skip = A >= (B = Integer.parseInt(this.parseMath(b)));
        } else if (in.contains(">")) {
            int B;
            String[] inn = in.split(">");
            String a = inn[0];
            String b = inn[1];
            int A = Integer.parseInt(this.parseMath(a));
            this.skip = A <= (B = Integer.parseInt(this.parseMath(b)));
        } else if (in.contains("=")) {
            int B;
            String[] inn = in.split("=");
            String a = inn[0];
            String b = inn[1];
            int A = Integer.parseInt(this.parseMath(a));
            this.skip = A != (B = Integer.parseInt(this.parseMath(b)));
        } else {
            int A = Integer.parseInt(this.parseMath(in));
            this.skip = A == 0;
        }
    }

    public void Assemble(String input, int pass) {
        block97: {
            if (this.pos > 65535) {
                EditorPanel.errors = 9999999;
                return;
            }
            if (this.pos > this.limit) {
                EditorPanel.errors = 8888888;
                return;
            }
            while (input.startsWith(" ")) {
                input = input.substring(1);
            }
            if ((input = this.replacements(input)).toLowerCase().startsWith("end ")) {
                this.err = false;
                return;
            }
            if (input.toLowerCase().startsWith("let ")) {
                input = input.replace("LET ", "");
                String[] split = input.split("=");
                input = split[0] + " EQU " + split[1];
                while (input.contains("  ")) {
                    input = input.replace("  ", " ");
                }
            }
            if (input.startsWith("IF ")) {
                this.checkIF(input);
                this.err = false;
                return;
            }
            this.out = "";
            this.startoff = this.pos;
            if (input.contains("LD PC,HL")) {
                input = "JP (HL)";
            }
            if (input.contains("AND A,")) {
                input = input.replace("AND A,", "AND ");
            }
            if (input.contains("OR A,")) {
                input = input.replace("OR A,", "OR ");
            }
            if (input.contains("XOR A,")) {
                input = input.replace("XOR A,", "XOR ");
            }
            if (input.startsWith("ENDIF")) {
                this.skip = false;
                return;
            }
            if (this.skip) {
                this.err = false;
                return;
            }
            actualPass = pass;
            this.err = true;
            this.checkstring = input;
            if (!(input.contains("\"") || input.contains("DB ") || input.contains("DEFB ") || input.contains("DB ") || input.contains("DEFB ") || !input.contains(" $ "))) {
                input = input.replace(" $ ", " &" + Util.hex((short)this.pos) + " ");
            }
            if (!(input.contains("\"") || input.contains("DB ") || input.contains("DEFB ") || input.contains("DB ") || input.contains("DEFB ") || !input.contains(" $+"))) {
                input = input.replace("$+", "&" + Util.hex((short)this.pos) + "+");
            }
            if (!(input.contains("\"") || input.contains("DB ") || input.contains("DEFB ") || input.contains("DB ") || input.contains("DEFB ") || !input.contains(" $-"))) {
                input = input.replace("$-", "&" + Util.hex((short)this.pos) + "-");
            }
            try {
                int i;
                String inp;
                int h;
                String[] breakpoint2;
                this.err = false;
                if (pass == 1 && this.checkLabel(input) && !input.contains(" EQU ")) {
                    return;
                }
                if (pass == 2 && this.checkLabels(input)) {
                    if (input.contains(" EQU ")) {
                        this.setEQU(input);
                    }
                    return;
                }
                if (pass == 2 && this.skipLabels(input)) {
                    return;
                }
                if (labelfound) {
                    labelfound = false;
                    return;
                }
                if (input.startsWith("SET &")) {
                    input = input.replace("SET &", "SET ");
                }
                if (input.startsWith("BIT &")) {
                    input = input.replace("BIT &", "BIT ");
                }
                if (input.startsWith("RUN ")) {
                    this.err = false;
                    if ((input = input.replace("RUN ", "")).contains(",")) {
                        breakpoint2 = input.split(",");
                        input = input.split(",")[0];
                        if (JEMU.iframe == null && JEMU.debugframe == null) {
                            JEMU.showdebug = true;
                            Thread.sleep(100L);
                        }
                        if (actualPass != 1) {
                            for (h = breakpoint2.length - 1; h > 0; --h) {
                                this.setBreakpoint(breakpoint2[h]);
                            }
                        }
                    }
                    try {
                        input = MathParser.parseMath(input);
                        this.launch = Integer.parseInt(input);
                    }
                    catch (Exception breakpoint2) {}
                } else if (input.startsWith("LIMIT ")) {
                    this.err = false;
                    input = input.replace("LIMIT ", "");
                    try {
                        input = MathParser.parseMath(input);
                        this.limit = Integer.parseInt(input);
                    }
                    catch (Exception breakpoint2) {}
                } else if (input.startsWith("BASRUN ")) {
                    this.err = false;
                    if ((input = input.replace("BASRUN ", "")).contains(",")) {
                        breakpoint2 = input.split(",");
                        input = input.split(",")[0];
                        if (JEMU.iframe == null && JEMU.debugframe == null) {
                            JEMU.showdebug = true;
                            Thread.sleep(100L);
                        }
                        if (actualPass != 1) {
                            for (h = breakpoint2.length - 1; h > 0; --h) {
                                this.setBreakpoint(breakpoint2[h]);
                            }
                        }
                    }
                    try {
                        input = MathParser.parseMath(input);
                        this.baslaunch = Integer.parseInt(input);
                    }
                    catch (Exception breakpoint3) {}
                } else if (input.startsWith("BASCALL ")) {
                    this.err = false;
                    if ((input = input.replace("BASCALL ", "")).contains(",")) {
                        breakpoint2 = input.split(",");
                        input = input.split(",")[0];
                        if (JEMU.iframe == null && JEMU.debugframe == null) {
                            JEMU.showdebug = true;
                            Thread.sleep(100L);
                        }
                        if (actualPass != 1) {
                            for (h = breakpoint2.length - 1; h > 0; --h) {
                                this.setBreakpoint(breakpoint2[h]);
                            }
                        }
                    }
                    try {
                        input = MathParser.parseMath(input);
                        this.bascall = Integer.parseInt(input);
                    }
                    catch (Exception breakpoint4) {}
                } else if (input.startsWith("ORG ")) {
                    input = input.substring(3);
                    this.hasorg = true;
                    this.err = false;
                    this.pos = this.getAddress(input);
                    if (this.lowest > this.pos) {
                        this.lowest = this.pos;
                    }
                    this.startoff = this.pos;
                    if (this.DEBUG) {
                        System.out.println("  ORG:" + Util.hex((short)this.pos));
                    }
                } else if (input.contains(" EQU ")) {
                    this.err = false;
                    this.setEQU(input);
                } else if (input.startsWith("CALL")) {
                    this.err = false;
                    this.getCALL(input);
                } else if (input.startsWith("DJNZ")) {
                    this.err = false;
                    this.getDJNZ(input, this.pos);
                } else if (input.startsWith("JR ")) {
                    this.err = false;
                    this.getJR(input, this.pos);
                } else if (input.startsWith("OUT (C),0")) {
                    this.err = false;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -19;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = 113;
                } else if (input.startsWith("IN 0,(C)")) {
                    this.err = false;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -19;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = 113;
                } else {
                    this.checkString(input);
                }
                if (this.err) {
                    inp = input;
                    if (inp.endsWith(" YL") || inp.endsWith(" XL") || inp.endsWith(" YH") || inp.endsWith(" XH") || inp.contains("(YL)") || inp.contains("(XL)") || inp.contains("(YH)") || inp.contains("(XH)") || inp.contains("YL,") || inp.contains("XL,") || inp.contains("YH,") || inp.contains("XH,") || inp.contains(",YL") || inp.contains(",XL") || inp.contains(",YH") || inp.contains(",XH")) {
                        inp = inp.replace("YL", "LY");
                        inp = inp.replace("XL", "LX");
                        inp = inp.replace("YH", "HY");
                        inp = inp.replace("XH", "HX");
                    }
                    if (inp.endsWith(" HY") || inp.endsWith(" LY") || inp.endsWith(" HX") || inp.endsWith(" LX")) {
                        inp = inp.replace("HY", "IYH");
                        inp = inp.replace("HX", "IXH");
                        inp = inp.replace("LY", "IYL");
                        inp = inp.replace("LX", "IXL");
                    }
                    if (inp.contains("(HY)") || inp.contains("(LY)") || inp.contains("(HX)") || inp.contains("(LX)")) {
                        inp = inp.replace("HY", "IYH");
                        inp = inp.replace("HX", "IXH");
                        inp = inp.replace("LY", "IYL");
                        inp = inp.replace("LX", "IXL");
                    }
                    if (inp.contains(",HY") || inp.contains(",LY") || inp.contains(",HX") || inp.contains(",LX")) {
                        inp = inp.replace(",HY", ",IYH");
                        inp = inp.replace(",HX", ",IXH");
                        inp = inp.replace(",LY", ",IYL");
                        inp = inp.replace(",LX", ",IXL");
                    }
                    if (inp.contains("HY,") || inp.contains("LY,") || inp.contains("HX,") || inp.contains("LX,")) {
                        inp = inp.replace("HY,", "IYH,");
                        inp = inp.replace("HX,", "IXH,");
                        inp = inp.replace("LY,", "IYL,");
                        inp = inp.replace("LX,", "IXL,");
                    }
                    this.err = true;
                    for (i = 0; i < this.UndocumentedOpcodes.length; ++i) {
                        if (!inp.equals(this.UndocumentedOpcodes[i])) continue;
                        this.putOpcode(this.UndocumentedValues[i]);
                        this.err = false;
                        break;
                    }
                }
                if (this.err) {
                    inp = input;
                    if (inp.endsWith(" YL") || inp.endsWith(" XL") || inp.endsWith(" YH") || inp.endsWith(" XH") || inp.contains("(YL)") || inp.contains("(XL)") || inp.contains("(YH)") || inp.contains("(XH)") || inp.contains("YL,") || inp.contains("XL,") || inp.contains("YH,") || inp.contains("XH,") || inp.contains(",YL") || inp.contains(",XL") || inp.contains(",YH") || inp.contains(",XH")) {
                        inp = inp.replace("YL", "LY");
                        inp = inp.replace("XL", "LX");
                        inp = inp.replace("YH", "HY");
                        inp = inp.replace("XH", "HX");
                    }
                    if (inp.endsWith(" HY") || inp.endsWith(" LY") || inp.endsWith(" HX") || inp.endsWith(" LX")) {
                        inp = inp.replace("HY", "IYH");
                        inp = inp.replace("HX", "IXH");
                        inp = inp.replace("LY", "IYL");
                        inp = inp.replace("LX", "IXL");
                    }
                    if (inp.contains("(HY)") || inp.contains("(LY)") || inp.contains("(HX)") || inp.contains("(LX)")) {
                        inp = inp.replace("HY", "IYH");
                        inp = inp.replace("HX", "IXH");
                        inp = inp.replace("LY", "IYL");
                        inp = inp.replace("LX", "IXL");
                    }
                    if (inp.contains(",HY") || inp.contains(",LY") || inp.contains(",HX") || inp.contains(",LX")) {
                        inp = inp.replace(",HY", ",IYH");
                        inp = inp.replace(",HX", ",IXH");
                        inp = inp.replace(",LY", ",IYL");
                        inp = inp.replace(",LX", ",IXL");
                    }
                    if (inp.contains("HY,") || inp.contains("LY,") || inp.contains("HX,") || inp.contains("LX,")) {
                        inp = inp.replace("HY,", "IYH,");
                        inp = inp.replace("HX,", "IXH,");
                        inp = inp.replace("LY,", "IYL,");
                        inp = inp.replace("LX,", "IXL,");
                    }
                    for (i = 0; i < this.Opcodes.length; ++i) {
                        if (inp.startsWith("RES &")) {
                            inp = inp.replace("RES &", "RES ");
                        }
                        if (inp.startsWith("BIT &")) {
                            inp = inp.replace("BIT &", "BIT ");
                        }
                        if (inp.startsWith("SET &")) {
                            inp = inp.replace("SET &", "SET ");
                        }
                        if (inp.startsWith("XOR A,")) {
                            inp = inp.replace("XOR A,", "XOR ");
                        }
                        if (inp.startsWith("SBC A,")) {
                            inp = inp.replace("SBC A,", "SBC ");
                        }
                        if (!inp.equals(this.Opcodes[i])) continue;
                        this.putOpcode(this.Values[i]);
                        this.err = false;
                        break;
                    }
                    input = inp;
                }
                if (this.err) {
                    this.checkConsts(input);
                }
                if (this.err) {
                    this.getJP(input);
                }
                if (this.err) {
                    this.checkOut(input);
                }
                if (this.err) {
                    this.checkInstruction(input);
                }
                if (this.err && pass == 1) {
                    this.err = false;
                    this.forceLabel(input);
                }
                this.endoff = this.pos;
                if (this.startoff < this.endoff) {
                    for (int i2 = this.startoff; i2 < this.endoff; ++i2) {
                        this.out = this.out + Util.hex(this.output[i2]) + " ";
                    }
                }
                if (this.err && actualPass != 1) {
                    Interface.errorInfo.append("[Error] " + this.checkstring + " in line " + EditorPanel.actualLine + "\n");
                    ++EditorPanel.errors;
                }
            }
            catch (Exception e) {
                if (actualPass == 1) break block97;
                Interface.errorInfo.append("[Error]\nOut of memory in line " + EditorPanel.actualLine + "\n");
                ++EditorPanel.errors;
            }
        }
        if (this.highest < this.pos) {
            this.highest = this.pos;
        }
    }

    public void setEQU(String inp) {
        inp = inp.replace("EQU ", "");
        inp = inp.replace(":", "");
        int o = 0;
        String lab = "";
        while (inp.charAt(o) != ' ') {
            lab = lab + "" + inp.charAt(o++);
        }
        inp = inp.substring(lab.length());
        while (inp.startsWith(" ")) {
            inp = inp.substring(1);
        }
        String value = this.parseMath(inp);
        if (actualPass == 1) {
            int g;
            for (g = 0; g < label; ++g) {
                if (!labels[g].equals(lab.toUpperCase())) continue;
                this.err = true;
                Interface.errorInfo.append("[Error] " + this.checkstring + " in line " + EditorPanel.actualLine + ": Symbol already defined.\n");
                ++EditorPanel.errors;
                return;
            }
            for (g = 0; g < this.equ; ++g) {
                if (!EQULABEL[g].equals(lab.toUpperCase())) continue;
                this.err = true;
                Interface.errorInfo.append("[Error] " + this.checkstring + " in line " + EditorPanel.actualLine + ": Symbol already defined.\n");
                ++EditorPanel.errors;
                return;
            }
            Z80Assembler.EQULABEL[this.equ] = lab;
            Z80Assembler.EQU[this.equ++] = value;
            maxequ = this.equ;
        } else {
            for (int i = 0; i < maxequ; ++i) {
                if (!EQULABEL[i].equals(lab) || EQU[i].equals(value)) continue;
                Z80Assembler.EQU[i] = value;
            }
        }
    }

    public void putOpcode(String in) {
        String found = "";
        while (in.length() != 0) {
            for (int i = 0; i < 2; ++i) {
                found = found + "" + in.charAt(i);
            }
            found = "&" + found;
            this.setByte(found);
            found = "";
            in = in.substring(2);
        }
    }

    public void checkOut(String in) {
        if (in.startsWith("DEC (")) {
            in = in.replace("DEC (", "");
            this.err = false;
            if (in.startsWith("IX")) {
                this.setWord("&35DD");
            } else {
                this.setWord("&35FD");
            }
            in = in.replace(")", "");
            this.setByte(in);
            return;
        }
        if (in.startsWith("INC (")) {
            this.err = false;
            if ((in = in.replace("INC (", "")).startsWith("IX")) {
                this.setWord("&34DD");
            } else {
                this.setWord("&34FD");
            }
            in = in.replace(")", "");
            this.setByte(in);
            return;
        }
        if (in.startsWith("RLC ")) {
            this.err = false;
            if (in.contains("IX")) {
                this.setWord("&CBDD");
            } else {
                this.setWord("&CBFD");
            }
            in = in.replace("RLC ", "");
            in = in.replace("(", "");
            in = in.replace(")", "");
            this.setByte(in);
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 6;
            return;
        }
        if (in.startsWith("RRC ")) {
            this.err = false;
            if (in.contains("IX")) {
                this.setWord("&CBDD");
            } else {
                this.setWord("&CBFD");
            }
            in = in.replace("RRC ", "");
            in = in.replace("(", "");
            in = in.replace(")", "");
            this.setByte(in);
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 14;
            return;
        }
        if (in.startsWith("RL ")) {
            this.err = false;
            if (in.contains("IX")) {
                this.setWord("&CBDD");
            } else {
                this.setWord("&CBFD");
            }
            in = in.replace("RL ", "");
            in = in.replace("(", "");
            in = in.replace(")", "");
            this.setByte(in);
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 22;
            return;
        }
        if (in.startsWith("RR ")) {
            this.err = false;
            if (in.contains("IX")) {
                this.setWord("&CBDD");
            } else {
                this.setWord("&CBFD");
            }
            in = in.replace("RR ", "");
            in = in.replace("(", "");
            in = in.replace(")", "");
            this.setByte(in);
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 30;
            return;
        }
        if (in.startsWith("BIT ")) {
            this.err = false;
            if (in.contains("IX")) {
                this.setWord("&CBDD");
            } else {
                this.setWord("&CBFD");
            }
            in = in.replace("BIT ", "");
            if (in.startsWith("&")) {
                in = in.substring(1);
            }
            byte a = this.getNumericValue(in.substring(0, 1));
            in = in.substring(2, in.length());
            in = in.replace("(", "");
            in = in.replace(")", "");
            in = in.replace(",", "");
            this.setByte(in);
            switch (a) {
                case 0: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = 70;
                    return;
                }
                case 1: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = 78;
                    return;
                }
                case 2: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = 86;
                    return;
                }
                case 3: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = 94;
                    return;
                }
                case 4: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = 102;
                    return;
                }
                case 5: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = 110;
                    return;
                }
                case 6: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = 118;
                    return;
                }
                case 7: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = 126;
                    return;
                }
            }
            this.err = true;
            return;
        }
        if (in.startsWith("RES ")) {
            this.err = false;
            if (in.contains("IX")) {
                this.setWord("&CBDD");
            } else {
                this.setWord("&CBFD");
            }
            in = in.replace("RES ", "");
            byte a = this.getNumericValue(in.substring(0, 1));
            in = in.substring(2, in.length());
            in = in.replace("(", "");
            in = in.replace(")", "");
            in = in.replace(",", "");
            this.setByte(in);
            switch (a) {
                case 0: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -122;
                    return;
                }
                case 1: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -114;
                    return;
                }
                case 2: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -106;
                    return;
                }
                case 3: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -98;
                    return;
                }
                case 4: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -90;
                    return;
                }
                case 5: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -82;
                    return;
                }
                case 6: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -74;
                    return;
                }
                case 7: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -66;
                    return;
                }
            }
            this.err = true;
            return;
        }
        if (in.startsWith("SET ")) {
            this.err = false;
            if (in.contains(",(IY")) {
                this.setWord("&CBFD");
            } else {
                this.setWord("&CBDD");
            }
            in = in.replace("SET ", "");
            byte a = this.getNumericValue(in.substring(0, 1));
            in = in.substring(2, in.length());
            in = in.replace("(", "");
            in = in.replace(")", "");
            in = in.replace(",", "");
            this.setByte(in);
            switch (a) {
                case 0: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -58;
                    return;
                }
                case 1: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -50;
                    return;
                }
                case 2: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -42;
                    return;
                }
                case 3: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -34;
                    return;
                }
                case 4: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -26;
                    return;
                }
                case 5: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -18;
                    return;
                }
                case 6: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -10;
                    return;
                }
                case 7: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -2;
                    return;
                }
            }
            this.err = true;
            return;
        }
        if (in.startsWith("OUT")) {
            this.err = false;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -45;
            in = in.replace("OUT", "");
            in = in.replace("(", "");
            in = in.replace(")", "");
            in = in.replace(",A", "");
            this.setByte(in);
            return;
        }
        if (in.startsWith("IN ")) {
            this.err = false;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -37;
            in = in.replace("IN ", "");
            in = in.replace("(", "");
            in = in.replace(")", "");
            in = in.replace("A,", "");
            this.setByte(in);
            return;
        }
        this.err = true;
    }

    protected String replacements(String in) {
        if (in.startsWith("CP A,")) {
            in = in.replace("CP A,", "CP ");
        }
        if (in.startsWith("OR A,")) {
            in = in.replace("OR A,", "OR ");
        }
        if (in.startsWith("AND A,")) {
            in = in.replace("AND A,", "AND ");
        }
        if (in.startsWith("SUB A,")) {
            in = in.replace("SUB A,", "SUB ");
        }
        if (in.startsWith("SBC A,")) {
            in = in.replace("SBC A,", "SBC ");
        }
        if (in.startsWith("XOR A,")) {
            in = in.replace("XOR A,", "XOR ");
        }
        return in;
    }

    public void checkConsts(String in) {
        if (in.startsWith("ADD ")) {
            this.err = false;
            if ((in = in.replace("ADD ", "")).contains(",")) {
                in = in.substring(2);
            }
            if (in.contains("(")) {
                if (in.contains("IX")) {
                    in = in.replace("(", "");
                    in = in.replace(")", "");
                    in = in.replace("IX", "0");
                    in = this.parseMath(in);
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -35;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -122;
                    this.setByte(in);
                    return;
                }
                if (in.contains("IY")) {
                    in = in.replace("(", "");
                    in = in.replace(")", "");
                    in = in.replace("IY", "0");
                    in = this.parseMath(in);
                    in = MathParser.parseMath(in);
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -3;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -122;
                    this.setByte(in);
                    return;
                }
                this.err = true;
                return;
            }
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -58;
            if (!in.contains("\"")) {
                in = this.parseMath(in);
                this.setByte(in);
            } else {
                in = in.replace("\"", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = (byte)in.charAt(0);
            }
            return;
        }
        if (in.startsWith("ADC")) {
            this.err = false;
            if ((in = in.replace("ADC ", "")).contains(",")) {
                in = in.substring(2);
            }
            if (in.contains("(")) {
                if (in.contains("IX")) {
                    in = in.replace("(", "");
                    in = in.replace(")", "");
                    in = in.replace("IX", "0");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -35;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -114;
                    this.setByte(in);
                    return;
                }
                if (in.contains("IY")) {
                    in = in.replace("(", "");
                    in = in.replace(")", "");
                    in = in.replace("IY", "0");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -3;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -114;
                    this.setByte(in);
                    return;
                }
                this.err = true;
                return;
            }
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -50;
            this.setByte(in);
            return;
        }
        if (in.startsWith("LD IXH,")) {
            System.out.println("IXH found in line" + EditorPanel.actualLine);
            this.err = false;
            in = in.replace("LD IXH,", "");
            this.setWord("&26DD");
            this.setByte(in);
            return;
        }
        if (in.startsWith("LD IXL,")) {
            System.out.println("IXL found in line" + EditorPanel.actualLine);
            this.err = false;
            in = in.replace("LD IXL,", "");
            this.setWord("&2EDD");
            this.setByte(in);
            return;
        }
        if (in.startsWith("LD IYH,")) {
            System.out.println("IYH found in line" + EditorPanel.actualLine);
            this.err = false;
            in = in.replace("LD IYH,", "");
            this.setWord("&26FD");
            this.setByte(in);
            return;
        }
        if (in.startsWith("LD IYL,")) {
            System.out.println("IYL found in line" + EditorPanel.actualLine);
            this.err = false;
            in = in.replace("LD IYL,", "");
            this.setWord("&2EFD");
            this.setByte(in);
            return;
        }
        if (in.startsWith("LD (IX") && in.contains("),A")) {
            this.err = false;
            in = in.replace("LD (", "");
            in = in.replace("),A", "");
            this.setWord("&77DD");
            this.setByte(in);
            return;
        }
        if (in.startsWith("LD (IX") && in.contains("),B")) {
            this.err = false;
            in = in.replace("LD (", "");
            in = in.replace("),B", "");
            this.setWord("&70DD");
            this.setByte(in);
            return;
        }
        if (in.startsWith("LD (IX") && in.contains("),C")) {
            this.err = false;
            in = in.replace("LD (", "");
            in = in.replace("),C", "");
            this.setWord("&71DD");
            this.setByte(in);
            return;
        }
        if (in.startsWith("LD (IX") && in.contains("),D")) {
            this.err = false;
            in = in.replace("LD (", "");
            in = in.replace("),D", "");
            this.setWord("&72DD");
            this.setByte(in);
            return;
        }
        if (in.startsWith("LD (IX") && in.contains("),E")) {
            this.err = false;
            in = in.replace("LD (", "");
            in = in.replace("),E", "");
            this.setWord("&73DD");
            this.setByte(in);
            return;
        }
        if (in.startsWith("LD (IX") && in.contains("),H")) {
            this.err = false;
            in = in.replace("LD (", "");
            in = in.replace("),H", "");
            this.setWord("&74DD");
            this.setByte(in);
            return;
        }
        if (in.startsWith("LD (IX") && in.contains("),L")) {
            this.err = false;
            in = in.replace("LD (", "");
            in = in.replace("),L", "");
            this.setWord("&75DD");
            this.setByte(in);
            return;
        }
        if (in.startsWith("LD (IX+") && in.contains("),")) {
            this.err = false;
            in = in.replace("LD (", "");
            in = in.replace(")", "");
            this.setWord("&36DD");
            in = in.replace("IX+", "");
            String[] array = in.split(",");
            array[0] = array[0].replace(",", "");
            array[1] = array[1].replace(",", "");
            this.setByte(array[0]);
            this.setByte(array[1]);
            return;
        }
        if (in.startsWith("LD (IY") && in.contains("),A")) {
            this.err = false;
            in = in.replace("LD (", "");
            in = in.replace("),A", "");
            this.setWord("&77FD");
            this.setByte(in);
            return;
        }
        if (in.startsWith("LD (IY") && in.contains("),B")) {
            this.err = false;
            in = in.replace("LD (", "");
            in = in.replace("),B", "");
            this.setWord("&70FD");
            this.setByte(in);
            return;
        }
        if (in.startsWith("LD (IY") && in.contains("),C")) {
            this.err = false;
            in = in.replace("LD (", "");
            in = in.replace("),C", "");
            this.setWord("&71FD");
            this.setByte(in);
            return;
        }
        if (in.startsWith("LD (IY") && in.contains("),D")) {
            this.err = false;
            in = in.replace("LD (", "");
            in = in.replace("),D", "");
            this.setWord("&72FD");
            this.setByte(in);
            return;
        }
        if (in.startsWith("LD (IY") && in.contains("),E")) {
            this.err = false;
            in = in.replace("LD (", "");
            in = in.replace("),E", "");
            this.setWord("&73FD");
            this.setByte(in);
            return;
        }
        if (in.startsWith("LD (IY") && in.contains("),H")) {
            this.err = false;
            in = in.replace("LD (", "");
            in = in.replace("),H", "");
            this.setWord("&74FD");
            this.setByte(in);
            return;
        }
        if (in.startsWith("LD (IY") && in.contains("),L")) {
            this.err = false;
            in = in.replace("LD (", "");
            in = in.replace("),L", "");
            this.setWord("&75FD");
            this.setByte(in);
            return;
        }
        if (in.startsWith("LD (IY+") && in.contains("),")) {
            this.err = false;
            in = in.replace("LD (", "");
            in = in.replace(")", "");
            this.setWord("&36FD");
            in = in.replace("IY+", "");
            String[] array = in.split(",");
            array[0] = array[0].replace(",", "");
            array[1] = array[1].replace(",", "");
            this.setByte(array[0]);
            this.setByte(array[1]);
            return;
        }
        if (in.startsWith("LD (")) {
            in = in.replace("LD (", "");
            if ((in = in.replace(")", "")).endsWith(",A")) {
                this.err = false;
                in = in.replace(",A", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 50;
                this.setWord(in);
                return;
            }
            if (in.endsWith(",IX")) {
                this.err = false;
                in = in.replace(",IX", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -35;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 34;
                this.setWord(in);
                return;
            }
            if (in.endsWith(",IY")) {
                this.err = false;
                in = in.replace(",IY", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -3;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 34;
                this.setWord(in);
                return;
            }
            if (in.endsWith(",BC")) {
                this.err = false;
                in = in.replace(",BC", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -19;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 67;
                this.setWord(in);
                return;
            }
            if (in.endsWith(",DE")) {
                this.err = false;
                in = in.replace(",DE", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -19;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 83;
                this.setWord(in);
                return;
            }
            if (in.endsWith(",SP")) {
                this.err = false;
                in = in.replace(",SP", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -19;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 115;
                this.setWord(in);
                return;
            }
            if (in.endsWith(",HL")) {
                this.err = false;
                in = in.replace(",HL", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 34;
                this.setWord(in);
                return;
            }
        }
        if (in.contains("CP ")) {
            in = in.replace("CP ", "");
            this.err = false;
            if (in.contains("(")) {
                in = in.replace("(", "");
                if ((in = in.replace(")", "")).startsWith("IX")) {
                    in = in.replace("IX", "0");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -35;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -66;
                    this.setByte(in);
                    return;
                }
                if (in.startsWith("IY")) {
                    in = in.replace("IY", "0");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -3;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -66;
                    this.setByte(in);
                    return;
                }
                this.err = true;
                return;
            }
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -2;
            this.setByte(in);
            return;
        }
        if (in.startsWith("XOR ")) {
            this.err = false;
            in = in.replace("XOR ", "");
            if ((in = in.replace(",", "")).contains("IX")) {
                in = in.replace("(", "");
                in = in.replace(")", "");
                in = in.replace("IX", "0");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -35;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -82;
                this.setByte(in);
                return;
            }
            if (in.contains("IY")) {
                in = in.replace("(", "");
                in = in.replace(")", "");
                in = in.replace("IY", "0");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -3;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -82;
                this.setByte(in);
                return;
            }
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -18;
            this.setByte(in);
            return;
        }
        if (in.contains("OR ")) {
            in = in.replace("OR ", "");
            in = in.replace(",", "");
            this.err = false;
            if (in.contains("(")) {
                in = in.replace("(", "");
                if ((in = in.replace(")", "")).startsWith("IX")) {
                    in = in.replace("IX", "0");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -35;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -74;
                    this.setByte(in);
                    return;
                }
                if (in.startsWith("IY")) {
                    in = in.replace("IY", "0");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -3;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -74;
                    this.setByte(in);
                    return;
                }
                this.err = true;
                return;
            }
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -10;
            this.setByte(in);
            return;
        }
        if (in.contains("SUB ")) {
            in = in.replace("SUB ", "");
            in = in.replace(",", "");
            this.err = false;
            if (in.contains("(")) {
                in = in.replace("(", "");
                if ((in = in.replace(")", "")).startsWith("IX")) {
                    in = in.replace("IX", "0");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -35;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -106;
                    this.setByte(in);
                    return;
                }
                if (in.startsWith("IY")) {
                    in = in.replace("IY", "0");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -3;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -106;
                    this.setByte(in);
                    return;
                }
                this.err = true;
                return;
            }
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -42;
            this.setByte(in);
            return;
        }
        if (in.contains("AND ")) {
            in = in.replace("AND ", "");
            in = in.replace(",", "");
            this.err = false;
            if (in.contains("(")) {
                in = in.replace("(", "");
                if ((in = in.replace(")", "")).startsWith("IX")) {
                    in = in.replace("IX", "0");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -35;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -90;
                    this.setByte(in);
                    return;
                }
                if (in.startsWith("IY")) {
                    in = in.replace("IY", "0");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -3;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -90;
                    this.setByte(in);
                    return;
                }
                this.err = true;
                return;
            }
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -26;
            this.setByte(in);
            return;
        }
        if (in.startsWith("SLA (IX")) {
            this.err = false;
            in = in.substring(5);
            in = in.replace(")", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -35;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -53;
            this.setByte(in);
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 38;
            return;
        }
        if (in.startsWith("SLA (IY")) {
            this.err = false;
            in = in.substring(5);
            in = in.replace(")", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -3;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -53;
            this.setByte(in);
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 38;
            return;
        }
        if (in.startsWith("SRA (IX")) {
            this.err = false;
            in = in.substring(5);
            in = in.replace(")", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -35;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -53;
            this.setByte(in);
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 46;
            return;
        }
        if (in.startsWith("SRA (IY")) {
            this.err = false;
            in = in.substring(5);
            in = in.replace(")", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -3;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -53;
            this.setByte(in);
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 46;
            return;
        }
        if (in.contains("SBC ")) {
            in = in.replace("SBC ", "");
            in = in.replace(",", "");
            this.err = false;
            if (in.contains("(")) {
                in = in.replace("(", "");
                if ((in = in.replace(")", "")).startsWith("IX")) {
                    in = in.replace("IX", "0");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -35;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -98;
                    this.setByte(in);
                    return;
                }
                if (in.startsWith("IY")) {
                    in = in.replace("IY", "0");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -3;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -98;
                    this.setByte(in);
                    return;
                }
                this.err = true;
                return;
            }
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -34;
            this.setByte(in);
            return;
        }
        this.err = true;
    }

    public void prepareLabels() {
        labels = new String[65535];
        labeladdresses = new String[65535];
        for (int i = 0; i < labels.length; ++i) {
            Z80Assembler.labeladdresses[i] = "&0000";
            Z80Assembler.labels[i] = "xXXXx javacpc reserved label xXXXx";
            label = 0;
            maxlabel = 0;
        }
    }

    public void prepareEQU() {
        EQULABEL = new String[65535];
        EQU = new String[65535];
        for (int i = 0; i < EQU.length; ++i) {
            Z80Assembler.EQU[i] = "&0000";
            Z80Assembler.EQULABEL[i] = "xXXXx javacpc reserved equ xXXXx";
            this.equ = 0;
            maxequ = 0;
        }
    }

    public boolean checkLabel(String in) {
        if (in.contains(" EQU ")) {
            return false;
        }
        if (in.endsWith(":") || in.startsWith(".")) {
            int g;
            in = in.replace(":", "");
            in = in.replace(".", "");
            this.err = false;
            Z80Assembler.labeladdresses[Z80Assembler.label] = "&" + Util.hex((short)this.pos);
            for (g = 0; g < label; ++g) {
                if (!labels[g].equals(in.toUpperCase())) continue;
                this.err = true;
                Interface.errorInfo.append("[Error] " + this.checkstring + " in line " + EditorPanel.actualLine + ": Symbol already defined.\n");
                ++EditorPanel.errors;
                return false;
            }
            for (g = 0; g < this.equ; ++g) {
                if (!EQULABEL[g].equals(in.toUpperCase())) continue;
                this.err = true;
                Interface.errorInfo.append("[Error] " + this.checkstring + " in line " + EditorPanel.actualLine + ": Symbol already defined.\n");
                ++EditorPanel.errors;
                return false;
            }
            Z80Assembler.labels[Z80Assembler.label++] = in.toUpperCase();
            maxlabel = label;
            return true;
        }
        return false;
    }

    public boolean checkLabels(String in) {
        if (in.contains(" EQU ")) {
            this.err = true;
            return true;
        }
        if (in.endsWith(":") || in.startsWith(".")) {
            this.err = false;
            return true;
        }
        return false;
    }

    public void forceLabel(String in) {
        String b = "";
        if (in.contains("EQU ")) {
            this.err = true;
            return;
        }
        if (in.contains(" ")) {
            String a = in;
            String c = "";
            boolean put = false;
            for (int i = 0; i < a.length(); ++i) {
                if (a.charAt(i) == ' ') {
                    put = true;
                }
                if (put) {
                    b = b + a.charAt(i);
                    continue;
                }
                c = c + a.charAt(i);
            }
            in = c;
            return;
        }
        this.err = false;
        if (in.length() > 0) {
            int g;
            Z80Assembler.labeladdresses[Z80Assembler.label] = "&" + Util.hex((short)this.pos);
            if (in.startsWith(".")) {
                in = in.substring(1);
            }
            for (g = 0; g < label; ++g) {
                if (!labels[g].equals(in.toUpperCase())) continue;
                this.err = true;
                Interface.errorInfo.append("[Error] " + this.checkstring + " in line " + EditorPanel.actualLine + ": Symbol already defined.\n");
                ++EditorPanel.errors;
                return;
            }
            for (g = 0; g < this.equ; ++g) {
                if (!EQULABEL[g].equals(in.toUpperCase())) continue;
                this.err = true;
                Interface.errorInfo.append("[Error] " + this.checkstring + " in line " + EditorPanel.actualLine + ": Symbol already defined.\n");
                ++EditorPanel.errors;
                return;
            }
            Z80Assembler.labels[Z80Assembler.label++] = in.toUpperCase();
            maxlabel = label;
        }
        if (b.length() > 0) {
            while (b.startsWith(" ")) {
                b = b.substring(1);
            }
            this.Assemble(b, actualPass);
        }
    }

    public static String putEQU(String in) {
        if (!in.startsWith(".") && !in.endsWith(":")) {
            for (int i = 0; i < maxequ; ++i) {
                if (!in.equals(EQULABEL[i])) continue;
                in = in.replace(EQULABEL[i], EQU[i]);
                break;
            }
        }
        return in;
    }

    public static String setLabels(String in) {
        if (!in.startsWith(".") && !in.endsWith(":")) {
            for (int i = 0; i < maxlabel; ++i) {
                if (!in.equals(labels[i]) || labels[i].length() <= 0) continue;
                in = in.replace(labels[i], labeladdresses[i]);
                break;
            }
        }
        if (in.startsWith(".") || in.endsWith(":")) {
            labelfound = true;
        }
        return in;
    }

    public boolean skipLabels(String in) {
        for (int i = 0; i < maxlabel; ++i) {
            for (int k = 0; k < in.length(); ++k) {
                if (!in.equals(labeladdresses[i]) && !in.equals(labels[i]) || labels[i].length() <= 0) continue;
                this.err = false;
                return true;
            }
        }
        return false;
    }

    public void checkString(String in) {
        this.err = false;
        if (in.startsWith("DEFB ") || in.startsWith("DEFM ")) {
            in = in.substring(4);
            in = "DB" + in;
        }
        if (in.startsWith("DEFW ")) {
            in = in.substring(4);
            in = "DW" + in;
        }
        if (in.startsWith("DEFS ")) {
            in = in.substring(5);
            String count = "";
            int i = 0;
            if (!in.contains(",")) {
                in = in + ",0";
            }
            while (in.charAt(i) != ',') {
                count = count + in.charAt(i);
                ++i;
            }
            in = in.substring(i);
            in = in.replace(",", "");
            i = Integer.parseInt(this.parseMath(count));
            for (int g = 0; g < i; ++g) {
                this.setByte(in);
            }
            this.err = false;
            return;
        }
        if (in.startsWith("DS ")) {
            byte value = 0;
            in = in.substring(3);
            in = in.replace("#", "&");
            if ((in = in.replace("$", "&")).contains(",")) {
                String[] newS = in.split(",");
                newS[0] = newS[0].replace(",", "");
                newS[1] = newS[1].replace(",", "");
                newS[0] = MathParser.parseMath(newS[0]);
                newS[1] = MathParser.parseMath(newS[1]);
                value = (byte)Integer.parseInt(newS[1]);
                in = newS[0];
            }
            this.err = false;
            in = this.parseMath(in);
            int i = Integer.parseInt(in);
            for (int g = 0; g < i; ++g) {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = value;
            }
            return;
        }
        if (in.startsWith("DB ")) {
            in = in.substring(3);
            String[] array = in.split(",");
            boolean charcase = false;
            for (int i = 0; i < array.length; ++i) {
                boolean string = false;
                if (array[i].startsWith("\"")) {
                    charcase = false;
                    string = true;
                } else if (array[i].startsWith("'")) {
                    charcase = true;
                    string = true;
                }
                array[i].replace(",", "");
                array[i] = array[i].replace('\u0001', ',');
                if (!string) {
                    this.setByte("" + array[i]);
                    continue;
                }
                if ((array[i].contains("&") || array[i].contains("#") || array[i].contains("$")) && (array[i].contains("\"+") || array[i].contains("\"-") || array[i].contains("\"*") || array[i].contains("\"/"))) {
                    array[i] = !charcase ? array[i].replace("\"", "") : array[i].replace("'", "");
                    array[i] = this.calculateChar(array[i]);
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = (byte)Integer.parseInt(array[i]);
                    this.err = false;
                    return;
                }
                array[i] = !charcase ? array[i].replace("\"", "") : array[i].replace("'", "");
                for (int g = 0; g < array[i].length(); ++g) {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = (byte)array[i].charAt(g);
                }
            }
            return;
        }
        if (in.startsWith("DW ")) {
            in = in.substring(3);
            String[] array = in.split(",");
            for (int i = 0; i < array.length; ++i) {
                array[i].replace(",", "");
                this.setWord(array[i]);
            }
            return;
        }
        if (in.startsWith("CP \"")) {
            in = in.substring(4);
            in = in.replace("\"", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -2;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = (byte)in.charAt(0);
            return;
        }
        this.err = true;
    }

    protected String calculateChar(String in) {
        char i = in.charAt(0);
        in = in.substring(1);
        in = "&" + Util.hex((byte)i) + in;
        in = MathParser.parseMath(in);
        if (actualPass != 1 && in == null && EditorPanel.actualLine != 0) {
            Interface.errorInfo.append("Null exception in calculateChar!\n");
            Interface.errorInfo.append(this.checkstring + " in line " + EditorPanel.actualLine + "\n");
            ++EditorPanel.errors;
            this.err = true;
        }
        return in;
    }

    protected void doRST(String in) {
        String[] spl = in.split(",");
        int num = Integer.parseInt(spl[0]);
        switch (num) {
            case 1: {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -49;
                this.setWord(spl[1]);
                break;
            }
            case 2: {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -41;
                this.setWord(spl[1]);
                break;
            }
            case 3: {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -33;
                this.setWord(spl[1]);
                break;
            }
            case 5: {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -17;
                this.setWord(spl[1]);
                break;
            }
            case 8: {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -49;
                this.setWord(spl[1]);
                break;
            }
            case 16: {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -41;
                this.setWord(spl[1]);
                break;
            }
            case 24: {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -33;
                this.setWord(spl[1]);
                break;
            }
            case 32: {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -25;
                this.setWord(spl[1]);
                break;
            }
            case 40: {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -17;
                this.setWord(spl[1]);
                break;
            }
            case 48: {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -9;
                this.setWord(spl[1]);
                break;
            }
            case 56: {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -1;
                this.setWord(spl[1]);
                break;
            }
            default: {
                this.err = true;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkInstruction(String in) {
        if (in.startsWith("RST")) {
            this.err = false;
            in = in.replace("RST", "");
            if ((in = in.replace(" ", "")).contains(",")) {
                this.doRST(in);
                return;
            }
            in = in.replace("&", "");
            byte a = this.getNumericValue(in);
            switch (a) {
                case 0: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -57;
                    return;
                }
                case 8: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -49;
                    return;
                }
                case 16: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -41;
                    return;
                }
                case 24: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -33;
                    return;
                }
                case 32: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -25;
                    return;
                }
                case 40: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -17;
                    return;
                }
                case 48: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -9;
                    return;
                }
                case 56: {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -1;
                    return;
                }
            }
            this.err = true;
        }
        if (in.contains("LD BC,")) {
            this.err = false;
            if (in.contains("(")) {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -19;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 75;
            } else {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 1;
            }
            in = in.substring(6);
            in = in.replace("(", "");
            in = in.replace(")", "");
            in = in.replace(",", "");
            this.setWord(in);
            return;
        }
        if (in.contains("LD DE,")) {
            this.err = false;
            if (in.contains("(")) {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -19;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 91;
            } else {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 17;
            }
            in = in.substring(6);
            in = in.replace("(", "");
            in = in.replace(")", "");
            in = in.replace(",", "");
            this.setWord(in);
            return;
        }
        if (in.contains("LD HL,")) {
            this.err = false;
            if (in.contains("(")) {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 42;
            } else {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 33;
            }
            in = in.substring(6);
            in = in.replace("(", "");
            in = in.replace(")", "");
            in = in.replace(",", "");
            this.setWord(in);
            return;
        }
        if (in.contains("LD (HL),")) {
            in = in.replace("LD (HL),", "");
            this.err = false;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 54;
            this.setByte(in);
            return;
        }
        if (in.contains("LD A,")) {
            in = in.replace("LD A,", "");
            this.err = false;
            if (!in.contains("(")) {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 62;
                this.setByte(in);
                return;
            }
            in = in.replace("(", "");
            if ((in = in.replace(")", "")).startsWith("IX")) {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -35;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 126;
                this.setByte(in);
                return;
            }
            if (in.startsWith("IY")) {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -3;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 126;
                this.setByte(in);
                return;
            }
            in = in.replace("(", "");
            in = in.replace(")", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 58;
            this.setWord(in);
            return;
        }
        if (in.contains("LD B,")) {
            in = in.replace("LD B,", "");
            this.err = false;
            if (!in.contains("(")) {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 6;
                this.setByte(in);
                return;
            }
            if (in.contains("IX")) {
                in = in.replace("(", "");
                in = in.replace(")", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -35;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 70;
                in = in.replace("IX", "0");
                this.setByte(in);
                return;
            }
            if (in.contains("IY")) {
                in = in.replace("(", "");
                in = in.replace(")", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -3;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 70;
                in = in.replace("IY", "0");
                this.setByte(in);
                return;
            }
        } else if (in.contains("LD C,")) {
            in = in.replace("LD C,", "");
            this.err = false;
            if (!in.contains("(")) {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 14;
                this.setByte(in);
                return;
            }
            if (in.contains("IX")) {
                in = in.replace("(", "");
                in = in.replace(")", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -35;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 78;
                in = in.replace("IX", "0");
                this.setByte(in);
                return;
            }
            if (in.contains("IY")) {
                in = in.replace("(", "");
                in = in.replace(")", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -3;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 78;
                in = in.replace("IY", "0");
                this.setByte(in);
                return;
            }
        } else if (in.contains("LD D,")) {
            in = in.replace("LD D,", "");
            this.err = false;
            if (!in.contains("(")) {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 22;
                this.setByte(in);
                return;
            }
            if (in.contains("IX")) {
                in = in.replace("(", "");
                in = in.replace(")", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -35;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 86;
                in = in.replace("IX", "0");
                this.setByte(in);
                return;
            }
            if (in.contains("IY")) {
                in = in.replace("(", "");
                in = in.replace(")", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -3;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 86;
                in = in.replace("IY", "0");
                this.setByte(in);
                return;
            }
        } else if (in.contains("LD E,")) {
            in = in.replace("LD E,", "");
            this.err = false;
            if (!in.contains("(")) {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 30;
                this.setByte(in);
                return;
            }
            if (in.contains("IX")) {
                in = in.replace("(", "");
                in = in.replace(")", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -35;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 94;
                in = in.replace("IX", "0");
                this.setByte(in);
                return;
            }
            if (in.contains("IY")) {
                in = in.replace("(", "");
                in = in.replace(")", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -3;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 94;
                in = in.replace("IY", "");
                in = in.replace("IY", "0");
                this.setByte(in);
                return;
            }
        } else if (in.contains("LD H,")) {
            in = in.replace("LD H,", "");
            this.err = false;
            if (!in.contains("(")) {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 38;
                this.setByte(in);
                return;
            }
            if (in.contains("IX")) {
                in = in.replace("(", "");
                in = in.replace(")", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -35;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 102;
                in = in.replace("IX", "0");
                this.setByte(in);
                return;
            }
            if (in.contains("IY")) {
                in = in.replace("(", "");
                in = in.replace(")", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -3;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 102;
                in = in.replace("IY", "0");
                this.setByte(in);
                return;
            }
        } else if (in.contains("LD L,")) {
            in = in.replace("LD L,", "");
            this.err = false;
            if (!in.contains("(")) {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 46;
                this.setByte(in);
                return;
            }
            if (in.contains("IX")) {
                in = in.replace("(", "");
                in = in.replace(")", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -35;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 110;
                in = in.replace("IX", "0");
                this.setByte(in);
                return;
            }
            if (in.contains("IY")) {
                in = in.replace("(", "");
                in = in.replace(")", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = -3;
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 110;
                in = in.replace("IY", "0");
                this.setByte(in);
                return;
            }
        } else {
            if (in.contains("LD SP,")) {
                in = in.replace("LD SP,", "");
                this.err = false;
                if (in.contains("(")) {
                    in = in.replace("(", "");
                    in = in.replace(")", "");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -19;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = 123;
                    this.setWord(in);
                    return;
                }
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 49;
                this.setWord(in);
                return;
            }
            if (in.contains("LD (")) {
                in = in.replace("LD (", "");
                in = in.replace(")", "");
                this.err = false;
                if (in.contains(",BC")) {
                    in = in.replace(",BC", "");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -19;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = 67;
                    this.setWord(in);
                    return;
                }
                if (in.contains(",DE")) {
                    in = in.replace(",DE", "");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -19;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = 83;
                    this.setWord(in);
                    return;
                }
                if (in.contains(",SP")) {
                    in = in.replace(",SP", "");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -19;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = 115;
                    this.setWord(in);
                    return;
                }
                if (in.contains("IX+")) {
                    this.LDIX(in, false);
                    return;
                }
                if (in.contains("IY+")) {
                    this.LDIY(in, false);
                    return;
                }
                if (in.contains("IX-")) {
                    this.LDIX(in, true);
                    return;
                }
                if (in.contains("IY-")) {
                    this.LDIY(in, true);
                    return;
                }
                if (in.contains(",IX")) {
                    in = in.replace(",IX", "");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -35;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = 34;
                    this.setWord(in);
                    return;
                }
            } else {
                if (in.contains("LD IY")) {
                    in = in.replace("LD IY", "");
                    this.err = false;
                    if ((in = in.replace(",", "")).contains("(")) {
                        in = in.replace("(", "");
                        in = in.replace(")", "");
                        EditorPanel.hasdata[this.pos] = true;
                        this.output[this.pos++] = -3;
                        EditorPanel.hasdata[this.pos] = true;
                        this.output[this.pos++] = 42;
                    } else {
                        EditorPanel.hasdata[this.pos] = true;
                        this.output[this.pos++] = -3;
                        EditorPanel.hasdata[this.pos] = true;
                        this.output[this.pos++] = 33;
                    }
                    this.setWord(in);
                    return;
                }
                if (in.contains("LD IX")) {
                    in = in.replace("LD IX", "");
                    this.err = false;
                    if ((in = in.replace(",", "")).contains("(")) {
                        in = in.replace("(", "");
                        in = in.replace(")", "");
                        EditorPanel.hasdata[this.pos] = true;
                        this.output[this.pos++] = -35;
                        EditorPanel.hasdata[this.pos] = true;
                        this.output[this.pos++] = 42;
                    } else {
                        EditorPanel.hasdata[this.pos] = true;
                        this.output[this.pos++] = -35;
                        EditorPanel.hasdata[this.pos] = true;
                        this.output[this.pos++] = 33;
                    }
                    this.setWord(in);
                    return;
                }
                if (in.endsWith(",IY")) {
                    in = in.replace(",IY", "");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = -3;
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = 34;
                    this.setWord(in);
                    return;
                }
                if (in.endsWith(",HL")) {
                    in = in.replace(",HL", "");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = 34;
                    this.setWord(in);
                    return;
                }
                if (in.contains(",A")) {
                    in = in.replace(",A", "");
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = 50;
                    this.setWord(in);
                    return;
                }
                this.err = true;
                return;
            }
        }
        this.err = true;
        if (actualPass != 1) {
            Interface.errorInfo.append("[Error] " + this.checkstring + " in line " + EditorPanel.actualLine + "\n");
            ++EditorPanel.errors;
        }
    }

    protected void LDIX(String in, boolean minu) {
        this.err = false;
        String s = "+";
        if (minu) {
            s = "-";
        }
        in = in.replace("IX" + s, "");
        in = in.replace("(", "");
        if ((in = in.replace(")", "")).contains(",A")) {
            in = in.replace(",A", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -35;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 119;
            this.setByte(in);
        } else if (in.contains(",L")) {
            in = in.replace(",L", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -35;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 117;
            this.setByte(in);
        } else if (in.contains(",H")) {
            in = in.replace(",H", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -35;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 116;
            this.setByte(in);
        } else if (in.contains(",E")) {
            in = in.replace(",E", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -35;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 115;
            this.setByte(in);
        } else if (in.contains(",D")) {
            in = in.replace(",D", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -35;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 114;
            this.setByte(in);
        } else if (in.contains(",C")) {
            in = in.replace(",C", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -35;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 113;
            this.setByte(in);
        } else if (in.contains(",B")) {
            in = in.replace(",B", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -35;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 112;
            this.setByte(in);
        } else {
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -35;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 54;
            in = in.replace(",", "");
            this.setBytes(in);
        }
    }

    protected void LDIY(String in, boolean minu) {
        String s = "+";
        if (minu) {
            s = "-";
        }
        in = in.replace("IY" + s, "");
        in = in.replace("(", "");
        if ((in = in.replace(")", "")).contains(",A")) {
            in = in.replace(",A", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -3;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 119;
            this.setByte(in);
        } else if (in.contains(",L")) {
            in = in.replace(",A", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -3;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 117;
            this.setByte(in);
        } else if (in.contains(",H")) {
            in = in.replace(",H", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -3;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 116;
            this.setByte(in);
        } else if (in.contains(",E")) {
            in = in.replace(",E", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -3;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 115;
            this.setByte(in);
        } else if (in.contains(",D")) {
            in = in.replace(",D", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -3;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 114;
            this.setByte(in);
        } else if (in.contains(",C")) {
            in = in.replace(",C", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -3;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 113;
            this.setByte(in);
        } else if (in.contains(",B")) {
            in = in.replace(",B", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -3;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 112;
            this.setByte(in);
        } else {
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = -3;
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = 54;
            in = in.replace(",", "");
            this.setBytes(in);
        }
    }

    protected void getDJNZ(String in, int p) {
        EditorPanel.hasdata[this.pos] = true;
        this.output[this.pos++] = 16;
        in = in.replace("$", "&" + Util.hex(p));
        in = in.replace("DJNZ", "");
        in = in.replace(" ", "");
        in = this.parseMath(in);
        int to = 0;
        try {
            to = Integer.parseInt(in);
        }
        catch (Exception e) {
            to = 0;
        }
        if (((to -= (p += 2)) < -128 || to > 128) && actualPass != 1) {
            this.err = true;
            ++EditorPanel.errors;
            Interface.errorInfo.append("DJNZ jump " + to + " too far in line" + EditorPanel.actualLine + "\n");
        }
        EditorPanel.hasdata[this.pos] = true;
        this.output[this.pos++] = (byte)to;
    }

    protected void getJR(String in, int p) {
        int to;
        block13: {
            if ((in = in.replace("$", "&" + Util.hex(p))).startsWith("JR NZ,")) {
                in = in.replace("JR NZ,", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 32;
            } else if (in.startsWith("JR Z,")) {
                in = in.replace("JR Z,", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 40;
            } else if (in.startsWith("JR NC,")) {
                in = in.replace("JR NC,", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 48;
            } else if (in.startsWith("JR C,")) {
                in = in.replace("JR C,", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 56;
            } else {
                if (in.contains(",")) {
                    EditorPanel.hasdata[this.pos] = true;
                    this.output[this.pos++] = 24;
                }
                in = in.replace("JR ", "");
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 24;
            }
            in = in.replace(",", "");
            in = in.replace(" ", "");
            boolean hex = false;
            in = this.parseMath(in);
            if (in.startsWith("&") || in.startsWith("#") || in.startsWith("$")) {
                hex = true;
            }
            in = in.replace("&", "");
            in = in.replace("#", "");
            in = in.replace("$", "");
            to = 0;
            try {
                to = hex ? Util.hexValue(in) : Integer.parseInt(in);
            }
            catch (Exception e) {
                if (actualPass == 1) break block13;
                this.err = true;
                ++EditorPanel.errors;
                Interface.errorInfo.append("JR EXCEPTION '" + in + "' in line" + EditorPanel.actualLine + "\n");
            }
        }
        if (((to -= (p += 2)) < -128 || to > 128) && actualPass != 1) {
            this.err = true;
            ++EditorPanel.errors;
            Interface.errorInfo.append("JR jump " + to + " too far in line" + EditorPanel.actualLine + "\n");
        }
        EditorPanel.hasdata[this.pos] = true;
        this.output[this.pos++] = (byte)to;
    }

    protected void getCALL(String in) {
        int prefix = -51;
        if ((in = in.substring(4)).startsWith(" NZ,")) {
            prefix = -60;
            in = in.substring(3);
        } else if (in.startsWith(" Z,")) {
            in = in.replace(",", "");
            prefix = -52;
            in = in.substring(2);
        } else if (in.startsWith(" NC,")) {
            in = in.replace(",", "");
            prefix = -44;
            in = in.substring(3);
        } else if (in.startsWith(" C,")) {
            in = in.replace(",", "");
            prefix = -36;
            in = in.substring(2);
        } else if (in.startsWith(" PO,")) {
            in = in.replace(",", "");
            prefix = -28;
            in = in.substring(3);
        } else if (in.startsWith(" PE,")) {
            in = in.replace(",", "");
            prefix = -20;
            in = in.substring(3);
        } else if (in.startsWith(" P,")) {
            in = in.replace(",", "");
            prefix = -12;
            in = in.substring(2);
        } else if (in.startsWith(" M,")) {
            in = in.replace(",", "");
            prefix = -4;
            in = in.substring(2);
        }
        in = in.replace(",", "");
        in = in.replace(" ", "");
        EditorPanel.hasdata[this.pos] = true;
        this.output[this.pos++] = prefix;
        this.setWord(in);
    }

    protected void getJP(String in) {
        if (in.startsWith("JP ")) {
            this.err = false;
            in = in.replace(" ", "");
            int prefix = -61;
            if ((in = in.substring(2)).startsWith("NZ,")) {
                prefix = -62;
                in = in.substring(3);
            } else if (in.startsWith("Z,")) {
                prefix = -54;
                in = in.substring(2);
            } else if (in.startsWith("NC,")) {
                prefix = -46;
                in = in.substring(3);
            } else if (in.startsWith("C,")) {
                prefix = -38;
                in = in.substring(2);
            } else if (in.startsWith("PO,")) {
                prefix = -30;
                in = in.substring(3);
            } else if (in.startsWith("PE,")) {
                prefix = -22;
                in = in.substring(3);
            } else if (in.startsWith("P,")) {
                prefix = -14;
                in = in.substring(2);
            } else if (in.startsWith("M,")) {
                prefix = -6;
                in = in.substring(2);
            }
            in = in.replace(",", "");
            EditorPanel.hasdata[this.pos] = true;
            this.output[this.pos++] = prefix;
            this.setWord(in);
        }
    }

    protected int getAddress(String p) {
        int ad = 0;
        while (p.startsWith(" ")) {
            p = p.substring(1);
        }
        while (p.endsWith(" ")) {
            p = p.substring(0, p.length() - 1);
        }
        p = this.parseMath(p);
        ad = Integer.parseInt(p);
        return ad;
    }

    public byte getNumericValue(String p) {
        p = p.replace("X", "0");
        try {
            return (byte)Util.hexValue(p);
        }
        catch (Exception e) {
            Interface.errorInfo.append(e.getMessage() + "\n");
            Interface.errorInfo.append(this.checkstring + " in line " + EditorPanel.actualLine + "\n");
            this.err = true;
            ++EditorPanel.errors;
            return 0;
        }
    }

    public String parseMath(String p) {
        char g;
        String h;
        if (p.startsWith("\"") && p.endsWith("\"")) {
            h = p;
            g = (h = h.replace("\"", "")).charAt(0);
            if (g != '\u0000') {
                p = "" + g;
            }
        }
        if (p.startsWith("'") && p.charAt(2) == '\'') {
            h = p;
            h = h.substring(1);
            g = h.charAt(0);
            h = h.substring(2);
            if (g != '\u0000') {
                p = g + h;
            }
        }
        while (p.contains("&0")) {
            p = p.replace("&0", "&");
        }
        while (p.startsWith(" ")) {
            p = p.substring(1);
        }
        while (p.endsWith(" ")) {
            p = p.substring(0, p.length() - 1);
        }
        if (actualPass == 2) {
            p = Z80Assembler.setLabels(p);
            p = Z80Assembler.putEQU(p);
        }
        if ((p = MathParser.parseMath(p)) == null) {
            p = "0";
            if (actualPass != 1 && EditorPanel.actualLine != 0) {
                Interface.errorInfo.append("Null exception in MathParser!\n");
                Interface.errorInfo.append(this.checkstring + " in line " + EditorPanel.actualLine + "\n");
                this.err = true;
                ++EditorPanel.errors;
            }
        }
        return p;
    }

    public void setBytes(String p) {
        if ((p = this.parseMath(p)) == null) {
            p = "00";
        }
        try {
            boolean hex = false;
            if (p.contains("&") || p.contains("#") || p.contains("$")) {
                hex = true;
            }
            int value = 0;
            p = p.replace("&", "");
            p = p.replace("$", "");
            if ((p = p.replace("#", "")).length() > 4 && hex) {
                String cut = "";
                for (int i = 0; i < 4; ++i) {
                    cut = cut + p.charAt(i);
                }
                p = cut;
            }
            byte[] ret = new byte[2];
            if (hex) {
                try {
                    value = Util.hexValue(p);
                }
                catch (Exception er) {
                    value = 0;
                }
            } else {
                try {
                    value = Integer.parseInt(p);
                }
                catch (Exception er) {
                    value = 0;
                }
            }
            Device.putWord(ret, 0, value);
            for (int i = ret.length - 1; i > -1; --i) {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = ret[i];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setWord(String p) {
        boolean show = false;
        if ((p = this.parseMath(p)) == null) {
            p = "0000";
        }
        try {
            boolean hex = false;
            if (p.contains("&") || p.contains("#") || p.contains("$")) {
                hex = true;
            }
            int value = 0;
            p = p.replace("&", "");
            p = p.replace("$", "");
            if ((p = p.replace("#", "")).length() > 4 && hex) {
                String cut = "";
                for (int i = 0; i < 4; ++i) {
                    cut = cut + p.charAt(i);
                }
                p = cut;
            }
            byte[] ret = new byte[2];
            if (hex) {
                try {
                    value = Util.hexValue(p);
                }
                catch (Exception er) {
                    value = 0;
                }
            } else {
                try {
                    value = Integer.parseInt(p);
                }
                catch (Exception er) {
                    value = 0;
                }
            }
            Device.putWord(ret, 0, value);
            for (int i = 0; i < ret.length; ++i) {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = ret[i];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setByte(String p) {
        block7: {
            if (p.startsWith("-")) {
                int i;
                block6: {
                    i = 0;
                    try {
                        i = (Integer.parseInt(MathParser.parseMath(p)) ^ 0xFF) + 1;
                    }
                    catch (Exception e) {
                        if (actualPass == 1) break block6;
                        ++EditorPanel.errors;
                        Interface.errorInfo.append("Bad byte in line " + EditorPanel.actualLine + ":" + p + " CODE:" + this.checkstring + "\n");
                    }
                }
                p = "" + i;
                if (p.startsWith("-")) {
                    p = p.substring(1);
                }
            }
            p = this.parseMath(p);
            try {
                int value = Integer.parseInt(p);
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = (byte)value;
            }
            catch (Exception e) {
                EditorPanel.hasdata[this.pos] = true;
                this.output[this.pos++] = 0;
                if (actualPass == 1) break block7;
                ++EditorPanel.errors;
                Interface.errorInfo.append("|" + p + "| caused Byte Exception in line " + EditorPanel.actualLine + ":" + p + " CODE:" + this.checkstring + "\n");
            }
        }
    }

    public static void main(String[] args) {
        String dist;
        int p;
        Z80Assembler asm = new Z80Assembler();
        System.out.println(";;Checking Arrays...");
        System.out.println(";;Assembler Opcodes: " + asm.Opcodes.length);
        System.out.println(";;Assembler Values: " + asm.Values.length);
        System.out.println(";;---------------------------\n\n");
        System.out.println("NN      EQU     #1234           ; a sixteen bit number");
        System.out.println("N       EQU     #56             ; an eight bit number");
        System.out.println("");
        for (p = 0; p < asm.Opcodes.length; ++p) {
            dist = "                        ; ";
            dist = dist.substring(asm.Opcodes[p].length());
            System.out.println("        " + asm.Opcodes[p] + dist + asm.Values[p]);
        }
        System.out.println(";;Undocumented Opcodes: " + asm.UndocumentedOpcodes.length);
        System.out.println(";;Undocumented Values: " + asm.UndocumentedValues.length);
        System.out.println(";;---------------------------\n\n");
        for (p = 0; p < asm.UndocumentedOpcodes.length; ++p) {
            dist = "                        ; ";
            dist = dist.substring(asm.UndocumentedOpcodes[p].length());
            System.out.println("        " + asm.UndocumentedOpcodes[p] + dist + asm.UndocumentedValues[p]);
        }
    }

    static {
        labelfound = false;
        actualPass = 0;
        labels = new String[65535];
        labeladdresses = new String[65535];
        label = 0;
        maxlabel = 0;
    }
}

