/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.paint;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class importTGA {
    public static final int TGA_RGB = 2;
    public static final int TGA_A = 3;
    public static final int TGA_RLE = 10;
    public static final int TGA_FILE_NOT_FOUND = 13;
    public static final int TGA_BAD_IMAGE_TYPE = 14;
    public static final int TGA_BAD_DIMENSION = 15;
    public static final int TGA_BAD_BITS = 16;
    public static final int TGA_BAD_DATA = 17;
    public static final int BOTTOM_LEFT_ORIGIN = 0;
    public static final int BOTTOM_RIGHT_ORIGIN = 1;
    public static final int TOP_LEFT_ORIGIN = 2;
    public static final int TOP_RIGHT_ORIGIN = 3;
    public byte[] imageData;
    public int iBits;
    public int texFormat;
    public int imageWidth;
    public int imageHeight;

    public importTGA(String file) {
        try {
            this.loadTGA(new File(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public importTGA() {
    }

    public importTGA(File url) {
        this.loadTGA(url);
    }

    int checkSize(int x) {
        if (x == 2 || x == 4 || x == 8 || x == 16 || x == 32 || x == 64 || x == 128 || x == 256 || x == 512) {
            return 1;
        }
        return 0;
    }

    byte[] getRGBA(byte[] data, int size) throws IOException {
        byte[] rgba = data;
        int numOfBytes = size * 4;
        for (int i = 0; i < numOfBytes; i += 4) {
            byte temp = rgba[i];
            rgba[i] = rgba[i + 2];
            rgba[i + 2] = temp;
        }
        return rgba;
    }

    byte[] getRGB(byte[] data, int size) throws IOException {
        byte[] rgb = data;
        for (int i = 0; i < size * 3; i += 3) {
            byte temp = rgb[i];
            rgb[i] = rgb[i + 2];
            rgb[i + 2] = temp;
        }
        return rgb;
    }

    byte[] getGray(byte[] data, int size) throws IOException {
        byte[] grayData = data;
        return grayData;
    }

    byte[] getData(byte[] s, int sz) throws IOException {
        if (this.iBits == 32) {
            return this.getRGBA(s, sz);
        }
        if (this.iBits == 24) {
            return this.getRGB(s, sz);
        }
        if (this.iBits == 8) {
            return this.getGray(s, sz);
        }
        return null;
    }

    int returnError(InputStream s, int error) throws IOException {
        System.out.println("error is: " + error);
        return error;
    }

    int loadTGA(File url) {
        int[] type = new int[4];
        int[] info = new int[6];
        try {
            int skipAmount;
            FileInputStream stream = new FileInputStream(url);
            BufferedInputStream s = new BufferedInputStream(stream);
            type[0] = s.read();
            type[1] = s.read();
            type[2] = s.read();
            s.skip(9L);
            info[0] = s.read();
            info[1] = s.read();
            info[2] = s.read();
            info[3] = s.read();
            info[4] = s.read();
            info[5] = s.read();
            if (type[1] != 0 || type[2] != 2 && type[2] != 3 && type[2] != 10) {
                this.returnError(s, 14);
            }
            this.imageWidth = info[0] + info[1] * 256;
            this.imageHeight = info[2] + info[3] * 256;
            if (this.imageHeight == 0) {
                this.imageWidth = 1280;
                this.imageHeight = 720;
            }
            System.out.println(this.imageWidth + "x" + this.imageHeight);
            this.iBits = info[4];
            this.texFormat = info[5] >>> 4;
            int size = this.imageWidth * this.imageHeight;
            if (this.checkSize(this.imageWidth) == 0 || this.checkSize(this.imageHeight) == 0) {
                System.out.println("Bad dimension!");
            }
            if (this.iBits != 32 && this.iBits != 24 && this.iBits != 8) {
                this.returnError(s, 16);
            }
            if ((skipAmount = type[0]) < 0) {
                skipAmount += 256;
            }
            if (skipAmount != 0) {
                s.skip(skipAmount);
            }
            if (type[2] == 10) {
                this.imageData = this.getRLEData(s);
            } else {
                byte[] buf = new byte[size * (this.iBits / 8)];
                s.read(buf, 0, buf.length);
                this.imageData = this.getData(buf, size);
            }
            stream.close();
            s.close();
            if (this.imageData == null) {
                this.returnError(s, 17);
            }
            return 1;
        }
        catch (IOException e) {
            return 13;
        }
    }

    BufferedImage getImage(String file, boolean quick) {
        int blue;
        int green;
        int red;
        int j;
        int i;
        try {
            this.loadTGA(new File(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int[] pixel = new int[this.imageWidth * this.imageHeight];
        int z = 0;
        int startX = 0;
        int maxX = 0;
        int startY = 0;
        int maxY = 0;
        int xInc = 1;
        int yInc = 1;
        switch (this.texFormat) {
            case 0: {
                startX = 0;
                startY = 0;
                maxX = this.imageWidth - 1;
                maxY = this.imageHeight - 1;
                break;
            }
            case 1: {
                startX = this.imageWidth - 1;
                startY = 0;
                maxX = -1;
                maxY = this.imageHeight - 1;
                xInc = -1;
                break;
            }
            case 2: {
                startX = 0;
                startY = this.imageHeight - 1;
                maxX = this.imageWidth - 1;
                maxY = -1;
                yInc = -1;
                break;
            }
            case 3: {
                startX = this.imageWidth - 1;
                startY = this.imageHeight - 1;
                maxX = -1;
                maxY = -1;
                xInc = -1;
                yInc = -1;
            }
        }
        if (this.iBits == 32) {
            for (i = startX; i != maxX; i += xInc) {
                for (j = startY; j != maxY; j += yInc) {
                    red = this.imageData[j * 4 + i * (maxY * 4)] & 0xFF;
                    green = this.imageData[j * 4 + i * (maxY * 4) + 1] & 0xFF;
                    blue = this.imageData[j * 4 + i * (maxY * 4) + 2] & 0xFF;
                    int alpha = this.imageData[j * 4 + i * (maxY * 4) + 3] & 0xFF;
                    pixel[z++] = alpha << 24 | red << 16 | green << 8 | blue;
                }
            }
        }
        if (this.iBits == 24) {
            for (i = startX; i != maxX; i += xInc) {
                for (j = startY; j != maxY; j += yInc) {
                    red = this.imageData[j * 3 + i * (maxY * 3)] & 0xFF;
                    green = this.imageData[j * 3 + i * (maxY * 3) + 1] & 0xFF;
                    blue = this.imageData[j * 3 + i * (maxY * 3) + 2] & 0xFF;
                    pixel[z++] = 0xFF000000 | red << 16 | green << 8 | blue;
                }
            }
        }
        if (this.iBits == 8) {
            for (i = startX; i != maxX; i += xInc) {
                for (j = startY; j != maxY; j += yInc) {
                    red = this.imageData[j * 3 + i * (maxY * 3)] & 0xFF;
                    green = this.imageData[j * 3 + i * (maxY * 3) + 1] & 0xFF;
                    blue = this.imageData[j * 3 + i * (maxY * 3) + 2] & 0xFF;
                    pixel[z++] = 0xFF000000 | red << 16 | green << 8 | blue;
                }
            }
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image im = tk.createImage(new MemoryImageSource(this.imageWidth, this.imageHeight, pixel, 0, this.imageWidth));
        BufferedImage ima = new BufferedImage(this.imageWidth, this.imageHeight, 1);
        Graphics g = ima.getGraphics();
        g.drawImage(im, 0, 0, null);
        int adder = 1;
        if (quick) {
            adder = 4;
        }
        for (int x = 0; x < this.imageWidth; x += adder) {
            for (int y = 0; y < this.imageHeight / 2; y += adder) {
                Color c = new Color(ima.getRGB(x, y));
                Color d = new Color(ima.getRGB(x, this.imageHeight - 1 - y));
                g.setColor(d);
                g.fillRect(x, y, adder, adder);
                g.setColor(c);
                g.fillRect(x, this.imageHeight - y, adder, adder);
            }
        }
        return ima;
    }

    byte[] getRLEData(InputStream stream) throws IOException {
        int rleID = 0;
        int colorsRead = 0;
        int channels = this.iBits / 8;
        int stride = channels * this.imageWidth;
        int i = 0;
        byte[] data = new byte[stride * this.imageHeight];
        byte[] pColors = new byte[channels];
        int size = this.imageWidth * this.imageHeight;
        while (i < size) {
            rleID = stream.read();
            if (rleID >> 7 == 0) {
                ++rleID;
                while (rleID > 0) {
                    stream.read(pColors, 0, pColors.length);
                    data[colorsRead + 0] = pColors[2];
                    data[colorsRead + 1] = pColors[1];
                    data[colorsRead + 2] = pColors[0];
                    if (this.iBits == 32) {
                        data[colorsRead + 3] = pColors[3];
                    }
                    ++i;
                    --rleID;
                    colorsRead += channels;
                }
                continue;
            }
            rleID -= 127;
            stream.read(pColors, 0, pColors.length);
            while (rleID > 0) {
                data[colorsRead + 0] = pColors[2];
                data[colorsRead + 1] = pColors[1];
                data[colorsRead + 2] = pColors[0];
                if (this.iBits == 32) {
                    data[colorsRead + 3] = pColors[3];
                }
                ++i;
                --rleID;
                colorsRead += channels;
            }
        }
        return data;
    }
}

