/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.cpcgamescd;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jemu.core.Util;

public class CPCFileSystem {
    protected final int DSK_HEADER_LENGTH = 256;
    protected final int TRACK_INFO_LENGTH = 256;
    protected final int[] NUMBER_OF_TRACKS = new int[]{40, 40, 40, 160, 80};
    protected final int[] MULTIPLIER = new int[]{1, 1, 1, 4, 2};
    protected final int[] START_TRACK = new int[]{0, 2, 1, 2, 0};
    protected final int[] SECTORADD = new int[]{192, 64, 0, 0, 16};
    protected final int[] SECTOR_SIZE = new int[]{512, 512, 512, 512, 512};
    protected final int[] TRACK_SIZE = new int[]{4608, 4608, 4096, 4608, 5120};
    protected final int[] MAX_BLOCKS = new int[]{178, 169, 154, 704, 796};
    protected final int[] MAX_ENTRIES = new int[]{64, 64, 64, 128, 128};
    boolean linear = false;
    protected int FORMAT;
    public int[] users;
    public String[] files;
    public byte[] buffer;
    public int[][] blocks;
    public boolean[] readOnly;
    public boolean[] system;
    public int[] ext;
    public int[] rec;
    public int[] fileentries;
    public int[] diroffset;
    public int[] skew;
    protected static int entries;
    byte[] HEADER;
    byte[] RESULT;
    protected String internalname = "           ";
    protected int namepos = 1;
    protected int filetypepos = 18;
    protected int datalengthpos = 19;
    protected int datalocationpos = 21;
    protected int firstblockpos = 23;
    protected int filelengthpos = 24;
    protected int execaddresspos = 26;
    protected int lengthpos = 64;
    protected int checksumpos = 67;
    String content;
    public boolean addrem = false;
    protected int filesize;
    int[][] sectors = new int[8][];
    public int filetype;
    public String mediatype;
    public int filestart;
    public int fileentry;
    protected String[] types = new String[]{"BASIC", "BASIC  [P]", "BINARY", "BINARY [P]", "IMAGE", "IMAGE  [P]", "ASCII", "ASCII  [P]"};
    protected int numberfiles;
    protected int disksides;
    protected int disktracks;
    protected int discsectors;
    public static int DATA_FORMAT;
    public static int SYSTEM_FORMAT;
    public static int IBM_FORMAT;
    public static int VORTEX_FORMAT;
    public static int ROMDOS_FORMAT;

    public void writeFile(String file, String diskname) {
        if (this.buffer == null) {
            return;
        }
        String[] filess = null;
        if (file.contains("*")) {
            file = file.replace("*", "");
            File check = new File(file);
            filess = check.list();
        }
        if (filess != null) {
            for (int i = 0; i < filess.length; ++i) {
                this.copyToDSK(file, filess[i], diskname);
            }
        } else {
            this.copyToDSK("", file, diskname);
        }
    }

    public void cleanUp() {
        int i;
        int p;
        try {
            this.setSkew();
        }
        catch (Exception e) {
            return;
        }
        this.DIR();
        byte[] dir = this.getDIR();
        byte[][] direntry = new byte[500][32];
        for (int g = 0; g < 500; ++g) {
            for (p = 0; p < 32; ++p) {
                direntry[g][p] = -27;
            }
        }
        int pos = 0;
        for (i = 0; i < dir.length - 32; i += 32) {
            if ((dir[i] & 0xFF) == 229) continue;
            System.arraycopy(dir, i, direntry[pos], 0, 32);
            ++pos;
        }
        dir = new byte[dir.length];
        for (p = 0; p < dir.length; ++p) {
            dir[p] = -27;
        }
        pos = 0;
        for (i = 0; i < dir.length - 32; i += 32) {
            if (direntry[pos] == null) continue;
            System.arraycopy(direntry[pos], 0, dir, i, 32);
            ++pos;
        }
        this.setDir(dir);
    }

    public void cleanUp(String name) {
        int i;
        String checkname = name.substring(0, name.length() - 3);
        checkname = checkname + ".";
        checkname = checkname + name.substring(8);
        this.setSkew();
        this.DIR();
        byte[] dir = this.getDIR();
        byte[][] direntry = new byte[500][32];
        for (int g = 0; g < 500; ++g) {
            for (int p = 0; p < 32; ++p) {
                direntry[g][p] = -27;
            }
        }
        int pos = 0;
        for (i = 0; i < dir.length - 32; i += 32) {
            if ((dir[i] & 0xFF) != 229 || !checkname.equals(new String(dir, i + 1, checkname.length()))) continue;
            System.arraycopy(new byte[32], 0, direntry[pos], 0, 32);
            ++pos;
        }
        dir = new byte[dir.length];
        pos = 0;
        for (i = 0; i < dir.length - 32; i += 32) {
            if (direntry[pos] == null) continue;
            System.arraycopy(direntry[pos], 0, dir, i, 32);
            ++pos;
        }
        this.setDir(dir);
    }

    protected void delete(int pos) {
        if (pos < 0) {
            return;
        }
        int deluser = this.users[this.fileentries[pos]];
        this.setSkew();
        this.DIR();
        try {
            if (this.files[this.fileentries[pos]] != null) {
                String checkname = this.files[this.fileentries[pos]];
                for (int it = 0; it < this.files.length; ++it) {
                    if (this.files[it] == null || !this.files[it].equals(checkname) || this.users[it] != deluser) continue;
                    this.users[it] = 229;
                    this.buffer[this.diroffset[it]] = (byte)this.users[it];
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void rename(int pos, String newname) {
        while (newname.length() < 11) {
            newname = newname + " ";
        }
        if (pos < 0) {
            return;
        }
        this.setSkew();
        this.DIR();
        if (this.files[this.fileentries[pos]] != null) {
            String checkname = this.files[this.fileentries[pos]];
            for (int it = 0; it < this.files.length; ++it) {
                if (this.files[it] == null || !this.files[it].equals(checkname) || this.users[it] != this.users[this.fileentries[pos]]) continue;
                for (int i = 0; i < this.files.length; ++i) {
                    if (this.files[i] == null || !this.files[i].equals(checkname)) continue;
                    try {
                        byte[] name = newname.getBytes("UTF-8");
                        for (int ir = 0; ir < name.length; ++ir) {
                            this.buffer[this.diroffset[it] + ir + 1] = name[ir];
                        }
                        byte[] head = new byte[32];
                        System.arraycopy(this.buffer, this.diroffset[it], head, 0, 32);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected void readOnly(int pos) {
        if (pos < 0) {
            return;
        }
        this.setSkew();
        this.DIR();
        if (this.files[this.fileentries[pos]] != null) {
            String checkname = this.files[this.fileentries[pos]];
            for (int it = 0; it < this.files.length; ++it) {
                if (this.files[it] == null || !this.files[it].equals(checkname) || this.users[it] != this.users[this.fileentries[pos]]) continue;
                for (int i = 0; i < this.files.length; ++i) {
                    if (this.files[i] == null || !this.files[i].equals(checkname)) continue;
                    int cha = this.buffer[this.diroffset[it] + 9] & 0xFF;
                    cha = cha < 128 ? (cha |= 0x80) : (cha &= 0x7F);
                    this.buffer[this.diroffset[it] + 9] = (byte)cha;
                    ++it;
                }
            }
        }
    }

    protected void system(int pos) {
        if (pos < 0) {
            return;
        }
        this.setSkew();
        this.DIR();
        if (this.files[this.fileentries[pos]] != null) {
            String checkname = this.files[this.fileentries[pos]];
            for (int it = 0; it < this.files.length; ++it) {
                if (this.files[it] == null || !this.files[it].equals(checkname) || this.users[it] != this.users[this.fileentries[pos]]) continue;
                for (int i = 0; i < this.files.length; ++i) {
                    if (this.files[i] == null || !this.files[i].equals(checkname)) continue;
                    int cha = this.buffer[this.diroffset[it] + 10] & 0xFF;
                    System.err.println(cha);
                    cha = cha < 128 ? (cha |= 0x80) : (cha &= 0x7F);
                    this.buffer[this.diroffset[it] + 10] = (byte)cha;
                    ++it;
                }
            }
        }
    }

    protected void saveDisk(String diskname) {
        try {
            BufferedOutputStream bis = new BufferedOutputStream(new FileOutputStream(new File(diskname)));
            bis.write(this.buffer);
            bis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected byte[] getDIR() {
        byte[] dir = new byte[this.SECTOR_SIZE[this.FORMAT] * 4 * this.disksides];
        if (!this.linear) {
            System.arraycopy(this.buffer, 512 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]), dir, 0, this.SECTOR_SIZE[this.FORMAT]);
            System.arraycopy(this.buffer, 512 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]) + this.SECTOR_SIZE[this.FORMAT] * 2, dir, this.SECTOR_SIZE[this.FORMAT], this.SECTOR_SIZE[this.FORMAT]);
            System.arraycopy(this.buffer, 512 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]) + this.SECTOR_SIZE[this.FORMAT] * 4, dir, this.SECTOR_SIZE[this.FORMAT] * 2, this.SECTOR_SIZE[this.FORMAT]);
            System.arraycopy(this.buffer, 512 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]) + this.SECTOR_SIZE[this.FORMAT] * 6, dir, this.SECTOR_SIZE[this.FORMAT] * 3, this.SECTOR_SIZE[this.FORMAT]);
            if (this.disksides == 2) {
                System.arraycopy(this.buffer, 512 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]) + this.SECTOR_SIZE[this.FORMAT] * 8, dir, this.SECTOR_SIZE[this.FORMAT] * 4, this.SECTOR_SIZE[this.FORMAT]);
                System.arraycopy(this.buffer, 512 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]) + this.SECTOR_SIZE[this.FORMAT] * 1, dir, this.SECTOR_SIZE[this.FORMAT] * 5, this.SECTOR_SIZE[this.FORMAT]);
                System.arraycopy(this.buffer, 512 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]) + this.SECTOR_SIZE[this.FORMAT] * 3, dir, this.SECTOR_SIZE[this.FORMAT] * 6, this.SECTOR_SIZE[this.FORMAT]);
                System.arraycopy(this.buffer, 512 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]) + this.SECTOR_SIZE[this.FORMAT] * 5, dir, this.SECTOR_SIZE[this.FORMAT] * 7, this.SECTOR_SIZE[this.FORMAT]);
            }
        } else {
            System.arraycopy(this.buffer, 512 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]), dir, 0, this.SECTOR_SIZE[this.FORMAT] * 4 * this.disksides);
        }
        return dir;
    }

    protected void setDir(byte[] dir) {
        if (!this.linear) {
            System.arraycopy(dir, 0, this.buffer, 256 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]) + 256, this.SECTOR_SIZE[this.FORMAT]);
            System.arraycopy(dir, this.SECTOR_SIZE[this.FORMAT], this.buffer, 256 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]) + 256 + this.SECTOR_SIZE[this.FORMAT] * 2, this.SECTOR_SIZE[this.FORMAT]);
            System.arraycopy(dir, this.SECTOR_SIZE[this.FORMAT] * 2, this.buffer, 256 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]) + 256 + this.SECTOR_SIZE[this.FORMAT] * 4, this.SECTOR_SIZE[this.FORMAT]);
            System.arraycopy(dir, this.SECTOR_SIZE[this.FORMAT] * 3, this.buffer, 256 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]) + 256 + this.SECTOR_SIZE[this.FORMAT] * 6, this.SECTOR_SIZE[this.FORMAT]);
            if (this.disksides == 2) {
                System.arraycopy(dir, this.SECTOR_SIZE[this.FORMAT] * 4, this.buffer, 256 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]) + 256 + this.SECTOR_SIZE[this.FORMAT] * 8, this.SECTOR_SIZE[this.FORMAT]);
                System.arraycopy(dir, this.SECTOR_SIZE[this.FORMAT] * 5, this.buffer, 256 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]) + 256 + this.SECTOR_SIZE[this.FORMAT] * 1, this.SECTOR_SIZE[this.FORMAT]);
                System.arraycopy(dir, this.SECTOR_SIZE[this.FORMAT] * 6, this.buffer, 256 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]) + 256 + this.SECTOR_SIZE[this.FORMAT] * 3, this.SECTOR_SIZE[this.FORMAT]);
                System.arraycopy(dir, this.SECTOR_SIZE[this.FORMAT] * 7, this.buffer, 256 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]) + 256 + this.SECTOR_SIZE[this.FORMAT] * 5, this.SECTOR_SIZE[this.FORMAT]);
            }
        } else {
            System.arraycopy(dir, 0, this.buffer, 256 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]) + 256, this.SECTOR_SIZE[this.FORMAT] * 4 * this.disksides);
        }
    }

    public int getSpace() {
        int i;
        int space = this.MAX_BLOCKS[this.FORMAT];
        int[] reserved = new int[this.TRACK_SIZE[this.FORMAT]];
        int pos = 0;
        for (i = 0; i < this.files.length; ++i) {
            try {
                for (int g = 0; g < this.blocks[i].length; ++g) {
                    if (this.users[i] == 229) continue;
                    reserved[pos] = this.blocks[i][g];
                    ++pos;
                }
                continue;
            }
            catch (Exception ex) {
                return 0;
            }
        }
        for (i = 0; i < pos; ++i) {
            if (reserved[i] == 0) continue;
            --space;
        }
        return space;
    }

    public void copyToDSK(String path, String file, String diskname) {
        this.setSkew();
        this.DIR();
        if (this.numberfiles >= this.MAX_ENTRIES[this.FORMAT]) {
            JOptionPane.showMessageDialog(new JFrame(), "Error! Directory is full!\r\nPlease clean it up first!", "Error!", 2);
            return;
        }
        String dskname = file.toUpperCase().replace(".", "\"");
        while (dskname.contains("\\")) {
            dskname = dskname.substring(1);
        }
        while (dskname.contains("/")) {
            dskname = dskname.substring(1);
        }
        String[] n = dskname.split("\"");
        while (n[0].length() > 8) {
            n[0] = n[0].substring(0, n[0].length() - 1);
        }
        while (n[0].length() < 8) {
            n[0] = n[0] + " ";
        }
        try {
            while (n[1].length() > 3) {
                n[1] = n[1].substring(0, n[1].length() - 1);
            }
            while (n[1].length() < 3) {
                n[1] = n[1] + " ";
            }
            dskname = n[0] + n[1];
        }
        catch (Exception r) {
            dskname = n[0] + "   ";
        }
        String checkname = dskname.substring(0, dskname.length() - 3);
        checkname = checkname + ".";
        checkname = checkname + dskname.substring(8);
        for (int i = 0; i < this.files.length; ++i) {
            if (this.files[i] == null || !this.files[i].equals(checkname)) continue;
            Object[] options = new Object[]{"Yes, please", "No way!"};
            int nd = JOptionPane.showOptionDialog(new JFrame(), checkname + " already exists.\r\n" + "Are you sure you want to overwrite it?", "Please confirm", 0, 3, null, options, options[0]);
            if (nd == 0) {
                for (int it = 0; it < this.files.length; ++it) {
                    if (this.files[it] == null || !this.files[it].equals(checkname)) continue;
                    this.users[it] = 229;
                    this.buffer[this.diroffset[it]] = (byte)this.users[it];
                }
                this.cleanUp();
                break;
            }
            return;
        }
        byte[] dir = this.getDIR();
        try {
            int[] reserved = new int[this.TRACK_SIZE[this.FORMAT]];
            int pos = 0;
            for (int i = 0; i < this.files.length; ++i) {
                try {
                    boolean pp = false;
                    for (int g = 0; g < this.blocks[i].length; ++g) {
                        reserved[pos] = this.blocks[i][g];
                        ++pos;
                    }
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    reserved = new int[this.TRACK_SIZE[this.FORMAT]];
                    reserved[0] = 1;
                    System.exit(0);
                    break;
                }
            }
            int pp = 0;
            Arrays.sort(reserved);
            for (int t = 0; t < reserved.length; ++t) {
                if (reserved[t] == 0 || reserved[t] > this.MAX_BLOCKS[this.FORMAT]) continue;
                if (pp == 0) {
                    // empty if block
                }
                if (++pp <= 15) continue;
                pp = 0;
            }
            int[] unreserved = new int[reserved.length];
            for (int i = 0; i < reserved.length; ++i) {
                unreserved[i] = reserved[reserved.length - 1 - i];
            }
            System.arraycopy(unreserved, 0, reserved, 0, reserved.length);
            File fil = new File(path + file);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(fil));
            byte[] data = new byte[in.available()];
            in.read(data);
            in.close();
            if (CPCFileSystem.CheckAMSDOS(data)) {
                this.filesize = CPCFileSystem.getWord(data, 24) + 128;
                if (this.addrem) {
                    data = this.removeHeader(data);
                    this.filesize = data.length;
                }
            } else if (this.addrem) {
                data = this.makeHeader(2, 0, data.length, 0, "", data);
                this.filesize = CPCFileSystem.getWord(data, 24) + 128;
            } else {
                if ((data[data.length - 1] & 0xFF) != 26) {
                    byte[] ddata = new byte[data.length + 1];
                    System.arraycopy(data, 0, ddata, 0, data.length);
                    ddata[ddata.length - 1] = 26;
                    data = new byte[ddata.length];
                    System.arraycopy(ddata, 0, data, 0, ddata.length);
                }
                this.filesize = data.length;
            }
            int exts = (int)Math.ceil((double)this.filesize / 16384.0);
            int pieces = exts * 32 - 1;
            byte[][] sectordata = new byte[pieces][];
            int size = this.filesize;
            int off = 0;
            for (int i = 0; i < pieces; ++i) {
                int rsize = 512;
                if (size < 512) {
                    rsize = size;
                }
                sectordata[i] = new byte[rsize];
                System.arraycopy(data, off, sectordata[i], 0, rsize);
                off += rsize;
                size -= rsize;
            }
            int fsize = this.filesize;
            int pr = 0;
            for (int p = 0; p < exts; ++p) {
                int i;
                byte[] direntry = new byte[32];
                direntry[0] = 0;
                System.arraycopy(dskname.getBytes("UTF-8"), 0, direntry, 1, dskname.getBytes("UTF-8").length);
                direntry[12] = (byte)p;
                int recsize = 128;
                if (fsize < 16384) {
                    recsize = (int)Math.ceil((double)fsize / 128.0);
                }
                direntry[15] = (byte)recsize;
                for (i = 0; i < 16; ++i) {
                    int g;
                    int ppos = 2;
                    for (g = 0; g < reserved.length; ++g) {
                        if (ppos != reserved[g]) continue;
                        ppos = reserved[g] + 1;
                        g = -1;
                    }
                    for (g = reserved.length - 1; g > -1; --g) {
                        if (reserved[g] == 0) continue;
                        reserved[g + 1] = ppos;
                        break;
                    }
                    if (fsize < 0) {
                        ppos = 0;
                    }
                    fsize -= 1024;
                    if (ppos >= this.MAX_BLOCKS[this.FORMAT] + 2) {
                        JOptionPane.showMessageDialog(new JFrame(), "Error! Disk " + diskname + " is full!\r\n" + "Please clean it up first!", "Error!", 2);
                        return;
                    }
                    direntry[16 + i] = (byte)ppos;
                }
                for (i = 0; i < dir.length; i += 32) {
                    if (dir[i + 1] != 0 && dir[i] != -27) continue;
                    System.arraycopy(direntry, 0, dir, i, direntry.length);
                    break;
                }
                for (i = 16; i < direntry.length; ++i) {
                    for (int interleaved = 0; interleaved < 2; ++interleaved) {
                        int block = direntry[i] & 0xFF;
                        int track = (block * 2 * this.MULTIPLIER[this.FORMAT] + interleaved) / this.discsectors;
                        int sector = (block * 2 * this.MULTIPLIER[this.FORMAT] + interleaved) % this.discsectors;
                        off = 256;
                        off += this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]);
                        off += 256 * (track + 1);
                        off += this.TRACK_SIZE[this.FORMAT] * track;
                        off += this.SECTOR_SIZE[this.FORMAT] * (this.skew[sector] - 1);
                        if (block == 0) continue;
                        try {
                            System.arraycopy(sectordata[pr], 0, this.buffer, off, sectordata[pr++].length);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            this.setDir(dir);
            this.saveDisk(diskname);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] get(String file) {
        File f = new File(file);
        if (f.exists()) {
            f.delete();
        }
        this.buffer = this.getRom("empty.dsk", 204544);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
            bos.write(this.buffer);
            bos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRom(String name, int size) {
        byte[] buffer = new byte[size];
        int offs = 0;
        try {
            InputStream stream = null;
            try {
                InputStream is;
                stream = is = this.getClass().getResourceAsStream(name);
                while (size > 0) {
                    int read = stream.read(buffer, offs, size);
                    if (read == -1) {
                        break;
                    }
                    offs += read;
                    size -= read;
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buffer;
    }

    public void setFormat(int format) {
        this.FORMAT = format;
    }

    public static void main(String[] args) {
        CPCFileSystem sys = new CPCFileSystem();
        sys.get("testblank.dsk");
        sys.DIR();
        sys.writeFile("extracted/*", "TEST.DSK");
        System.exit(0);
        for (int i = 0; i < sys.fileentries.length; ++i) {
            sys.getFile(sys.fileentries[i]);
        }
    }

    public void getFile(int pos) {
        if (this.users[pos] == 229) {
            return;
        }
        if (this.ext[pos] != 0) {
            return;
        }
        try {
            int foff = 0;
            this.checkFile(pos, false);
            int[] realpos = new int[100];
            realpos[0] = pos;
            int rpos = 1;
            String name = this.files[pos].replace(" ", "");
            int fsize = this.rec[pos] * 128;
            for (int i = 0; i < this.files.length; ++i) {
                if (!this.files[pos].equals(this.files[i]) || this.ext[i] == 0 || this.users[i] == 229) continue;
                fsize += this.rec[i] * 128;
                realpos[rpos] = i;
            }
            this.filesize = fsize;
            int exts = (int)Math.ceil((double)this.filesize / 16384.0);
            byte[] Final = new byte[this.filesize];
            String folder = "extracted/";
            File f = new File(folder);
            if (!f.exists()) {
                f.mkdir();
            }
            for (int pr = 0; pr <= exts; ++pr) {
                for (int b = 0; b < 16; ++b) {
                    block7: for (int interleaved = 0; interleaved < 2; ++interleaved) {
                        int block = this.blocks[realpos[pr]][b];
                        int track = (block * 2 * this.MULTIPLIER[this.FORMAT] + interleaved) / this.discsectors;
                        int sector = (block * 2 * this.MULTIPLIER[this.FORMAT] + interleaved) % this.discsectors;
                        int off = 256 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]);
                        off += 256 * (track + 1);
                        off += this.TRACK_SIZE[this.FORMAT] * track;
                        for (int i = off += this.SECTOR_SIZE[this.FORMAT] * (this.skew[sector] - 1); i < off + 512; ++i) {
                            try {
                                Final[foff++] = this.buffer[i];
                                continue;
                            }
                            catch (Exception r) {
                                continue block7;
                            }
                        }
                    }
                }
            }
            if (!CPCFileSystem.CheckAMSDOS(Final)) {
                int cut = 0;
                for (int i = Final.length - 2; i > Final.length - 20; --i) {
                    if (Final[i] == 26 && Final[i] + 1 == 0) {
                        ++cut;
                        break;
                    }
                    ++cut;
                }
                if (cut < Final.length - 1) {
                    byte[] buff = new byte[Final.length - cut];
                    System.arraycopy(Final, 0, buff, 0, buff.length);
                    Final = new byte[buff.length];
                    System.arraycopy(buff, 0, Final, 0, buff.length);
                }
                if (this.addrem) {
                    Final = this.makeHeader(2, 0, Final.length, 0, "", Final);
                }
            } else if (CPCFileSystem.CheckAMSDOS(Final) && this.addrem) {
                Final = this.removeHeader(Final);
            }
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(folder + name)));
            bos.write(Final);
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int deepCheck(int pos) {
        if (this.ext[pos] != 0) {
            return 0;
        }
        try {
            int foff = 0;
            this.checkFile(pos, false);
            int[] realpos = new int[100];
            realpos[0] = pos;
            int rpos = 1;
            boolean hasheader = this.filesize != 0;
            String name = this.files[pos].replace(" ", "");
            int fsize = this.rec[pos] * 128;
            for (int i = 0; i < this.files.length; ++i) {
                if (!this.files[pos].equals(this.files[i]) || this.ext[i] == 0 || this.users[i] == 229) continue;
                fsize += this.rec[i] * 128;
                realpos[rpos++] = i;
            }
            this.filesize = fsize;
            int exts = (int)Math.ceil((double)this.filesize / 16384.0);
            byte[] Final = new byte[this.filesize];
            String folder = "extracted/";
            File f = new File(folder);
            if (!f.exists()) {
                f.mkdir();
            }
            for (int pr = 0; pr <= exts; ++pr) {
                for (int b = 0; b < 16; ++b) {
                    block7: for (int interleaved = 0; interleaved < 2; ++interleaved) {
                        int block = this.blocks[realpos[pr]][b];
                        int track = (block * 2 * this.MULTIPLIER[this.FORMAT] + interleaved) / this.discsectors;
                        int sector = (block * 2 * this.MULTIPLIER[this.FORMAT] + interleaved) % this.discsectors;
                        int off = 256 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]);
                        off += 256 * (track + 1);
                        off += this.TRACK_SIZE[this.FORMAT] * track;
                        for (int i = off += this.SECTOR_SIZE[this.FORMAT] * (this.skew[sector] - 1); i < off + 512; ++i) {
                            try {
                                Final[foff++] = this.buffer[i];
                                continue;
                            }
                            catch (Exception r) {
                                continue block7;
                            }
                        }
                    }
                }
            }
            if (!CPCFileSystem.CheckAMSDOS(Final)) {
                boolean cut = false;
                if (this.addrem) {
                    Final = this.makeHeader(2, 0, Final.length, 0, "", Final);
                }
            } else if (CPCFileSystem.CheckAMSDOS(Final) && this.addrem) {
                Final = this.removeHeader(Final);
            }
            return Final.length;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public byte[] makeHeader(int type, int start, int length, int exec, String intname, byte[] SOURCEFILE) {
        if (SOURCEFILE == null) {
            return SOURCEFILE;
        }
        this.HEADER = new byte[128];
        intname = intname.replace(".", "");
        while (intname.length() > 11) {
            intname = intname.substring(0, intname.length() - 1);
        }
        intname = intname.toUpperCase();
        try {
            System.arraycopy("           ".getBytes("UTF-8"), 0, this.HEADER, this.namepos, 11);
            System.arraycopy(intname.getBytes("UTF-8"), 0, this.HEADER, this.namepos, intname.length());
        }
        catch (Exception e) {
            System.err.println("Something went wrong with " + intname);
        }
        this.HEADER[this.filetypepos] = (byte)type;
        CPCFileSystem.putWord(this.HEADER, this.datalengthpos, length);
        CPCFileSystem.putWord(this.HEADER, this.datalocationpos, start);
        this.HEADER[this.firstblockpos] = -1;
        CPCFileSystem.putWord(this.HEADER, this.filelengthpos, length);
        CPCFileSystem.putWord(this.HEADER, this.execaddresspos, exec);
        CPCFileSystem.put24Bit(this.HEADER, this.lengthpos, length);
        CPCFileSystem.put24Bit(this.HEADER, this.checksumpos, CPCFileSystem.ChecksumAMSDOS(this.HEADER));
        SOURCEFILE = this.addHeader(SOURCEFILE);
        return SOURCEFILE;
    }

    public byte[] addHeader(byte[] SOURCEFILE) {
        if (SOURCEFILE == null) {
            return SOURCEFILE;
        }
        if (CPCFileSystem.CheckAMSDOS(SOURCEFILE)) {
            this.removeHeader(SOURCEFILE);
        }
        this.RESULT = new byte[SOURCEFILE.length + 128];
        System.arraycopy(this.HEADER, 0, this.RESULT, 0, 128);
        System.arraycopy(SOURCEFILE, 0, this.RESULT, 128, SOURCEFILE.length);
        SOURCEFILE = new byte[this.RESULT.length];
        System.arraycopy(this.RESULT, 0, SOURCEFILE, 0, SOURCEFILE.length);
        this.content = Util.dumpBytes(SOURCEFILE);
        return SOURCEFILE;
    }

    public byte[] removeHeader(byte[] SOURCEFILE) {
        if (SOURCEFILE == null) {
            return SOURCEFILE;
        }
        if (!CPCFileSystem.CheckAMSDOS(SOURCEFILE)) {
            return SOURCEFILE;
        }
        this.RESULT = new byte[SOURCEFILE.length - 128];
        System.arraycopy(SOURCEFILE, 128, this.RESULT, 0, this.RESULT.length);
        SOURCEFILE = new byte[this.RESULT.length];
        System.arraycopy(this.RESULT, 0, SOURCEFILE, 0, SOURCEFILE.length);
        this.content = Util.dumpBytes(SOURCEFILE);
        return SOURCEFILE;
    }

    public static int ChecksumAMSDOS(byte[] pHeader) {
        int Checksum2 = 0;
        for (int i = 0; i < 67; ++i) {
            int CheckSumByte = pHeader[i] & 0xFF;
            Checksum2 += CheckSumByte;
        }
        return Checksum2;
    }

    public static boolean CheckAMSDOS(byte[] pHeader) {
        int CalculatedChecksum;
        try {
            CalculatedChecksum = CPCFileSystem.ChecksumAMSDOS(pHeader);
        }
        catch (Exception e) {
            return false;
        }
        int ChecksumFromHeader = pHeader[67] & 0xFF | (pHeader[68] & 0xFF) << 8;
        return ChecksumFromHeader == CalculatedChecksum && ChecksumFromHeader != 0;
    }

    public void setSkew() {
        int i;
        this.skew = new int[this.discsectors];
        this.sectors[0] = new int[]{26, 58, 90, 50, 82, 42, 74, 34, 66};
        this.sectors[1] = new int[]{26, 58, 90, 50, 82, 42, 74, 34, 66};
        this.sectors[2] = new int[]{26, 34, 42, 50, 58, 66, 74, 82};
        this.sectors[3] = new int[]{26, 58, 90, 50, 82, 42, 74, 34, 66};
        this.sectors[4] = new int[]{26, 58, 90, 50, 82, 42, 74, 34, 66, 98};
        byte[] trackinfo = new byte[256];
        System.arraycopy(this.buffer, 256 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]), trackinfo, 0, 256);
        for (i = 0; i < this.discsectors; ++i) {
            this.skew[i] = (trackinfo[this.sectors[this.FORMAT][i]] & 0xFF) - this.SECTORADD[this.FORMAT];
        }
        for (i = 0; i < this.skew.length; ++i) {
        }
    }

    public int checkFile(int pos, boolean deep) {
        if (this.FORMAT == -1) {
            this.getFormat();
        }
        int size = 0;
        this.fileentry = 0;
        this.filesize = 0;
        this.mediatype = "ASCII";
        this.filestart = 0;
        try {
            byte[] data = new byte[this.SECTOR_SIZE[this.FORMAT]];
            int block = this.blocks[pos][0];
            int track = block * 2 * this.MULTIPLIER[this.FORMAT] / this.discsectors;
            int sector = block * 2 * this.MULTIPLIER[this.FORMAT] % this.discsectors;
            int off = 256 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]);
            off += 256 * (track + 1);
            off += this.TRACK_SIZE[this.FORMAT] * track;
            off += this.SECTOR_SIZE[this.FORMAT] * (this.skew[sector] - 1);
            try {
                System.arraycopy(this.buffer, off, data, 0, data.length);
            }
            catch (Exception e) {
                this.FORMAT = 0;
                return 0;
            }
            if (CPCFileSystem.CheckAMSDOS(data)) {
                this.filesize = size = CPCFileSystem.getWord(data, 24) + 128;
                this.filestart = CPCFileSystem.getWord(data, 21);
                this.fileentry = CPCFileSystem.getWord(data, 26);
                this.filetype = data[18] & 0xFF;
                try {
                    this.mediatype = this.types[this.filetype];
                }
                catch (Exception e) {
                    this.mediatype = "UNKNOWN!";
                }
            } else {
                size = deep ? this.deepCheck(pos) : 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    public void getFormat() {
        int bufformat = this.FORMAT;
        this.FORMAT = 0;
        int format = -1;
        byte[] trackinfo = new byte[256];
        System.arraycopy(this.buffer, 256 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]), trackinfo, 0, 256);
        this.FORMAT = bufformat;
        int result = trackinfo[26] & 0xFF;
        this.disktracks = this.buffer[48] & 0xFF;
        this.disksides = this.buffer[49] & 0xFF;
        this.discsectors = trackinfo[21] & 0xFF;
        if (this.disktracks < 43) {
            if (this.disksides <= 1) {
                switch (result) {
                    case 1: {
                        format = IBM_FORMAT;
                        break;
                    }
                    case 65: {
                        format = SYSTEM_FORMAT;
                        break;
                    }
                    case 193: {
                        format = DATA_FORMAT;
                    }
                }
            }
        } else if (this.disksides > 1) {
            switch (result) {
                case 1: {
                    format = VORTEX_FORMAT;
                    format = -1;
                    break;
                }
                case 17: {
                    format = ROMDOS_FORMAT;
                    format = -1;
                }
            }
        }
        if (this.FORMAT != format) {
            this.FORMAT = format;
            if (this.FORMAT != -1) {
                this.getFormat();
            }
        }
        if (this.FORMAT != -1) {
            this.MAX_BLOCKS[this.FORMAT] = this.disktracks * this.discsectors / 2 - 2 - this.START_TRACK[this.FORMAT] * this.disksides;
            int n = this.FORMAT;
            this.MAX_BLOCKS[n] = this.MAX_BLOCKS[n] * this.disksides;
        }
    }

    public void DIR() {
        if (this.buffer == null || this.buffer.length < 8192) {
            return;
        }
        this.numberfiles = 0;
        this.getFormat();
        if (this.FORMAT == -1) {
            this.buffer = null;
            this.FORMAT = 0;
            JOptionPane.showMessageDialog(new JFrame(), "Error! Unknown DSK format!", "Error!", 2);
            return;
        }
        this.linear = false;
        switch (this.FORMAT) {
            default: 
        }
        this.setSkew();
        byte[] dir = this.getDIR();
        this.files = new String[this.MAX_ENTRIES[this.FORMAT]];
        this.users = new int[this.MAX_ENTRIES[this.FORMAT]];
        this.blocks = new int[this.MAX_ENTRIES[this.FORMAT]][];
        this.ext = new int[this.MAX_ENTRIES[this.FORMAT]];
        this.readOnly = new boolean[this.MAX_ENTRIES[this.FORMAT]];
        this.system = new boolean[this.MAX_ENTRIES[this.FORMAT]];
        this.rec = new int[this.MAX_ENTRIES[this.FORMAT]];
        this.fileentries = new int[this.MAX_ENTRIES[this.FORMAT]];
        this.diroffset = new int[this.MAX_ENTRIES[this.FORMAT]];
        int fpos = 0;
        int pos = 0;
        boolean err = false;
        entries = 0;
        for (int i = 0; i < this.MAX_ENTRIES[this.FORMAT]; ++i) {
            int f;
            if (!this.linear) {
                if (pos < this.SECTOR_SIZE[this.FORMAT]) {
                    this.diroffset[i] = pos + 256 + 256 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]);
                } else if (pos < this.SECTOR_SIZE[this.FORMAT] * 2) {
                    this.diroffset[i] = pos + 256 + 256 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]) + this.SECTOR_SIZE[this.FORMAT];
                } else if (pos < this.SECTOR_SIZE[this.FORMAT] * 3) {
                    this.diroffset[i] = pos + 256 + 256 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]) + this.SECTOR_SIZE[this.FORMAT] * 2;
                } else if (pos < this.SECTOR_SIZE[this.FORMAT] * 4) {
                    this.diroffset[i] = pos + 256 + 256 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]) + this.SECTOR_SIZE[this.FORMAT] * 3;
                }
            } else {
                this.diroffset[i] = pos + 256 + 256 + this.START_TRACK[this.FORMAT] * (256 + this.TRACK_SIZE[this.FORMAT]);
            }
            this.users[i] = dir[pos++] & 0xFF;
            this.files[i] = null;
            this.blocks[i] = new int[16];
            this.readOnly[i] = false;
            this.system[i] = false;
            if (!err) {
                for (f = 0; f < 11; ++f) {
                    int bt;
                    int gg;
                    if (f == 8 && (gg = dir[pos] & 0xFF) > 127) {
                        this.readOnly[i] = true;
                    }
                    if (f == 9 && (gg = dir[pos] & 0xFF) > 127) {
                        this.system[i] = true;
                    }
                    if (((bt = dir[pos] & 0x7F) < 32 || bt > 95) && bt != 0) {
                        err = true;
                    }
                    if (this.files[i] == null) {
                        this.files[i] = "";
                    }
                    int n = i;
                    this.files[n] = this.files[n] + (char)bt;
                    if (f == 7) {
                        int n2 = i;
                        this.files[n2] = this.files[n2] + ".";
                    }
                    ++pos;
                }
            }
            this.ext[i] = dir[pos++] & 0xFF;
            pos += 2;
            this.rec[i] = dir[pos++] & 0xFF;
            if (err) {
                this.files[i] = null;
            } else {
                this.blocks[i] = new int[16];
            }
            if (this.blocks[i] != null) {
                for (f = 0; f < 16; ++f) {
                    this.blocks[i][f] = dir[pos++] & 0xFF;
                }
            } else {
                pos += 16;
            }
            if (this.files[i] == null) continue;
            if (this.readOnly[i]) {
                // empty if block
            }
            if (this.system[i]) {
                // empty if block
            }
            if (this.ext[i] == 0) {
                this.fileentries[fpos++] = i;
                if (this.users[i] != 229) {
                    ++this.numberfiles;
                }
            } else if (this.users[i] != 229) {
                ++this.numberfiles;
            }
            ++entries;
        }
        int[] g = new int[fpos];
        System.arraycopy(this.fileentries, 0, g, 0, fpos);
        this.fileentries = new int[fpos];
        System.arraycopy(g, 0, this.fileentries, 0, fpos);
    }

    public static int getWord(byte[] buffer, int offs) {
        return buffer[offs] & 0xFF | buffer[offs + 1] << 8 & 0xFF00;
    }

    public static void putWord(byte[] buffer, int offs, int data) {
        buffer[offs] = (byte)(data & 0xFF);
        buffer[offs + 1] = (byte)(data >> 8 & 0xFF);
    }

    public static void put24Bit(byte[] buffer, int offs, int data) {
        buffer[offs] = (byte)(data & 0xFF);
        buffer[offs + 1] = (byte)(data >> 8 & 0xFF);
        buffer[offs + 2] = (byte)(data >> 16 & 0xFF);
    }

    static {
        DATA_FORMAT = 0;
        SYSTEM_FORMAT = 1;
        IBM_FORMAT = 2;
        VORTEX_FORMAT = 3;
        ROMDOS_FORMAT = 4;
    }
}

