/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;

public class SamDisk
extends JFrame {
    protected String[] drive = new String[]{"a:", "b:", "c:", "d:", "e:", "f:", "g:", "h:", "i:", "j:", "k:", "l:", "m:", "n:", "o:", "p:", "q:", "r:", "s:", "t:", "u:", "v:", "w:", "x:", "y:", "z:"};
    protected String[] track = new String[]{"", " -c39", " -c42", " -c79"};
    protected String[] heads = new String[]{"", "-h0", "-h1"};
    int prog = 0;
    protected Process process;
    private ButtonGroup buttonGroup1;
    private JComboBox dselect;
    private JCheckBox dstep;
    private JCheckBox gaps;
    private JComboBox head;
    private JScrollPane info;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JProgressBar progress;
    private JToggleButton read;
    private JCheckBox rescan;
    private JTextArea text;
    private JComboBox tracks;
    private JToggleButton write;

    public SamDisk() {
        this.initComponents();
        this.text.setText("SAMdisk GUI 1.2 (May 11 2010), by Markus Hohmann -- http://cpc-live.com/\r\n");
        this.text.append("SAMdisk 3.4 (Aug 14 2012), (c) 2012 Simon Owen -- http://simonowen.com/samdisk/\r\n");
        this.text.select(2000000, 2000000);
    }

    public void Launch(boolean direction) throws InterruptedException, IOException {
        String line;
        String filename;
        FileDialog filedia;
        String file = null;
        if (direction) {
            filedia = new FileDialog(new Frame(), "Create DSK file", 1);
            filedia.setFile("*.dsk");
            filedia.setVisible(true);
            filename = filedia.getFile();
            if (filename != null) {
                filename = filedia.getDirectory() + filedia.getFile();
                if (!filename.toLowerCase().endsWith(".dsk")) {
                    filename = filename + ".dsk";
                }
                file = filename;
            }
        } else {
            filedia = new FileDialog(new Frame(), "Open DSK file", 0);
            filedia.setFile("*.dsk");
            filedia.setVisible(true);
            filename = filedia.getFile();
            if (filename != null) {
                file = filename = filedia.getDirectory() + filedia.getFile();
            }
        }
        if (file == null) {
            return;
        }
        this.text.setText("SAMdisk GUI 1.2 (May 11 2010), by Markus Hohmann -- http://cpc-live.com/\r\n");
        this.text.append("SAMdisk 3.4 (Aug 14 2012), (c) 2012 Simon Owen -- http://simonowen.com/samdisk/\r\n");
        String ending = "";
        if (this.head.getSelectedIndex() == 1) {
            ending = "-h0";
        }
        if (this.head.getSelectedIndex() == 2) {
            ending = "-h1";
        }
        String drv = this.drive[this.dselect.getSelectedIndex()];
        String command = "";
        if (this.gaps.isSelected()) {
            ending = ending + " --gaps";
        }
        command = direction ? drv + " \"" + file + "\" " + ending : "\"" + file + "\" " + drv + " " + ending;
        command = command + this.track[this.tracks.getSelectedIndex()];
        if (this.dstep.isSelected()) {
            command = command + " -d";
        }
        if (this.rescan.isSelected()) {
            command = command + " -R";
        }
        String n = System.getProperty("user.home") + "/JavaCPC/tools/SamDisk.exe" + command;
        this.process = Runtime.getRuntime().exec(n);
        this.text.append("SamDisk.exe " + command + "\r\n");
        this.text.select(20000000, 20000000);
        InputStream is = this.process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        this.jButton1.setEnabled(false);
        this.jButton2.setEnabled(true);
        this.progress.setIndeterminate(true);
        while ((line = br.readLine()) != null) {
            this.text.append(line + "\r\n");
            this.text.select(20000000, 20000000);
        }
        br.close();
        this.text.append("Done...\r\n");
        this.text.select(20000000, 20000000);
        this.progress.setIndeterminate(false);
        this.jButton1.setEnabled(true);
        this.jButton2.setEnabled(false);
        this.prog = 0;
        this.process = null;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.write = new JToggleButton();
        this.read = new JToggleButton();
        this.info = new JScrollPane();
        this.text = new JTextArea();
        this.jButton1 = new JButton();
        this.progress = new JProgressBar();
        this.jButton2 = new JButton();
        this.gaps = new JCheckBox();
        this.dselect = new JComboBox();
        this.jLabel1 = new JLabel();
        this.tracks = new JComboBox();
        this.jLabel2 = new JLabel();
        this.head = new JComboBox();
        this.jLabel3 = new JLabel();
        this.dstep = new JCheckBox();
        this.rescan = new JCheckBox();
        this.setTitle("SAMdisk GUI \u00a9 by Devilmarkus");
        this.setFocusable(false);
        this.setResizable(false);
        this.buttonGroup1.add(this.write);
        this.write.setText("Write DSK to Floppy");
        this.write.setFocusPainted(false);
        this.write.setFocusable(false);
        this.buttonGroup1.add(this.read);
        this.read.setSelected(true);
        this.read.setText("Read Floppy to DSK");
        this.read.setFocusPainted(false);
        this.read.setFocusable(false);
        this.text.setColumns(20);
        this.text.setEditable(false);
        this.text.setFont(new Font("Monospaced", 1, 12));
        this.text.setRows(5);
        this.info.setViewportView(this.text);
        this.jButton1.setText("Start");
        this.jButton1.setFocusPainted(false);
        this.jButton1.setFocusable(false);
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SamDisk.this.jButton1ActionPerformed(evt);
            }
        });
        this.progress.setMaximum(80);
        this.progress.setFocusable(false);
        this.jButton2.setText("Abort");
        this.jButton2.setEnabled(false);
        this.jButton2.setFocusPainted(false);
        this.jButton2.setFocusable(false);
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SamDisk.this.jButton2ActionPerformed(evt);
            }
        });
        this.gaps.setText("GAPs");
        this.gaps.setFocusPainted(false);
        this.gaps.setFocusable(false);
        this.dselect.setModel(new DefaultComboBoxModel<String>(new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"}));
        this.dselect.setFocusable(false);
        this.jLabel1.setText("Drive");
        this.tracks.setModel(new DefaultComboBoxModel<String>(new String[]{"Default", "39 Tracks", "42 Tracks", "79 Tracks"}));
        this.tracks.setFocusable(false);
        this.jLabel2.setText("Tracks");
        this.head.setModel(new DefaultComboBoxModel<String>(new String[]{"Both", "Head 0", "Head 1"}));
        this.head.setSelectedIndex(1);
        this.head.setFocusable(false);
        this.jLabel3.setText("Head:");
        this.dstep.setText("Double step");
        this.dstep.setFocusPainted(false);
        this.dstep.setFocusable(false);
        this.rescan.setText("Rescan");
        this.rescan.setFocusPainted(false);
        this.rescan.setFocusable(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.info, -1, 586, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.write).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.head, -2, 88, -2)).addComponent(this.read)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.gaps).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel1)).addComponent(this.dstep)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.dselect, -2, 47, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2)).addComponent(this.rescan)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progress, -1, 143, Short.MAX_VALUE).addComponent(this.tracks, 0, 143, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.write).addComponent(this.read).addComponent(this.gaps).addComponent(this.jLabel1).addComponent(this.dselect, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.tracks, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2).addComponent(this.jLabel3).addComponent(this.head, -2, -1, -2).addComponent(this.dstep).addComponent(this.rescan)).addComponent(this.progress, -2, 23, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.info, -1, 221, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.process == null) {
            Thread runner = new Thread(){

                public void run() {
                    try {
                        SamDisk.this.Launch(SamDisk.this.read.isSelected());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            runner.start();
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (this.process != null) {
            this.process.destroy();
            this.text.append("Progress aborted...\r\n");
            this.progress.setIndeterminate(false);
            this.jButton1.setEnabled(true);
            this.jButton2.setEnabled(false);
            this.prog = 0;
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SamDisk samdisk = new SamDisk();
                samdisk.setVisible(true);
                samdisk.setDefaultCloseOperation(3);
            }
        });
    }
}

