/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.ConfiguredUniverse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.vecmath.Color4f;
import javax.vecmath.Vector4f;
import jemu.settings.Settings;
import jemu.ui.Display;
import jemu.ui.Switches;

public class CurvaturedScreen
extends Panel
implements ActionListener,
FocusListener {
    protected final int polygons = 128;
    protected boolean halfsize = true;
    protected boolean DEBUG = false;
    protected WritableRaster raster;
    protected int[] pixels;
    protected ImageComponent2D imagecomponent;
    protected BufferedImage display;
    protected Graphics g;
    protected boolean skip;
    protected int frame;
    protected int startoff;
    protected int imageoffset;
    protected int y;
    protected boolean toggleit;
    protected int[] spixels;
    protected boolean imask;
    protected boolean repaint;
    protected int forcedraw = 0;
    protected int firsttime = 0;
    protected int texsizeX;
    protected int texsizeY;
    int sizex = 384;
    int sizey = 272;
    protected int offx;
    protected int offy;
    TextureLoader loader;
    Texture2D texture;
    Appearance appearance;
    BranchGroup group;
    Sphere sphere;
    private final PolygonAttributes polygonattributes;
    ButtonGroup but = new ButtonGroup();
    JRadioButton but1;
    JRadioButton but2;
    JRadioButton but3;
    ConfiguredUniverse universe;
    JPanel buts = new JPanel();
    boolean ispainted = true;
    BufferedImage mask;
    BufferedImage mask2;
    BufferedImage glance;
    int primflags;
    Display Display;

    public void focusLost(FocusEvent e) {
        System.out.println("3d-Panel: Focus lost");
    }

    public void focusGained(FocusEvent e) {
        System.out.println("3d-Panel: Focus gained");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.but1) {
            this.setRenderMode(0);
        } else if (e.getSource() == this.but2) {
            this.setRenderMode(1);
        } else if (e.getSource() == this.but3) {
            this.setRenderMode(2);
        }
    }

    public CurvaturedScreen(Display disp) {
        this.Display = disp;
        try {
            URL Mask = this.getClass().getResource("3d.png");
            this.mask = ImageIO.read(Mask);
            URL Mask2 = this.getClass().getResource("3dbezel.png");
            this.mask2 = ImageIO.read(Mask2);
            URL Glance = this.getClass().getResource("glass.png");
            this.glance = ImageIO.read(Glance);
        }
        catch (Exception Mask) {
            // empty catch block
        }
        this.halfsize = Settings.getBoolean("simple_textures", false);
        this.texsizeX = 1024;
        this.texsizeY = 512;
        this.sizex = 768;
        this.sizey = 272;
        this.offx = 128;
        this.offy = 120;
        if (!this.halfsize) {
            this.texsizeX = 1024;
            this.texsizeY = 1024;
            this.sizex = 768;
            this.sizey = 544;
            this.offx = 128;
            this.offy = 240;
        }
        this.display = new BufferedImage(this.texsizeX, this.texsizeY, 1);
        this.raster = this.display.getRaster();
        this.pixels = new int[this.texsizeX * this.texsizeY];
        this.g = this.display.getGraphics();
        this.but1 = new JRadioButton("Filled");
        this.but2 = new JRadioButton("Wireframe");
        this.but3 = new JRadioButton("Dots");
        this.but1.setFocusable(false);
        this.but2.setFocusable(false);
        this.but3.setFocusable(false);
        this.but1.setSelected(true);
        this.buts.setLayout(new FlowLayout());
        this.but.add(this.but1);
        this.but.add(this.but2);
        this.but.add(this.but3);
        this.buts.add(this.but1);
        this.buts.add(this.but2);
        this.buts.add(this.but3);
        this.buts.setFocusable(false);
        this.universe = new ConfiguredUniverse();
        this.universe.setVisible(false);
        this.group = new BranchGroup();
        this.loader = new TextureLoader((Image)this.display, 2, (Component)new Container());
        this.texture = (Texture2D)this.loader.getTexture();
        this.texture.setBoundaryColor(new Color4f(0.0f, 1.0f, 0.0f, 0.0f));
        this.texture.setCapability(7);
        this.imagecomponent = new ImageComponent2D(1, this.display);
        this.imagecomponent.setCapability(3);
        TextureAttributes texAttr = new TextureAttributes();
        texAttr.setTextureMode(2);
        texAttr.setTextureTransform(new Transform3D());
        this.appearance = new Appearance();
        this.appearance.setTexture((Texture)this.texture);
        TexCoordGeneration texcoord = new TexCoordGeneration();
        Vector4f v1 = new Vector4f(1.06f, 0.0f, 0.0f, 0.5f);
        texcoord.setPlaneS(v1);
        Vector4f v2 = new Vector4f(0.0f, 1.06f, 0.0f, 0.5f);
        texcoord.setPlaneT(v2);
        this.appearance.setTexCoordGeneration(texcoord);
        this.appearance.setTextureAttributes(texAttr);
        this.appearance.setCapability(3);
        this.polygonattributes = new PolygonAttributes();
        this.polygonattributes.setCapability(3);
        this.polygonattributes.setPolygonMode(2);
        this.appearance.setPolygonAttributes(this.polygonattributes);
        this.primflags = 3;
        this.sphere = new Sphere(1.56f, this.primflags, 128, this.appearance);
        this.group.addChild((Node)this.sphere);
        this.universe.getViewingPlatform().setNominalViewingTransform();
        this.universe.addBranchGraph(this.group);
        this.display.setAccelerationPriority(1.0f);
        this.setRenderMode(0);
        this.init();
        this.ispainted = true;
        this.startoff = this.offx + this.texsizeY * this.offy * (this.halfsize ? 2 : 1);
    }

    protected void init() {
        this.firsttime = 0;
        this.but1.addActionListener(this);
        this.but2.addActionListener(this);
        this.but3.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.universe.getCanvas(), "Center");
        this.setPreferredSize(new Dimension(768, 544));
        this.setBackground(Color.gray);
        if (this.DEBUG) {
            this.add((Component)this.buts, "South");
        }
        this.universe.getCanvas().setFocusable(false);
        this.universe.getCanvas().setDoubleBufferEnable(true);
        this.texture.setImage(0, (ImageComponent)this.imagecomponent);
        this.setVisible(true);
        this.setFocusable(true);
    }

    public void setRenderMode(int i) {
        switch (i) {
            case 0: {
                this.polygonattributes.setPolygonMode(2);
                break;
            }
            case 1: {
                this.polygonattributes.setPolygonMode(1);
                break;
            }
            case 2: {
                this.polygonattributes.setPolygonMode(0);
            }
        }
    }

    public void update(int[] sourcepixels, boolean usemask) {
        if (this.Display.skip) {
            boolean bl = this.toggleit = !this.toggleit;
            if (this.toggleit) {
                this.ispainted = true;
                jemu.ui.Display.painted = true;
                return;
            }
        }
        if (this.firsttime < 10) {
            ++this.firsttime;
            this.requestFocus();
        }
        if (this.spixels == null || this.spixels.length != sourcepixels.length) {
            this.spixels = new int[sourcepixels.length];
        }
        this.repaint = false;
        if (this.forcedraw >= 10) {
            this.forcedraw = 0;
            this.repaint = true;
        } else {
            for (int i = 0; i < this.spixels.length; i += 2) {
                if (this.spixels[i] == sourcepixels[i]) continue;
                this.repaint = true;
                break;
            }
        }
        if (!this.repaint) {
            ++this.forcedraw;
            this.ispainted = true;
            jemu.ui.Display.painted = true;
            return;
        }
        this.forcedraw = 0;
        System.arraycopy(sourcepixels, 0, this.spixels, 0, this.spixels.length);
        this.imask = usemask;
        this.updateImage();
    }

    protected void updateImage() {
        this.frame = 0;
        this.imageoffset = this.startoff;
        this.y = 0;
        while (this.y < (this.halfsize ? 272 : 544)) {
            System.arraycopy(this.spixels, 768 * this.y * (this.halfsize ? 2 : 1), this.pixels, this.imageoffset, 768);
            this.imageoffset += this.texsizeX;
            ++this.y;
        }
        this.raster.setDataElements(0, 0, this.texsizeX, this.texsizeY, this.pixels);
        if (this.imask) {
            if (Switches.mask) {
                this.g.drawImage(this.mask2, this.offx, this.offy, this.sizex, this.sizey, null);
                this.g.drawImage(this.glance, this.offx + 500, this.offy, 248, this.halfsize ? 207 : 414, null);
            } else {
                this.g.drawImage(this.mask, this.offx, this.offy, this.sizex, this.sizey, null);
            }
        }
        this.imagecomponent.set(this.display);
        this.ispainted = true;
        jemu.ui.Display.painted = true;
    }

    protected void update(final BufferedImage image, final boolean imask) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CurvaturedScreen.this.frame = 0;
                CurvaturedScreen.this.g.drawImage(image, CurvaturedScreen.this.offx, CurvaturedScreen.this.offy, 768, CurvaturedScreen.this.halfsize ? 272 : 544, null);
                if (imask) {
                    if (Switches.mask) {
                        CurvaturedScreen.this.g.drawImage(CurvaturedScreen.this.mask2, CurvaturedScreen.this.offx, CurvaturedScreen.this.offy, CurvaturedScreen.this.sizex, CurvaturedScreen.this.sizey, null);
                        CurvaturedScreen.this.g.drawImage(CurvaturedScreen.this.glance, CurvaturedScreen.this.offx + 500, CurvaturedScreen.this.offy, 248, CurvaturedScreen.this.halfsize ? 207 : 414, null);
                    } else {
                        CurvaturedScreen.this.g.drawImage(CurvaturedScreen.this.mask, CurvaturedScreen.this.offx, CurvaturedScreen.this.offy, CurvaturedScreen.this.sizex, CurvaturedScreen.this.sizey, null);
                    }
                }
                CurvaturedScreen.this.imagecomponent.set(CurvaturedScreen.this.display);
            }
        });
        this.ispainted = true;
        jemu.ui.Display.painted = true;
    }
}

