/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import jemu.settings.FSettings;
import jemu.ui.Browser_jAddressTextField_actionAdapter;
import jemu.ui.Browser_jBackButton_actionAdapter;
import jemu.ui.Browser_jFavsButton_actionAdapter;
import jemu.ui.Browser_jForwardButton_actionAdapter;
import jemu.ui.Browser_jGoButton_actionAdapter;
import jemu.ui.Browser_jHomeButton_actionAdapter;
import jemu.ui.Browser_jRefreshButton_actionAdapter;
import jemu.ui.Browser_jStopButton_actionAdapter;
import jemu.ui.FavPanel;
import jemu.ui.FavsWindow;
import jemu.ui.MyStatusBar;
import jemu.ui.OSValidator;
import org.jdesktop.jdic.browser.BrowserEngineManager;
import org.jdesktop.jdic.browser.WebBrowser;
import org.jdesktop.jdic.browser.WebBrowserEvent;
import org.jdesktop.jdic.browser.WebBrowserListener;

public class Browser
extends JPanel {
    FavPanel favp = new FavPanel();
    JSplitPane browse = new JSplitPane();
    public static ImageIcon browseIcon = new ImageIcon(Browser.class.getResource("paint/images/Right.gif"));
    BorderLayout borderLayout1 = new BorderLayout();
    JToolBar jBrowserToolBar = new JToolBar();
    JButton jStopButton = new JButton("Stopp", new ImageIcon(this.getClass().getResource("paint/images/Stop.png")));
    JButton jRefreshButton = new JButton("Refresh", new ImageIcon(this.getClass().getResource("paint/images/Reload.png")));
    JButton jForwardButton = new JButton("Forward", new ImageIcon(this.getClass().getResource("paint/images/Forward.png")));
    JButton jBackButton = new JButton("Back", new ImageIcon(this.getClass().getResource("paint/images/Back.png")));
    JButton jHomeButton = new JButton("Home", new ImageIcon(this.getClass().getResource("paint/images/Home.png")));
    JToggleButton jFavsButton = new JToggleButton("Favs", new ImageIcon(this.getClass().getResource("paint/images/Favs.png")));
    JPanel jAddressPanel = new JPanel();
    JLabel jAddressLabel = new JLabel();
    TextField jAddressTextField = new TextField();
    JButton jGoButton = new JButton();
    JPanel jAddrToolBarPanel = new JPanel();
    MyStatusBar statusBar = new MyStatusBar();
    JPanel jBrowserPanel = new JPanel();
    WebBrowser webBrowser;
    public FavsWindow favs = new FavsWindow();
    protected ActionListener gotolistener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Browser.this.gotoChanged(e);
        }
    };
    protected ActionListener refresh = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Browser.this.feedList();
        }
    };
    protected ActionListener handle = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Browser.this.favs.setVisible(true);
        }
    };
    public static boolean showFavs = false;
    int location = 0;

    public Browser() {
        try {
            this.jbInit();
            boolean ispressed = FSettings.getBoolean("fav_show", false);
            this.jFavsButton.setSelected(ispressed);
            this.jFavsButton.setFocusable(false);
            this.jStopButton.setFocusable(false);
            this.jRefreshButton.setFocusable(false);
            this.jForwardButton.setFocusable(false);
            this.jBackButton.setFocusable(false);
            this.jHomeButton.setFocusable(false);
            this.jAddressTextField.setFocusable(true);
            this.jAddressTextField.setBackground(Color.white);
            this.jAddressTextField.setForeground(Color.black);
            this.favs.buildFavs();
            this.favs.goTo.addActionListener(this.gotolistener);
            this.favs.goTo.addActionListener(this.refresh);
            this.favs.add.addActionListener(this.refresh);
            this.favs.remove.addActionListener(this.refresh);
            this.favp.handle.addActionListener(this.handle);
            this.favp.jList1.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent evt) {
                    Browser.this.setURL(Browser.this.favs.curls[Browser.this.favp.jList1.getSelectedIndex()]);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void feedList() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.favp.jList1.setModel(new AbstractListModel(){

            public int getSize() {
                return Browser.this.favs.all;
            }

            public Object getElementAt(int i) {
                return Browser.this.favs.cnames[i];
            }
        });
    }

    private void jList1MouseReleased(MouseEvent evt) {
        this.setURL(this.favs.curls[this.favp.jList1.getSelectedIndex()]);
    }

    public void gotoChanged(ActionEvent e) {
        try {
            this.setURL(this.favs.curls[this.favs.fcombo.getSelectedIndex()]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setURL(String url) {
        try {
            this.webBrowser.setURL(new URL(url));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        System.out.println("Starting webbrowser");
        JFrame frame = new JFrame("JavaCPC Browser");
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new GridLayout(1, 1));
        contentPane.add(new Browser());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
        System.out.println();
        System.out.println("Started...");
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension(screenSize.width * 9 / 10, screenSize.height * 8 / 10));
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.jAddressLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.jAddressLabel.setToolTipText("");
        this.jAddressLabel.setText(" URL: ");
        this.jGoButton.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(0, 2, 0, 2), new EtchedBorder()));
        this.jGoButton.setMaximumSize(new Dimension(60, 25));
        this.jGoButton.setMinimumSize(new Dimension(60, 25));
        this.jGoButton.setPreferredSize(new Dimension(60, 25));
        this.jGoButton.setToolTipText("Load the given URL");
        this.jGoButton.setIcon(browseIcon);
        this.jGoButton.setText("GO");
        this.jGoButton.addActionListener(new Browser_jGoButton_actionAdapter(this));
        this.jAddressPanel.setLayout(new BorderLayout());
        this.jAddressTextField.addActionListener(new Browser_jAddressTextField_actionAdapter(this));
        this.jAddressTextField.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Browser.this.jAddressTextField.selectAll();
            }
        });
        this.jBackButton.setToolTipText("Go back one page");
        this.jBackButton.setHorizontalTextPosition(11);
        this.jBackButton.setEnabled(false);
        this.jBackButton.setMaximumSize(new Dimension(75, 27));
        this.jBackButton.setPreferredSize(new Dimension(75, 27));
        this.jBackButton.addActionListener(new Browser_jBackButton_actionAdapter(this));
        this.jHomeButton.setToolTipText("Go to homepage");
        this.jHomeButton.setHorizontalTextPosition(11);
        this.jHomeButton.setEnabled(true);
        this.jHomeButton.setMaximumSize(new Dimension(75, 27));
        this.jHomeButton.setPreferredSize(new Dimension(75, 27));
        this.jHomeButton.addActionListener(new Browser_jHomeButton_actionAdapter(this));
        this.jFavsButton.setToolTipText("List favourites");
        this.jFavsButton.setHorizontalTextPosition(11);
        this.jFavsButton.setEnabled(true);
        this.jFavsButton.setMaximumSize(new Dimension(75, 27));
        this.jFavsButton.setPreferredSize(new Dimension(75, 27));
        this.jFavsButton.addActionListener(new Browser_jFavsButton_actionAdapter(this));
        this.jForwardButton.setToolTipText("Go forward one page");
        this.jForwardButton.setEnabled(false);
        this.jForwardButton.addActionListener(new Browser_jForwardButton_actionAdapter(this));
        this.jRefreshButton.setToolTipText("Reload current page");
        this.jRefreshButton.setEnabled(true);
        this.jRefreshButton.setMaximumSize(new Dimension(75, 27));
        this.jRefreshButton.setMinimumSize(new Dimension(75, 27));
        this.jRefreshButton.setPreferredSize(new Dimension(75, 27));
        this.jRefreshButton.addActionListener(new Browser_jRefreshButton_actionAdapter(this));
        this.jStopButton.setToolTipText("Stop loading this page");
        this.jStopButton.setVerifyInputWhenFocusTarget(true);
        this.jStopButton.setText("Stop");
        this.jStopButton.setEnabled(true);
        this.jStopButton.setMaximumSize(new Dimension(75, 27));
        this.jStopButton.setMinimumSize(new Dimension(75, 27));
        this.jStopButton.setPreferredSize(new Dimension(75, 27));
        this.jStopButton.addActionListener(new Browser_jStopButton_actionAdapter(this));
        this.jAddressPanel.add((Component)this.jAddressLabel, "West");
        this.jAddressPanel.add((Component)this.jAddressTextField, "Center");
        this.jAddressPanel.add((Component)this.jGoButton, "East");
        this.jAddressPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 0, 2, 0)));
        this.jBrowserToolBar.setFloatable(false);
        this.jBrowserToolBar.add((Component)this.jBackButton, null);
        this.jBrowserToolBar.add((Component)this.jForwardButton, null);
        this.jBrowserToolBar.addSeparator();
        this.jBrowserToolBar.add((Component)this.jRefreshButton, null);
        this.jBrowserToolBar.add((Component)this.jStopButton, null);
        this.jBrowserToolBar.add((Component)this.jHomeButton, null);
        this.jBrowserToolBar.add((Component)this.jFavsButton, null);
        this.jBrowserToolBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 0)));
        this.jAddrToolBarPanel.setLayout(new BorderLayout());
        this.jAddrToolBarPanel.add((Component)this.jAddressPanel, "Center");
        this.jAddrToolBarPanel.add((Component)this.jBrowserToolBar, "West");
        this.jAddrToolBarPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        this.statusBar.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.statusBar.lblDesc.setText("JavaCPC - WebBrowser");
        this.webBrowser = new WebBrowser();
        if (OSValidator.isWindows()) {
            BrowserEngineManager bem = BrowserEngineManager.instance();
            bem.setActiveEngine(BrowserEngineManager.IE);
        }
        this.webBrowser.addWebBrowserListener(new WebBrowserListener(){

            public void downloadStarted(WebBrowserEvent event) {
                Browser.this.updateStatusInfo("Loading started.");
            }

            public void initializationCompleted(WebBrowserEvent event) {
            }

            public void downloadCompleted(WebBrowserEvent event) {
                Browser.this.jBackButton.setEnabled(Browser.this.webBrowser.isBackEnabled());
                Browser.this.jForwardButton.setEnabled(Browser.this.webBrowser.isForwardEnabled());
                Browser.this.updateStatusInfo("Loading completed.");
                URL currentUrl = Browser.this.webBrowser.getURL();
                if (currentUrl != null) {
                    Browser.this.jAddressTextField.setText(currentUrl.toString());
                }
            }

            public void downloadProgress(WebBrowserEvent event) {
            }

            public void downloadError(WebBrowserEvent event) {
                Browser.this.updateStatusInfo("Loading error.");
            }

            public void documentCompleted(WebBrowserEvent event) {
                Browser.this.updateStatusInfo("Document loading completed.");
                Browser.this.favs.ufield.setText(Browser.this.webBrowser.getURL().toString());
                String cont = Browser.this.webBrowser.getContent();
                String title = "";
                try {
                    while (!cont.toUpperCase().startsWith("<TITLE>")) {
                        cont = cont.substring(1);
                    }
                    if (cont.toUpperCase().startsWith("<TITLE>")) {
                        cont = cont.substring(7);
                        int g = 0;
                        while (cont.charAt(g) != '<') {
                            title = title + cont.charAt(g++);
                            if (cont.charAt(g) != '<') continue;
                        }
                        Browser.this.favs.nfield.setText(title);
                    } else {
                        Browser.this.favs.nfield.setText(Browser.this.webBrowser.getURL().toString());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void titleChange(WebBrowserEvent event) {
                Browser.this.updateStatusInfo("Title of the browser window changed.");
            }

            public void statusTextChange(WebBrowserEvent event) {
            }
        });
        this.jBrowserPanel.setLayout(new BorderLayout());
        this.browse.setLeftComponent(this.favp);
        if (FSettings.getBoolean("fav_show", false)) {
            this.browse.setDividerLocation(200);
            this.location = 200;
            showFavs = true;
            this.favp.setVisible(true);
        } else {
            this.browse.setDividerLocation(0);
            this.location = 0;
            showFavs = false;
            this.favp.setVisible(false);
        }
        this.browse.setDividerSize(0);
        JPanel brows = new JPanel();
        brows.setLayout(new BorderLayout());
        brows.add((Component)this.webBrowser, "Center");
        this.browse.setRightComponent(brows);
        this.feedList();
        this.jBrowserPanel.add((Component)this.browse, "Center");
        this.add((Component)this.jAddrToolBarPanel, "North");
        this.add((Component)this.statusBar, "South");
        this.add((Component)this.jBrowserPanel, "Center");
    }

    void updateStatusInfo(String statusMessage) {
        this.statusBar.lblStatus.setText(statusMessage);
    }

    void loadURL() {
        String inputValue = this.jAddressTextField.getText();
        if (inputValue == null) {
            JOptionPane.showMessageDialog(this, "The given URL is NULL:", "Warning", 2);
        } else {
            URL curUrl = null;
            try {
                File[] roots = File.listRoots();
                for (int i = 0; i < roots.length; ++i) {
                    if (!inputValue.toLowerCase().startsWith(roots[i].toString().toLowerCase())) continue;
                    File curLocalFile = new File(inputValue);
                    curUrl = curLocalFile.toURL();
                    break;
                }
                if (curUrl == null) {
                    try {
                        curUrl = new URL(inputValue);
                    }
                    catch (MalformedURLException e) {
                        curUrl = inputValue.toLowerCase().startsWith("ftp.") ? new URL("ftp://" + inputValue) : (inputValue.toLowerCase().startsWith("gopher.") ? new URL("gopher://" + inputValue) : new URL("http://" + inputValue));
                    }
                }
                this.webBrowser.setURL(curUrl);
                this.updateStatusInfo("Loading " + curUrl.toString() + " ......");
            }
            catch (MalformedURLException mue) {
                JOptionPane.showMessageDialog(this, "The given URL is not valid:" + inputValue, "Warning", 2);
            }
        }
    }

    void jGoButton_actionPerformed(ActionEvent e) {
        this.loadURL();
    }

    void jAddressTextField_actionPerformed(ActionEvent e) {
        this.loadURL();
    }

    void jBackButton_actionPerformed(ActionEvent e) {
        this.webBrowser.back();
    }

    void jHomeButton_actionPerformed(ActionEvent e) {
        this.setURL("http://cpc-live.com");
    }

    void jFavsButton_actionPerformed(ActionEvent e) {
        if (this.location == 0) {
            FSettings.setBoolean("fav_show", true);
            this.browse.setDividerLocation(200);
            showFavs = true;
            this.location = 200;
            this.favp.setVisible(true);
        } else {
            this.browse.setDividerLocation(0);
            FSettings.setBoolean("fav_show", false);
            showFavs = false;
            this.location = 0;
            this.favp.setVisible(false);
        }
    }

    void jForwardButton_actionPerformed(ActionEvent e) {
        this.webBrowser.forward();
    }

    void jRefreshButton_actionPerformed(ActionEvent e) {
        this.webBrowser.refresh();
    }

    void jStopButton_actionPerformed(ActionEvent e) {
        this.webBrowser.stop();
    }
}

