/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jemu.core.device.Device;
import jemu.core.samples.Samples;
import jemu.system.cpc.Baslist;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;
import jemu.ui.Desktop;
import jemu.ui.JEMU;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.GutterIconInfo;
import org.fife.ui.rtextarea.RTextScrollPane;

public class Basic
extends JFrame {
    protected GutterIconInfo[] breakinfo;
    public RSyntaxTextArea bcodeField;
    public RTextScrollPane bscrollField;
    Baslist list;
    int currentnumber;
    int breaknumber;
    int adr = 44573;
    byte[] w = new byte[2];
    byte[] wd = new byte[2];
    int storeA;
    int storeB;
    String currline;
    int oldline = -1;
    int verylastline = 0;
    int lastline = 0;
    int stopline = 0;
    int coldline;
    int line;
    public boolean stopstate = false;
    public boolean step = false;
    public JCheckBox auto;
    private JTextField breakp;
    private JTextField curline;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    public JCheckBox track;

    protected void stopBreakpoint() {
        if (this.list == null || this.list.addresses == null) {
            return;
        }
    }

    protected void checkPoints() {
        if (this.list == null) {
            this.list = GateArray.cpc.getBasLister();
        }
        if (this.list == null) {
            return;
        }
        JEMU.debugger.removeAllBreakpoints();
        this.breakinfo = this.bscrollField.getGutter().getBookmarks();
        int[] breakline = new int[this.breakinfo.length];
        for (int i = 0; i < this.breakinfo.length; ++i) {
            this.bcodeField.setCaretPosition(this.breakinfo[i].getMarkedOffset());
            breakline[i] = this.bcodeField.getCaretLineNumber();
        }
        if (!JEMU.debugger.bPoints.isSelected()) {
            JEMU.debugger.bPoints.setSelected(true);
        }
    }

    public Basic() {
        this.bcodeField = new RSyntaxTextArea();
        this.bcodeField.setLocale(Locale.ENGLISH);
        try {
            this.bcodeField.setSyntaxEditingStyle("text/c");
            this.bcodeField.setAnimateBracketMatching(true);
            this.bcodeField.setCaretColor(Color.BLUE);
            this.bscrollField = new RTextScrollPane(this.bcodeField);
            this.bscrollField.gutter.setBackground(this.getBackground());
            this.bscrollField.gutter.setLineNumberColor(this.getForeground());
            this.bscrollField.getGutter().setBookmarkIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/ico/breakpoint.gif")));
            this.bscrollField.getGutter().setBookmarkingEnabled(true);
            this.bscrollField.setIconRowHeaderEnabled(true);
            this.bscrollField.setBackground(this.getBackground());
            this.bscrollField.setLineNumbersEnabled(true);
            this.bscrollField.setPreferredSize(new Dimension(640, 400));
            this.bcodeField.setEditable(true);
            this.bcodeField.setLineWrap(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initComponents();
        this.add((Component)this.bscrollField, "Center");
        this.pack();
    }

    public void cycle() {
        if (this.list == null) {
            return;
        }
        if (this.list.addresses == null) {
            return;
        }
        this.wd[0] = (byte)CPC.memory.readWriteByte(this.adr);
        this.wd[1] = (byte)CPC.memory.readWriteByte(this.adr + 1);
        int val = Device.getWord(this.wd, 0);
        for (int i = 0; i < this.list.addresses.length; ++i) {
            if (this.list.addresses[i] != val) continue;
            this.currentnumber = this.list.lines[i];
            this.storeA = this.list.addresses[i];
            this.storeB = this.list.lines[i];
            this.currline = this.list.codes[i];
            break;
        }
        if (this.currentnumber != 0) {
            if (this.currentnumber == this.breaknumber && this.oldline != this.currentnumber) {
                this.breaknumber = -1;
                this.oldline = this.currentnumber;
                this.curline.setText("" + this.storeB);
                this.bcodeField.setText(this.currline);
                JEMU.debugger.getDebuggerComputer().stop();
                Samples.BREAK.play();
                if (JEMU.iframe == null) {
                    JEMU.debugframe.setVisible(true);
                } else {
                    Desktop.debug.setVisible(true);
                }
            } else {
                this.oldline = -1;
            }
        }
    }

    public void reset() {
        this.lastline = 0;
        this.verylastline = 0;
    }

    public boolean processNextLine() {
        this.w[0] = (byte)CPC.memory.readWriteByte(this.adr);
        this.w[1] = (byte)CPC.memory.readWriteByte(this.adr + 1);
        this.verylastline = Device.getWord(this.w, 0);
        if (this.verylastline != this.lastline) {
            this.lastline = this.verylastline;
            return true;
        }
        return false;
    }

    void catchLineNumber() {
        block8: {
            if (this.list == null) {
                this.list = GateArray.cpc.getBasLister();
            }
            if (this.list == null) {
                return;
            }
            this.w[0] = (byte)CPC.memory.readWriteByte(this.adr);
            this.w[1] = (byte)CPC.memory.readWriteByte(this.adr + 1);
            int val = Device.getWord(this.w, 0);
            try {
                this.breaknumber = Integer.parseInt(this.breakp.getText()) < 1 ? -1 : Integer.parseInt(this.breakp.getText());
                if (val == 0) break block8;
                for (int i = 0; i < this.list.addresses.length; ++i) {
                    if (this.list.addresses[i] != val) continue;
                    this.line = this.list.lines[i];
                    if (this.coldline == this.line) {
                        return;
                    }
                    this.coldline = this.line;
                    this.curline.setText("" + this.line);
                    if (this.track.isSelected()) {
                        this.bcodeField.setText(this.list.codes[i]);
                    }
                    if (this.stopline != this.line && this.stopstate) {
                        JEMU.debugger.getDebuggerComputer().stop();
                        JEMU.debugger.updateDisplay();
                        JEMU.debugger.getDebuggerComputer().repaintDisplay();
                    }
                    this.stopline = this.line;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.breaknumber = -1;
            }
        }
    }

    public void update() {
        try {
            if (!this.track.isSelected()) {
                this.bcodeField.setText(GateArray.cpc.getBasList());
                this.catchLineNumber();
            } else {
                GateArray.cpc.getBasList();
                this.catchLineNumber();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.jButton2 = new JButton();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.breakp = new JTextField();
        this.jLabel1 = new JLabel();
        this.curline = new JTextField();
        this.jPanel3 = new JPanel();
        this.auto = new JCheckBox();
        this.track = new JCheckBox();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jPanel4 = new JPanel();
        this.jButton2.setText("Check Breakpoints");
        this.jButton2.setEnabled(false);
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Basic.this.jButton2ActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(3);
        this.jPanel1.setLayout(new BorderLayout());
        this.jButton1.setText("List");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Basic.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButton1, "West");
        this.jLabel2.setText("*BREAK* @: ");
        this.jPanel2.add(this.jLabel2);
        this.breakp.setColumns(5);
        this.breakp.setFont(new Font("Monospaced", 1, 12));
        this.breakp.setHorizontalAlignment(4);
        this.breakp.setText("0");
        this.jPanel2.add(this.breakp);
        this.jLabel1.setText("Current Line:");
        this.jPanel2.add(this.jLabel1);
        this.curline.setColumns(5);
        this.curline.setFont(new Font("Monospaced", 1, 12));
        this.curline.setHorizontalAlignment(4);
        this.curline.setText("0");
        this.jPanel2.add(this.curline);
        this.jPanel1.add((Component)this.jPanel2, "After");
        this.auto.setText("Auto Update");
        this.auto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Basic.this.autoActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.auto);
        this.track.setText("TRACE BASIC");
        this.track.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Basic.this.trackActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.track);
        this.jButton3.setText("RUN");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Basic.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton3);
        this.jButton4.setText("STOP");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Basic.this.jButton4ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton4);
        this.jButton5.setText("STEP");
        this.jButton5.setEnabled(false);
        this.jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Basic.this.jButton5ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton5);
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel3.add(this.jPanel4);
        this.jPanel1.add((Component)this.jPanel3, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Last");
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.checkPoints();
    }

    private void autoActionPerformed(ActionEvent evt) {
        this.jButton1.setEnabled(!this.auto.isSelected());
    }

    private void trackActionPerformed(ActionEvent evt) {
        this.jButton5.setEnabled(this.track.isSelected());
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        JEMU.debugger.getDebuggerComputer().start();
        this.stopstate = false;
        this.step = false;
        this.reset();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.stop();
        this.reset();
        this.step = false;
    }

    protected void stop() {
        JEMU.debugger.getDebuggerComputer().stop();
        JEMU.debugger.updateDisplay();
        JEMU.debugger.getDebuggerComputer().repaintDisplay();
        this.stopstate = true;
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        JEMU.debugger.getDebuggerComputer().start();
        this.step = true;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Basic().setVisible(true);
            }
        });
    }
}

