/*
 * Decompiled with CFR 0.152.
 */
package jemu.settings;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.SwingUtilities;
import jemu.core.Util;
import jemu.system.cpc.GateArray;

public class Palette {
    static int tried;
    private static File file;
    private static final Palette instance;
    private final Properties props = new Properties();
    public static final String INK = "ink_";

    public static void resetSettings() {
        while (file.exists()) {
            try {
                file.delete();
                Thread.sleep(100L);
                if (++tried <= 10) continue;
                System.out.println("Clearing the config failed...");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Palette() {
        try {
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkRead(file.getAbsolutePath());
            }
            this.props.load(new FileInputStream(file));
            System.out.println("loaded " + this.props.size() + " palette settings");
        }
        catch (Throwable t) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (int i = 0; i < 32; ++i) {
                        String ink = "" + i;
                        if (i < 10) {
                            ink = "0" + ink;
                        }
                        Palette.set(Palette.INK + ink, "" + Util.hex(GateArray.inkTranslateColor[GateArray.Inks[i]]).substring(2));
                    }
                }
            });
        }
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = Palette.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("true");
    }

    public static int getRGB(int ink) {
        int rgb = 0;
        String i = "" + ink;
        if (ink < 10) {
            i = "0" + i;
        }
        String val = Palette.get(INK + i, "" + Util.hex(GateArray.inkTranslateColor[GateArray.Inks[ink]]).substring(2));
        rgb = Util.hexValue(val);
        return rgb;
    }

    public static void main(String[] args) {
        Palette.getRGB(0);
    }

    public static int getInt(String key, int defaultValue) {
        String value = Palette.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static void setBoolean(String key, boolean value) {
        Palette.instance.props.setProperty(key, value ? "true" : "false");
        Palette.save();
    }

    public static String get(String key, String defaultValue) {
        String value = Palette.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void set(String key, String value) {
        if (value.equals(Palette.get(key, null))) {
            return;
        }
        Palette.instance.props.setProperty(key, value);
        Palette.save();
    }

    private static void save() {
        try {
            File f = new File(System.getProperty("user.home"), "JavaCPC");
            if (!f.exists()) {
                f.mkdir();
            }
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkWrite(file.getAbsolutePath());
            }
            FileOutputStream fos = new FileOutputStream(file);
            Palette.instance.props.store(fos, "[Palette]");
            StringBuilder contents = new StringBuilder();
            BufferedReader reader = null;
            FileReader fre = new FileReader(file);
            reader = new BufferedReader(fre);
            String text = null;
            while ((text = reader.readLine()) != null) {
                contents.append(text).append(System.getProperty("line.separator"));
            }
            reader.close();
            fre.close();
            String result = contents.toString();
            Object[] res = result.split("\n");
            Arrays.sort(res);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            for (int i = 0; i < res.length; ++i) {
                bos.write(((String)res[i] + '\n').getBytes("UTF-8"));
            }
            bos.close();
        }
        catch (Throwable t) {
            System.out.println("can't save user settings (" + t.getMessage() + ")");
        }
    }

    static {
        file = new File(System.getProperty("user.home"), "/JavaCPC/cpc_palette.txt");
        instance = new Palette();
    }
}

