/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.tape;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import jemu.core.device.tape.TapeDeck;
import jemu.system.cpc.CPC;
import jemu.ui.Switches;

public class TapeWheels
extends JPanel {
    BufferedImage panel = new BufferedImage(55, 28, 1);
    private final int CANVAS_WIDTH = 55;
    private final int CANVAS_HEIGHT = 28;
    private Color wheel = new Color(13816796);
    private Color spindle = new Color(5978926);
    private Color back = new Color(3421752);
    private Color mirror = new Color(11180181);
    private boolean flash;
    private boolean flashb;
    Graphics page;
    private int center = -4;
    private int right = 48;
    private int left = -30;
    private int leftwheel;
    private int rightwheel;
    private int size;
    private int highvalue;

    public TapeWheels() {
        this.setBackground(this.back);
        this.setForeground(Color.GRAY);
        this.setPreferredSize(new Dimension(55, 28));
        this.setFont(new Font("Arial", 1, 9));
        this.page = this.panel.getGraphics();
    }

    public void paintWheels() {
        Graphics p = this.getGraphics();
        this.page.setColor(this.back);
        this.page.fillRect(0, 0, 55, 28);
        this.page.setColor(this.mirror);
        this.page.fillRect(6, 2, 42, 20);
        if (CPC.tapesample != null && CPC.tapesample.length > 1) {
            int div = 2;
            if (Switches.khz11) {
                div = 4;
            }
            if (Switches.khz44) {
                div = 1;
            }
            this.highvalue = this.size = CPC.tapesample.length / 1400000 * div;
            this.rightwheel = this.size = CPC.tape_band_pos / 1400000 * div;
            this.leftwheel = this.highvalue - this.rightwheel;
            if (this.leftwheel < 1) {
                this.leftwheel = 1;
            }
            ++this.rightwheel;
            this.page.setColor(this.spindle);
            if (TapeDeck.newtape) {
                if (this.flash) {
                    this.page.setColor(Color.red);
                    this.flash = false;
                } else {
                    this.flash = true;
                }
            }
            this.page.fillOval(this.left - this.leftwheel / 2, this.center - this.leftwheel / 2, 36 + this.leftwheel, 36 + this.leftwheel);
            if (TapeDeck.newtape) {
                if (this.flashb) {
                    this.page.setColor(Color.green);
                    this.flashb = false;
                } else {
                    this.flashb = true;
                }
            }
            this.page.fillOval(this.right - this.rightwheel / 2, this.center - this.rightwheel / 2, 36 + this.rightwheel, 36 + this.rightwheel);
            this.page.setColor(this.wheel);
            this.page.fillOval(this.left, this.center, 36, 36);
            this.page.fillOval(this.right, this.center, 36, 36);
        }
        p.drawImage(this.panel, 0, 0, this);
    }
}

