/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.keyboard;

import java.util.Hashtable;
import jemu.core.Util;
import jemu.core.device.Device;

public class MatrixKeyboard
extends Device {
    public static final int KEY_RIGHT = 65536;
    protected int[] pressMap = new int[4096];
    protected int[][] keyMap;
    protected Hashtable mappings = new Hashtable();

    public MatrixKeyboard(String type, int cols, int rows) {
        super("Matrix Keyboard");
        this.keyMap = new int[rows][cols];
    }

    public void reset() {
        for (int row = 0; row < this.keyMap.length; ++row) {
            int[] keyRow = this.keyMap[row];
            for (int col = 0; col < keyRow.length; ++col) {
                this.setKeyMap(col, row, 0);
            }
        }
    }

    protected void setKeyMap(int col, int row, int value) {
        int oldValue = this.keyMap[row][col];
        if (oldValue != value) {
            this.keyMap[row][col] = value;
            this.keyChanged(col, row, oldValue, value);
            this.checkClash();
        }
    }

    public boolean isKeyPressed(int col, int row) {
        return row >= 0 && row < this.keyMap.length && col >= 0 && col < this.keyMap[row].length && this.keyMap[row][col] != 0;
    }

    protected void checkClash() {
    }

    protected void keyChanged(int col, int row, int oldValue, int newValue) {
    }

    public void addKeyMapping(int key, int col, int row) {
        KeyMapping mapping = (KeyMapping)this.mappings.get(new Integer(key));
        if (mapping == null) {
            mapping = new KeyMapping();
            this.mappings.put(new Integer(key), mapping);
        }
        mapping.addMapping(col, row);
    }

    public void addKeyMapping(String key, int col, int row) {
        KeyMapping mapping = (KeyMapping)this.mappings.get(new Integer(key));
        if (mapping == null) {
            mapping = new KeyMapping();
            this.mappings.put(new Integer(key), mapping);
        }
        mapping.addMapping(col, row);
    }

    public void addKeyMappings(int[] map) {
        int cols = this.keyMap[0].length;
        for (int i = 0; i < map.length; ++i) {
            if (map[i] == -1) continue;
            this.addKeyMapping(map[i], i % cols, i / cols);
        }
    }

    public void addKeyMappings(int[][] map) {
        for (int row = 0; row < map.length; ++row) {
            for (int col = 0; col < map[row].length; ++col) {
                if (map[row][col] == -1) continue;
                this.addKeyMapping(map[row][col], col, row);
            }
        }
    }

    public void removeKeyMapping(int key, int col, int row) {
        KeyMapping mapping = (KeyMapping)this.mappings.get(new Integer(key));
        if (mapping != null) {
            mapping.removeMapping(col, row);
            if (mapping.getCount() == 0) {
                this.mappings.remove(mapping);
            }
        }
    }

    public void keyPressed(int key) {
        this.keyPressed(key, 0);
    }

    public void keyPressed(int key, int location) {
        this.keyChange(key, location, 1);
    }

    public void keyReleased(int key) {
        this.keyReleased(key, 0);
    }

    public void keyReleased(int key, int location) {
        this.keyChange(key, location, -1);
    }

    protected void keyChange(int key, int location, int step) {
        int offs;
        int mask = 1 << (key & 0x1F);
        boolean right = location == 3;
        int n = offs = right ? 2048 + key / 32 : key / 32;
        if (step != 1 || (this.pressMap[offs] & mask) == 0) {
            KeyMapping mapping = null;
            if (right) {
                mapping = (KeyMapping)this.mappings.get(new Integer(key | 0x10000));
            }
            if (mapping == null) {
                mapping = (KeyMapping)this.mappings.get(new Integer(key));
            }
            if (mapping != null) {
                mapping.keyChange(step);
            }
            if (step == 1) {
                int n2 = offs;
                this.pressMap[n2] = this.pressMap[n2] | mask;
            } else {
                int n3 = offs;
                this.pressMap[n3] = this.pressMap[n3] & ~mask;
            }
        }
    }

    protected class KeyMapping {
        protected int[] cols = new int[0];
        protected int[] rows = new int[0];

        protected KeyMapping() {
        }

        protected void addMapping(int col, int row) {
            this.cols = Util.arrayInsert(this.cols, this.cols.length, 1, col);
            this.rows = Util.arrayInsert(this.rows, this.rows.length, 1, row);
        }

        protected void removeMapping(int col, int row) {
            for (int i = 0; i < this.cols.length; ++i) {
                if (this.cols[i] != col || this.rows[i] != row) continue;
                this.cols = Util.arrayDelete(this.cols, i, 1);
                this.rows = Util.arrayDelete(this.rows, i, 1);
                break;
            }
        }

        protected int getCount() {
            return this.cols.length;
        }

        protected void keyChange(int step) {
            for (int i = 0; i < this.cols.length; ++i) {
                int col = this.cols[i];
                int row = this.rows[i];
                MatrixKeyboard.this.setKeyMap(col, row, Math.max(0, MatrixKeyboard.this.keyMap[row][col] + step));
            }
        }
    }
}

