/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.internalfilesystem;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

class BeauchampEncoder {
    public static final boolean ENCODE_ALPHA = true;
    public static final boolean NO_ALPHA = false;
    public static final int FILTER_NONE = 0;
    public static final int FILTER_SUB = 1;
    public static final int FILTER_UP = 2;
    public static final int FILTER_LAST = 2;
    protected byte[] pngBytes;
    protected byte[] priorRow;
    protected byte[] leftBytes;
    protected int width;
    protected int height;
    protected int bytePos;
    protected int maxPos;
    protected int hdrPos;
    protected int dataPos;
    protected int endPos;
    protected CRC32 crc = new CRC32();
    protected long crcValue;
    protected boolean encodeAlpha;
    protected int filter;
    protected int bytesPerPixel;
    protected int compressionLevel;
    protected BufferedImage image;
    protected WritableRaster wRaster;
    protected int tType;

    public BeauchampEncoder() {
        this(null, false, 0, 0);
    }

    public BeauchampEncoder(BufferedImage bufferedimage) {
        this(bufferedimage, false, 0, 0);
    }

    public BeauchampEncoder(BufferedImage bufferedimage, boolean flag) {
        this(bufferedimage, flag, 0, 0);
    }

    public BeauchampEncoder(BufferedImage bufferedimage, boolean flag, int i) {
        this(bufferedimage, flag, i, 0);
    }

    public BeauchampEncoder(BufferedImage bufferedimage, boolean flag, int i, int j) {
        this.encodeAlpha = flag;
        this.setFilter(i);
        if (j >= 0 && j <= 9) {
            this.compressionLevel = j;
        }
        this.image = bufferedimage;
    }

    protected boolean establishStorageInfo() {
        this.wRaster = this.image.getRaster();
        int i = this.wRaster.getNumDataElements();
        this.tType = this.wRaster.getTransferType();
        if (this.tType == 0 && i == 4 || this.tType == 3 && i == 1) {
            this.bytesPerPixel = this.encodeAlpha ? 4 : 3;
        } else if (this.tType == 0 && i == 1) {
            this.bytesPerPixel = 1;
            this.encodeAlpha = false;
        } else {
            return false;
        }
        return true;
    }

    public byte[] pngEncode() {
        return this.pngEncode(this.encodeAlpha);
    }

    public byte[] pngEncode(boolean flag) {
        byte[] abyte0 = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        if (this.image == null) {
            return null;
        }
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        this.image = this.image;
        if (!this.establishStorageInfo()) {
            return null;
        }
        this.pngBytes = new byte[(this.width + 1) * this.height * 3 + 200];
        this.maxPos = 0;
        this.hdrPos = this.bytePos = this.writeBytes(abyte0, 0);
        this.writeHeader();
        this.dataPos = this.bytePos;
        if (this.writeImageData()) {
            this.writeEnd();
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.maxPos);
        } else {
            this.pngBytes = null;
        }
        return this.pngBytes;
    }

    public void setImage(BufferedImage bufferedimage) {
        this.image = bufferedimage;
        this.pngBytes = null;
    }

    protected void writeHeader() {
        int i = this.bytePos = this.writeInt4(13, this.bytePos);
        this.bytePos = this.writeString("IHDR", this.bytePos);
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        this.bytePos = this.writeInt4(this.width, this.bytePos);
        this.bytePos = this.writeInt4(this.height, this.bytePos);
        this.bytePos = this.writeByte(8, this.bytePos);
        this.bytePos = this.bytesPerPixel != 1 ? this.writeByte(this.encodeAlpha ? 6 : 2, this.bytePos) : this.writeByte(3, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.crc.reset();
        this.crc.update(this.pngBytes, i, this.bytePos - i);
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }

    protected boolean writeImageData() {
        int i = this.height;
        int j = 0;
        Deflater deflater = new Deflater(this.compressionLevel);
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(1024);
        DeflaterOutputStream deflateroutputstream = new DeflaterOutputStream((OutputStream)bytearrayoutputstream, deflater);
        if (this.bytesPerPixel == 1) {
            this.writePalette((IndexColorModel)this.image.getColorModel());
        }
        try {
            while (i > 0) {
                int[] ai;
                byte[] abyte2;
                int k = Math.min(Short.MAX_VALUE / (this.width * (this.bytesPerPixel + 1)), i);
                byte[] abyte0 = new byte[this.width * k * this.bytesPerPixel + k];
                if (this.filter == 1) {
                    this.leftBytes = new byte[16];
                }
                if (this.filter == 2) {
                    this.priorRow = new byte[this.width * this.bytesPerPixel];
                }
                if (this.tType == 0) {
                    abyte2 = (byte[])this.wRaster.getDataElements(0, j, this.width, k, null);
                    ai = null;
                } else {
                    ai = (int[])this.wRaster.getDataElements(0, j, this.width, k, null);
                    abyte2 = null;
                }
                int l = 0;
                int j1 = 0;
                int i1 = 1;
                for (int l1 = 0; l1 < this.width * k; ++l1) {
                    if (l1 % this.width == 0) {
                        abyte0[l++] = (byte)this.filter;
                        i1 = l;
                    }
                    if (this.bytesPerPixel == 1) {
                        abyte0[l++] = abyte2[j1++];
                    } else if (this.tType == 0) {
                        abyte0[l++] = abyte2[j1++];
                        abyte0[l++] = abyte2[j1++];
                        abyte0[l++] = abyte2[j1++];
                        if (this.encodeAlpha) {
                            abyte0[l++] = abyte2[j1++];
                        } else {
                            ++j1;
                        }
                    } else {
                        abyte0[l++] = (byte)(ai[j1] >> 16 & 0xFF);
                        abyte0[l++] = (byte)(ai[j1] >> 8 & 0xFF);
                        abyte0[l++] = (byte)(ai[j1] & 0xFF);
                        if (this.encodeAlpha) {
                            abyte0[l++] = (byte)(ai[j1] >> 24 & 0xFF);
                        }
                        ++j1;
                    }
                    if (l1 % this.width != this.width - 1 || this.filter == 0) continue;
                    if (this.filter == 1) {
                        this.filterSub(abyte0, i1, this.width);
                    }
                    if (this.filter != 2) continue;
                    this.filterUp(abyte0, i1, this.width);
                }
                deflateroutputstream.write(abyte0, 0, l);
                j += k;
                i -= k;
            }
            deflateroutputstream.close();
            byte[] abyte1 = bytearrayoutputstream.toByteArray();
            int k1 = abyte1.length;
            this.crc.reset();
            this.bytePos = this.writeInt4(k1, this.bytePos);
            this.bytePos = this.writeString("IDAT", this.bytePos);
            this.crc.update("IDAT".getBytes());
            this.bytePos = this.writeBytes(abyte1, k1, this.bytePos);
            this.crc.update(abyte1, 0, k1);
            this.crcValue = this.crc.getValue();
            this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
            deflater.finish();
            return true;
        }
        catch (IOException ioexception) {
            System.err.println(ioexception.toString());
            return false;
        }
    }

    protected void writePalette(IndexColorModel indexcolormodel) {
        byte[] abyte0 = new byte[256];
        byte[] abyte1 = new byte[256];
        byte[] abyte2 = new byte[256];
        byte[] abyte3 = new byte[768];
        indexcolormodel.getReds(abyte0);
        indexcolormodel.getGreens(abyte1);
        indexcolormodel.getBlues(abyte2);
        for (int i = 0; i < 256; ++i) {
            abyte3[i * 3] = abyte0[i];
            abyte3[i * 3 + 1] = abyte1[i];
            abyte3[i * 3 + 2] = abyte2[i];
        }
        this.bytePos = this.writeInt4(768, this.bytePos);
        this.bytePos = this.writeString("PLTE", this.bytePos);
        this.crc.reset();
        this.crc.update("PLTE".getBytes());
        this.bytePos = this.writeBytes(abyte3, this.bytePos);
        this.crc.update(abyte3);
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }

    protected void filterSub(byte[] abyte0, int i, int j) {
        int l = this.bytesPerPixel;
        int i1 = i + l;
        int j1 = j * this.bytesPerPixel;
        int k1 = l;
        int l1 = 0;
        for (int k = i1; k < i + j1; ++k) {
            this.leftBytes[k1] = abyte0[k];
            abyte0[k] = (byte)((abyte0[k] - this.leftBytes[l1]) % 256);
            k1 = (k1 + 1) % 15;
            l1 = (l1 + 1) % 15;
        }
    }

    protected void filterUp(byte[] abyte0, int i, int j) {
        int l = j * this.bytesPerPixel;
        for (int k = 0; k < l; ++k) {
            byte byte0 = abyte0[i + k];
            abyte0[i + k] = (byte)((abyte0[i + k] - this.priorRow[k]) % 256);
            this.priorRow[k] = byte0;
        }
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public boolean getEncodeAlpha() {
        return this.encodeAlpha;
    }

    public int getFilter() {
        return this.filter;
    }

    protected byte[] resizeByteArray(byte[] abyte0, int i) {
        byte[] abyte1 = new byte[i];
        int j = abyte0.length;
        System.arraycopy(abyte0, 0, abyte1, 0, Math.min(j, i));
        return abyte1;
    }

    public void setCompressionLevel(int i) {
        if (i >= 0 && i <= 9) {
            this.compressionLevel = i;
        }
    }

    public void setEncodeAlpha(boolean flag) {
        this.encodeAlpha = flag;
    }

    public void setFilter(int i) {
        this.filter = 0;
        if (i <= 2) {
            this.filter = i;
        }
    }

    protected int writeByte(int i, int j) {
        byte[] abyte0 = new byte[]{(byte)i};
        return this.writeBytes(abyte0, j);
    }

    protected int writeBytes(byte[] abyte0, int i) {
        this.maxPos = Math.max(this.maxPos, i + abyte0.length);
        if (abyte0.length + i > this.pngBytes.length) {
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.pngBytes.length + Math.max(1000, abyte0.length));
        }
        System.arraycopy(abyte0, 0, this.pngBytes, i, abyte0.length);
        return i + abyte0.length;
    }

    protected int writeBytes(byte[] abyte0, int i, int j) {
        this.maxPos = Math.max(this.maxPos, j + i);
        if (i + j > this.pngBytes.length) {
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.pngBytes.length + Math.max(1000, i));
        }
        System.arraycopy(abyte0, 0, this.pngBytes, j, i);
        return j + i;
    }

    protected void writeEnd() {
        this.bytePos = this.writeInt4(0, this.bytePos);
        this.bytePos = this.writeString("IEND", this.bytePos);
        this.crc.reset();
        this.crc.update("IEND".getBytes());
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }

    protected int writeInt2(int i, int j) {
        byte[] abyte0 = new byte[]{(byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return this.writeBytes(abyte0, j);
    }

    protected int writeInt4(int i, int j) {
        byte[] abyte0 = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return this.writeBytes(abyte0, j);
    }

    protected int writeString(String s, int i) {
        return this.writeBytes(s.getBytes(), i);
    }
}

