/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.floppy;

import java.util.Arrays;
import java.util.HashSet;
import jemu.core.Util;
import jemu.core.device.Device;
import jemu.core.device.floppy.Drive;
import jemu.core.samples.Samples;
import jemu.settings.Settings;
import jemu.system.cpc.CPC;
import jemu.ui.Desktop;
import jemu.ui.Display;
import jemu.ui.StatusPanel;
import jemu.ui.Switches;

public class UPD765A
extends Device {
    public static boolean error = false;
    public static boolean fastdisk = false;
    public boolean showSys = false;
    protected int counter;
    boolean parados = false;
    int[] enduser = null;
    boolean systemdisk = false;
    private static final boolean DEBUG = false;
    private static final boolean DEBUGINFO = false;
    private static final boolean DEBUG_SENSE = false;
    private static final boolean DEBUG_GAP = false;
    private static final boolean DEBUG_BUFFER = false;
    private static final boolean DEBUG_DATA = false;
    private static final boolean DEBUG_READ_ID = false;
    protected boolean readtrack = false;
    private static final int[] SECTOR_SIZES = new int[]{128, 256, 512, 1024, 2048, 4096, 6144};
    protected static int[] sectSizes = new int[90];
    public int[] formatid = new int[]{0, 0, 0, 0};
    protected int actualDrive = 0;
    protected static final int READ_TIME_FM = 256;
    protected static final int READ_TIME_MFM = 128;
    protected static final int POLL_TIME = 8192;
    protected static final int POLL = 0;
    protected static final int SEEK = 1;
    protected static final int READ_ID = 2;
    protected static final int MATCH_SECTOR = 3;
    protected static final int READ = 4;
    protected static final int WRITE = 5;
    protected static final int FORMAT = 6;
    protected static final int SCAN = 8;
    protected static final int[] CMD_PARAMS = new int[]{0, 0, 8, 2, 1, 8, 8, 1, 0, 8, 1, 0, 8, 5, 0, 2, 0, 8, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 8, 0, 0};
    protected static final int[] CMD_PARAMS_SEEK = new int[]{0, 0, 0, 2, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected static final int D0_BUSY = 1;
    protected static final int D1_BUSY = 2;
    protected static final int D2_BUSY = 4;
    protected static final int D3_BUSY = 8;
    protected static final int COMMAND_BUSY = 16;
    protected static final int EXEC_MODE = 32;
    protected static final int DATA_IN_OUT = 64;
    protected static final int REQ_MASTER = 128;
    protected static final int SEEK_MASK = 15;
    protected static final int ST0_NORMAL = 0;
    protected static final int ST0_ABNORMAL = 64;
    protected static final int ST0_INVALID = 128;
    protected static final int ST0_READY_CHANGE = 192;
    protected static final int ST0_NOT_READY = 8;
    protected static final int ST0_HEAD_ADDR = 4;
    protected static final int ST0_EQUIP_CHECK = 16;
    protected static final int ST0_SEEK_END = 32;
    protected static final int ST1_MISSING_ADDR = 1;
    protected static final int ST1_NOT_WRITABLE = 2;
    protected static final int ST1_NO_DATA = 4;
    protected static final int ST1_OVERRUN = 16;
    protected static final int ST1_DATA_ERROR = 32;
    protected static final int ST1_END_CYL = 128;
    protected static final int ST2_MISSING_ADDR = 1;
    protected static final int ST2_BAD_CYLINDER = 2;
    protected static final int ST2_SCAN_NOT_SAT = 4;
    protected static final int ST2_SCAN_EQU_HIT = 8;
    protected static final int ST2_WRONG_CYL = 16;
    protected static final int ST2_DATA_ERROR = 32;
    protected static final int ST2_CONTROL_MARK = 64;
    protected static final int ST3_HEAD_ADDR = 4;
    protected static final int ST3_TWO_SIDE = 8;
    protected static final int ST3_TRACK_0 = 16;
    protected static final int ST3_READY = 32;
    protected static final int ST3_WRITE_PROT = 64;
    protected static final int ST3_FAULT = 128;
    protected int command;
    protected int action;
    protected static int[] params = new int[8];
    protected int pcount = 0;
    protected int pindex = 0;
    protected int[] result = new int[7];
    protected int rindex = 0;
    protected int rcount = 0;
    protected Drive activeDrive;
    protected int c;
    protected int h;
    protected int r;
    protected int n;
    protected int offset;
    protected int size;
    protected byte[] buffer;
    protected int count;
    protected int next;
    protected int status;
    protected int st1;
    protected int st2;
    protected int st3;
    protected byte data;
    protected int sectorcount;
    protected int cycleRate;
    protected int countPoll;
    protected int countStep;
    protected int countFM;
    protected int countMFM;
    protected Drive[] drives = new Drive[4];
    protected int[] pcn = new int[4];
    protected int[] ncn = new int[4];
    protected int[] dir = new int[4];
    protected int[] max = new int[4];
    protected int[] st0 = new int[4];
    protected boolean[] ready = new boolean[4];
    protected Device interruptDevice;
    protected int interruptMask;
    private boolean driveChanged;
    public static int nooftracks;
    public static String statusinfo;
    int oldstat;
    protected boolean fdcenabled = true;
    boolean DEBUGPORT = false;
    public static String commands;
    int[] oldid;
    protected boolean overrun = false;
    boolean ignoreoverrun = false;
    boolean skip;
    protected final int LOW_OR_EQUAL = 0;
    protected final int HIGH_OR_EQUAL = 1;
    protected final int EQUAL = 2;
    protected int SCAN_COMMAND = 0;
    protected byte[] Dfdd;
    protected byte[] Dcpu;
    int offset2 = 0;
    int[] sector = new int[4];
    int sectorsize = 1;
    boolean stop = false;
    int[] lastid;
    int stat = 0;
    int drv;
    int cyl;
    int sec;
    int nrw;
    int irw;
    int displaydelay;

    public static int getSectorSize(int commandSize) {
        int ret;
        UPD765A.sectSizes[UPD765A.params[1]] = ret = SECTOR_SIZES[Math.min(commandSize, 6)];
        return ret;
    }

    public static int getCommandSize(int realSize) {
        for (int i = 0; i < SECTOR_SIZES.length; ++i) {
            if (SECTOR_SIZES[i] != realSize) continue;
            return i;
        }
        return 2;
    }

    public UPD765A(int clocksPerCycle) {
        super("NEC uPD765AC-2 Floppy Controller");
        switch (clocksPerCycle) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                this.cycleRate = clocksPerCycle;
                break;
            }
            default: {
                this.cycleRate = 4;
            }
        }
        this.countPoll = 8192 / this.cycleRate;
        this.countFM = 256 / this.cycleRate;
        this.countMFM = 128 / this.cycleRate;
        this.reset();
    }

    public void getNoOfTracks() {
        try {
            int drive = this.getDrive();
            nooftracks = this.drives[drive].getTracks();
        }
        catch (Exception e) {
            nooftracks = 40;
        }
    }

    public void setInterruptDevice(Device device, int mask) {
        this.interruptDevice = device;
        this.interruptMask = mask;
    }

    public void setDrive(int index, Drive drive) {
        this.drives[index] = drive;
        this.driveChanged = true;
    }

    public Drive getDrive(int index) {
        return this.drives[index];
    }

    public void setStatusInfo() {
        if (this.status != this.oldstat) {
            this.oldstat = this.status;
            statusinfo = "???";
            statusinfo = (this.status & 0x40) != 0 ? "FDC to CPU" : "CPU to FDC";
            Desktop.statinf1.setText(statusinfo);
            if ((this.status & 0x80) != 0) {
                statusinfo = "FDC ready for data";
            }
            if ((this.status & 0x20) != 0) {
                statusinfo = "Command execution";
            }
            if ((this.status & 0x10) != 0) {
                statusinfo = "FDC is busy";
            }
            if ((this.status & 8) != 0) {
                statusinfo = "DF3 is seeking";
            }
            if ((this.status & 4) != 0) {
                statusinfo = "DF2 is seeking";
            }
            if ((this.status & 2) != 0) {
                statusinfo = "DF1 is seeking";
            }
            if ((this.status & 1) != 0) {
                statusinfo = "DF0 is seeking";
            }
            Desktop.statinf.setText(statusinfo);
            Desktop.cmd.setText(commands);
        }
    }

    public final int readPort(int port) {
        if (!this.fdcenabled) {
            return 255;
        }
        if ((port & 1) == 0) {
            return this.status;
        }
        if ((this.status & 0xA0) == 128 && this.rcount > 0) {
            this.data = (byte)this.result[this.rindex++];
            if (--this.rcount == 0) {
                this.status &= 0xFFFFFFAF;
            }
        } else if (this.action == 4 && (this.status & 0x80) != 0) {
            this.status &= 0xFFFFFF7F;
        }
        this.overrun = false;
        return this.data;
    }

    public final void writePort(int port, int value) {
        if (!this.fdcenabled) {
            return;
        }
        if (CPC.playvideo) {
            return;
        }
        if (port < 64000 || port > 64511) {
            if (this.DEBUGPORT) {
                System.err.println("Possibly bad port write on port " + Util.hex((short)port) + " with data:" + Util.hex((byte)value));
            }
            return;
        }
        if ((port & 1) != 0) {
            this.data = (byte)value;
            this.overrun = false;
            if ((this.status & 0xC0) == 128) {
                if ((this.status & 0x20) != 0) {
                    this.status &= 0xFFFFFF7F;
                } else if ((this.status & 0x10) == 0) {
                    this.command = value;
                    this.status |= 0x10;
                    this.pindex = 0;
                    this.pcount = CMD_PARAMS[value &= 0x1F];
                    if (this.pcount == 0) {
                        this.status |= 0x40;
                        this.rindex = 0;
                        this.result[0] = 128;
                        this.rcount = 1;
                        if (value == 8) {
                            for (int drive = 0; drive < 4; ++drive) {
                                if (this.st0[drive] == 128) continue;
                                this.result[0] = this.st0[drive];
                                this.st0[drive] = 128;
                                this.result[1] = this.pcn[drive];
                                this.status &= ~(1 << drive);
                                this.rcount = 2;
                                break;
                            }
                        }
                    }
                } else {
                    UPD765A.params[this.pindex++] = value;
                    if (--this.pcount == 0) {
                        if (this.command == 102) {
                            this.command = 102;
                        }
                        String msg = "FDC Command " + Util.hex((byte)this.command) + ": " + Util.hex((byte)params[1]) + "/" + Util.hex((byte)params[2]) + "/" + Util.hex((byte)params[3]) + "/" + Util.hex((byte)params[4]) + " ";
                        switch (this.command & 0x1F) {
                            case 2: {
                                commands = "Read Track";
                                this.readTrack();
                                break;
                            }
                            case 3: {
                                commands = "Specify";
                                this.specify();
                                break;
                            }
                            case 4: {
                                commands = "Sense Drive";
                                this.senseDrive();
                                break;
                            }
                            case 5: {
                                commands = "Write Sector";
                                this.writeSector();
                                break;
                            }
                            case 6: {
                                commands = "Read Sector";
                                this.readSector();
                                break;
                            }
                            case 7: {
                                commands = "Re-Calibrate";
                                this.seek(0, 77);
                                break;
                            }
                            case 8: {
                                commands = "Get status register 0";
                                System.out.println(msg + " (get status register 0)");
                                break;
                            }
                            case 9: {
                                commands = "Write Del.";
                                this.writeSector();
                                break;
                            }
                            case 10: {
                                commands = "Read ID";
                                this.readID();
                                break;
                            }
                            case 12: {
                                commands = "Read Del.";
                                this.readSector();
                                break;
                            }
                            case 13: {
                                commands = "Format Track";
                                this.sectorcount = 0;
                                this.formatTrack();
                                break;
                            }
                            case 15: {
                                commands = "Seek Track";
                                this.seek(params[1], -1);
                                break;
                            }
                            case 17: {
                                commands = "Scan Equal";
                                this.scan(2);
                                break;
                            }
                            case 25: {
                                commands = "Scan L.o.E.";
                                this.scan(0);
                                break;
                            }
                            case 29: {
                                commands = "Scan H.o.E.";
                                this.scan(1);
                                break;
                            }
                            default: {
                                throw new RuntimeException("Invalid command: " + Util.hex((byte)this.command));
                            }
                        }
                        Desktop.cmd.setText(commands);
                    }
                }
            }
        }
    }

    public final void reset() {
        this.fdcenabled = Settings.getBoolean("fdc_enabled", true);
        Samples.SEEK.stop();
        Samples.SEEKBACK.stop();
        Samples.SEEKWINCPC.stop();
        Samples.SEEKBACKWINCPC.stop();
        this.count = 0;
        this.pcount = 0;
        this.pindex = 0;
        this.status = 128;
        this.countStep = 128000 / this.cycleRate;
        this.action = 0;
        this.next = this.countPoll;
        this.stop = false;
        this.command = 0;
    }

    public final void resetb() {
        this.count = 0;
        this.pcount = 0;
        this.pindex = 0;
        this.status = 128;
        this.action = 0;
    }

    public final void initialise() {
        this.count = 0;
        this.pcount = 0;
        this.pindex = 0;
        this.action = 0;
    }

    public final void specify() {
        this.countStep = (16 - (params[0] >> 4)) * 8000 / this.cycleRate;
        this.status &= 0xFFFFFFAF;
    }

    public final void senseDrive() {
        int select = params[0] & 7;
        int drv = select & 3;
        this.activeDrive = this.drives[drv];
        if (this.activeDrive != null) {
            if (this.ready[drv] && !this.driveChanged) {
                select |= 0x20;
            }
            if (this.activeDrive.getCylinder() == 0) {
                select |= 0x10;
            }
            if (this.activeDrive.getSides() == 2) {
                select |= 8;
            }
            if (this.activeDrive.isWriteProtected()) {
                select |= 0x40;
            }
        }
        this.driveChanged = false;
        this.rindex = 0;
        this.result[0] = select;
        this.rcount = 1;
        this.status |= 0x40;
    }

    public void resetDrive() {
        UPD765A.params[0] = 0;
    }

    public int getDrive() {
        Switches.drive = this.actualDrive = params[0] & 3;
        return this.actualDrive;
    }

    public final void seek(int cyl, int steps) {
        if (Switches.FloppySound && Switches.audioenabler == 1) {
            if (CPC.WinCPC) {
                Samples.MOTORWINCPC.loop2();
            } else {
                Samples.MOTOR.loop2();
            }
        }
        this.max[this.actualDrive] = steps;
        this.ncn[this.actualDrive] = cyl;
        this.status &= 0xFFFFFFEF;
        if (this.pcn[this.actualDrive] == cyl) {
            this.seekEnd(this.actualDrive, 0);
        } else {
            this.status |= 1 << this.actualDrive;
            if (this.pcn[this.actualDrive] < cyl) {
                this.dir[this.actualDrive] = 1;
                if (Switches.FloppySound && Switches.audioenabler == 1) {
                    if (CPC.WinCPC) {
                        Samples.TRACKWINCPC.play();
                    } else {
                        Samples.TRACK.play();
                    }
                }
            } else if (this.pcn[this.actualDrive] > cyl) {
                if (Switches.FloppySound && Switches.audioenabler == 1) {
                    if (CPC.WinCPC) {
                        Samples.TRACKBACKWINCPC.play();
                    } else {
                        Samples.TRACKBACK.play();
                    }
                }
                this.dir[this.actualDrive] = -1;
            }
            if (this.action != 1) {
                this.action = 1;
                this.next = this.count + this.countStep;
            }
        }
    }

    public final void seekStep() {
        for (int drive = 0; drive < 4; ++drive) {
            if (this.pcn[drive] == this.ncn[drive]) continue;
            int step = this.dir[drive];
            int n = drive;
            this.pcn[n] = this.pcn[n] + step;
            if (this.drives[drive] != null && this.drives[drive].step(step)) {
                this.pcn[drive] = 0;
            }
            if (this.pcn[drive] == this.ncn[drive]) {
                this.seekEnd(drive, 0);
                continue;
            }
            int n2 = drive;
            this.max[n2] = this.max[n2] - 1;
            if (this.max[n2] == 0) {
                this.ncn[drive] = this.pcn[drive];
                this.seekEnd(drive, 80);
                continue;
            }
            this.next = this.count + this.countStep;
            this.getNoOfTracks();
            Desktop.setFloppyHead(this.pcn[drive]);
            if (this.activeDrive != null) {
                this.activeDrive.setActive(false);
            }
            if (!Switches.FloppySound || Switches.audioenabler != 1) continue;
            if (step > 0) {
                if (CPC.WinCPC) {
                    Samples.SEEKWINCPC.loop2();
                    continue;
                }
                Samples.SEEK.loop2();
                continue;
            }
            if (CPC.WinCPC) {
                Samples.SEEKBACKWINCPC.loop2();
                continue;
            }
            Samples.SEEKBACK.loop2();
        }
    }

    protected final void seekEnd(int drive, int status) {
        this.st0[drive] = status | 0x20 | drive;
        this.dir[drive] = 0;
        Samples.SEEK.stop();
        Samples.SEEKBACK.stop();
        Samples.SEEKWINCPC.stop();
        Samples.SEEKBACKWINCPC.stop();
        if ((this.dir[0] | this.dir[1] | this.dir[2] | this.dir[3]) == 0) {
            this.action = 0;
            this.next = this.count + this.countPoll;
            if (this.activeDrive != null) {
                this.activeDrive.setActive(true);
            }
        }
    }

    public final void poll() {
        Switches.write = false;
        for (int drive = 0; drive < 4; ++drive) {
            boolean rdy;
            boolean bl = rdy = this.drives[drive] != null && this.drives[drive].isReady();
            if (rdy == this.ready[drive]) continue;
            this.ready[drive] = rdy;
            this.st0[drive] = 0xC0 | (rdy ? 0 : 8) | drive;
        }
    }

    public final boolean setupResult() {
        int select = params[0] & 7;
        this.driveChanged = false;
        this.activeDrive = this.drives[select & 3];
        this.rindex = 0;
        this.result[0] = select | 0x40;
        this.result[1] = 5;
        this.rcount = 2;
        if (this.activeDrive != null && this.activeDrive.isReady()) {
            this.activeDrive.setHead(select >> 2);
            this.activeDrive.setActive(true);
            return true;
        }
        this.result[0] = this.result[0] | 8;
        this.status |= 0x40;
        return false;
    }

    public final void readID() {
        Switches.write = false;
        if (this.setupResult()) {
            this.action = 2;
            this.status ^= 0xC0;
            this.next = !fastdisk ? this.count + 77100 / this.cycleRate : this.count + 1200 / this.cycleRate;
        }
    }

    public final void getNextID() {
        int[] id = this.activeDrive.getNextSectorID();
        this.oldid = id;
        if (id != null) {
            this.result[0] = this.result[0] & 0xFFFFFFBF;
            this.result[2] = 0;
            this.result[1] = 0;
            this.result[3] = id[0];
            this.result[4] = id[1];
            this.result[5] = id[2];
            this.result[6] = id[3];
            this.next = this.count + this.countPoll;
        } else {
            this.result[0] = 64;
            this.result[1] = 1;
            this.result[3] = 0;
            this.result[4] = 0;
            this.result[5] = 1;
            this.result[6] = 2;
            this.next = this.count + this.countPoll;
        }
        this.rcount = 7;
        this.status |= 0x80;
        this.action = 0;
    }

    protected final void readSectorByte() {
        if (this.offset == this.buffer.length || this.overrun && !this.ignoreoverrun) {
            if (this.offset == this.buffer.length) {
                this.ignoreoverrun = false;
            }
            this.endBuffer(4);
        } else {
            this.activeDrive.notifyReadSectorByte(this.offset == 0, params[1], params[2], params[3], params[4]);
            this.overrun = true;
            this.data = this.buffer[this.offset++];
            this.next = this.count + this.countMFM;
            this.status |= 0x80;
        }
    }

    protected final void readSector() {
        if (this.setupResult()) {
            this.getNextSector(4);
        }
    }

    protected final void readTrack() {
        if (this.setupResult()) {
            this.readtrack = true;
            this.activeDrive.resetSector();
            this.getNextSector(4);
        }
    }

    protected final void formatTrack() {
        if (this.setupResult()) {
            if (this.activeDrive == null) {
                this.senseDrive();
            }
            this.activeDrive.removeAllSectorsFromTrack();
            this.activeDrive.resetSector();
            this.getNextFormatID();
        }
    }

    protected void addSector() {
    }

    protected final void getNextFormatID() {
        this.action = 6;
        this.offset = 0;
        this.status = this.status & 0xFFFFFFBF | 0x80 | 0x20;
        Switches.write = true;
        this.next = fastdisk ? this.count + 1200 / this.cycleRate : this.count + 100000 / this.cycleRate;
        this.data = (byte)-1;
    }

    protected void scan(int scancommand) {
        if (this.setupResult()) {
            try {
                this.SCAN_COMMAND = scancommand;
                this.action = 8;
                this.Dfdd = this.activeDrive.getSector(params[1], params[2], params[3], params[4]);
                this.Dcpu = new byte[this.Dfdd.length];
                this.next = !fastdisk ? this.count + 77100 / this.cycleRate : this.count + 1200 / this.cycleRate;
                this.offset2 = 0;
                this.status = this.status & 0xFFFFFFBF | 0x80 | 0x20;
                Switches.write = true;
                this.data = (byte)-1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected final void writeScanByte() {
        if (this.data == -1) {
            // empty if block
        }
        if (this.Dcpu != null) {
            this.Dcpu[this.offset2++] = this.data;
        }
        this.data = (byte)-1;
        if (this.Dcpu != null && this.offset2 == this.Dcpu.length) {
            this.endScanBuffer(this.SCAN_COMMAND);
        } else {
            this.next = this.count + this.countMFM;
            this.status |= 0x80;
        }
    }

    protected final void endScanBuffer(int direction) {
        int scanstatus = 4;
        block0 : switch (direction) {
            case 1: {
                for (int i = 0; i < this.Dfdd.length; ++i) {
                    if (this.Dfdd[i] == this.Dcpu[i]) {
                        scanstatus |= 8;
                    }
                    if (this.Dfdd[i] < this.Dcpu[i]) continue;
                    scanstatus &= 0xFFFFFFFB;
                }
                break;
            }
            case 0: {
                for (int i = 0; i < this.Dfdd.length; ++i) {
                    if (this.Dfdd[i] == this.Dcpu[i]) {
                        scanstatus |= 8;
                        break block0;
                    }
                    if (this.Dfdd[i] > this.Dcpu[i]) continue;
                    scanstatus &= 0xFFFFFFFB;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.Dfdd.length; ++i) {
                    if (this.Dfdd[i] != this.Dcpu[i]) continue;
                    scanstatus |= 8;
                    scanstatus &= 0xFFFFFFFB;
                }
                break;
            }
        }
        if (params[3] == params[5] || (scanstatus & 4) == 0) {
            this.status &= 0xFFFFFFDF;
            this.status |= 0xC0;
            this.result[0] = this.result[0] & 0xFFFFFFBF;
            this.result[1] = 0;
            this.result[2] = scanstatus;
            this.result[3] = params[1];
            this.result[4] = params[2];
            this.result[5] = 1;
            this.result[6] = params[4];
            this.rcount = 7;
            this.action = 0;
            this.next = this.count + this.countPoll;
            this.activeDrive.setActive(false);
        } else {
            UPD765A.params[3] = params[3] + 1 & 0xFF;
            this.sector[this.actualDrive] = params[3];
            this.getNextSector(4);
        }
    }

    protected final void endFormatID() {
        this.activeDrive.addSectorToTrack(this.formatid[0], this.formatid[1], this.formatid[2], this.formatid[3], params[4]);
        this.sectorcount = this.sectorcount + 1 & 0xFF;
        if (this.sectorcount == params[2]) {
            this.status &= 0xFFFFFFDF;
            this.status |= 0xC0;
            this.result[0] = this.result[0] & 0xFFFFFFBF;
            this.result[2] = 0;
            this.result[1] = 0;
            this.result[3] = params[1];
            this.result[4] = params[2];
            this.result[5] = 1;
            this.result[6] = params[4];
            this.rcount = 7;
            this.action = 0;
            this.next = this.count + this.countPoll;
            this.activeDrive.setActive(false);
        } else {
            this.getNextFormatID();
        }
        this.getNoOfTracks();
        Desktop.setFloppyHead(this.activeDrive.getCylinder());
        try {
            int[] nArray = this.activeDrive.getNextSectorID();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final void getNextSector(int direction) {
        this.buffer = this.activeDrive.getSector(params[1], params[2], params[3], params[4]);
        this.sector[this.actualDrive] = params[3];
        if (this.readtrack) {
            if (this.buffer != null) {
                this.buffer = null;
            }
            int ret = 0;
            while (this.buffer == null && ret++ <= 10) {
                this.ignoreoverrun = true;
                this.endBuffer(direction);
                this.buffer = this.activeDrive.getSector(params[1], params[2], params[3], params[4]);
                this.sector[this.actualDrive] = params[3];
            }
        }
        this.readtrack = false;
        if (direction == 4) {
            if ((this.command & 0x1F) == 6) {
                if ((this.command & 0x20) != 0 && this.isDeletedData()) {
                    this.endBuffer(direction);
                    return;
                }
            } else if ((this.command & 0x1F) == 12 && (this.command & 0x20) != 0 && !this.isDeletedData()) {
                this.endBuffer(direction);
                return;
            }
        }
        if (direction == 5) {
            if ((this.command & 0x1F) == 5) {
                this.activeDrive.setST2ForSector(params[1], params[2], params[3], params[4], 0);
                this.sector[this.actualDrive] = params[3];
            } else if ((this.command & 0x1F) == 9) {
                this.activeDrive.setST2ForSector(params[1], params[2], params[3], params[4], 64);
                this.sector[this.actualDrive] = params[3];
            }
        }
        if (this.buffer != null) {
            this.getNoOfTracks();
            this.offset = 0;
            this.action = direction;
            this.status = direction == 4 ? this.status & 0xFFFFFF7F | 0x40 | 0x20 : this.status & 0xFFFFFFBF | 0x80 | 0x20;
            this.next = this.count + this.getTiming();
            this.data = (byte)-1;
        } else {
            this.endBuffer(direction);
        }
    }

    public int getSectorSize() {
        try {
            this.sectorsize = this.buffer.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.sectorsize;
    }

    public int getTiming() {
        int[] sectorID;
        int i;
        if (fastdisk) {
            return this.countPoll;
        }
        int numbytes = 0;
        for (i = 0; i < this.activeDrive.getSectorCount(); ++i) {
            try {
                sectorID = this.activeDrive.getNextSectorID();
                if (sectorID[2] != params[3]) continue;
            }
            catch (Exception e) {}
            break;
        }
        for (i = 0; i < this.activeDrive.getSectorCount(); ++i) {
            numbytes += this.getGAP() + 2 + 60;
            try {
                sectorID = this.activeDrive.getNextSectorID();
                if (sectorID[2] == (params[3] + 1 & 0xFF)) break;
                numbytes += SECTOR_SIZES[Math.min(sectorID[3], 6)];
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        int numCycles = numbytes * this.countMFM / 3;
        return numCycles;
    }

    public int getGAP() {
        int secs = this.activeDrive.getSectorCount();
        int GAPLength = (6100 - this.getSectorSize() * secs) / secs;
        if ((GAPLength &= 0x7F) < 1) {
            GAPLength = 1;
        }
        if (GAPLength > 90) {
            GAPLength = 90;
        }
        return GAPLength;
    }

    protected boolean isDeletedData() {
        return (this.activeDrive.getST2ForSector(params[1], params[2], params[3], params[4]) & 0x40) != 0;
    }

    protected final void endBuffer(int direction) {
        int[] id;
        try {
            id = this.activeDrive.getReadID();
            this.lastid = id;
        }
        catch (Exception e) {
            id = this.lastid;
        }
        if (this.buffer == null) {
            try {
                this.status &= 0xFFFFFFDF;
                this.status |= 0xC0;
                this.result[0] = this.result[0] | 0x40;
                this.result[1] = 4;
                this.result[2] = 0;
                this.result[3] = UPD765A.params[1] = id[0];
                this.result[4] = UPD765A.params[2] = id[1];
                this.result[5] = id[2];
                this.result[6] = UPD765A.params[4] = id[3];
                this.rcount = 7;
                this.action = 0;
                this.next = this.count + this.getTiming();
                this.activeDrive.setActive(false);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.stop = false;
        if (direction == 4) {
            if ((this.command & 0x1F) == 6) {
                if (this.isDeletedData()) {
                    this.stop = true;
                }
            } else if ((this.command & 0x1F) == 12 && !this.isDeletedData()) {
                this.stop = true;
            }
        }
        if ((this.activeDrive.getST2ForSector(params[1], params[2], params[3], params[4]) & 0x20) != 0) {
            this.sector[this.actualDrive] = params[3];
            this.stop = true;
        }
        if ((this.activeDrive.getST1ForSector(params[1], params[2], params[3], params[4]) & 0x20) != 0) {
            this.sector[this.actualDrive] = params[3];
            this.stop = true;
        }
        if (params[3] == params[5] || this.stop || this.overrun) {
            this.sector[this.actualDrive] = params[3];
            this.status &= 0xFFFFFFDF;
            this.status |= 0xC0;
            if (this.stop) {
                this.result[0] = this.result[0] & 0xFFFFFFBF;
                this.result[2] = 0;
                this.result[1] = 0;
            } else {
                this.result[0] = this.result[0] & 0x40;
                this.result[1] = 128;
                this.result[2] = 0;
            }
            this.result[1] = this.result[1] | this.activeDrive.getST1ForSector(params[1], params[2], params[3], params[4]) & 0x20;
            this.result[2] = this.result[2] | this.activeDrive.getST2ForSector(params[1], params[2], params[3], params[4]) & 0x20;
            this.sector[this.actualDrive] = params[3];
            if (this.overrun) {
                System.out.println("FDC overrun");
                this.result[1] = this.result[1] | 0x10;
            }
            if (direction == 4) {
                if ((this.command & 0x1F) == 6) {
                    if ((this.command & 0x20) == 0 && this.isDeletedData()) {
                        this.result[2] = this.result[2] | 0x40;
                    }
                } else if ((this.command & 0x1F) == 12 && (this.command & 0x20) == 0 && !this.isDeletedData()) {
                    this.result[2] = this.result[2] | 0x40;
                }
            }
            try {
                this.result[3] = UPD765A.params[1] = id[0];
                this.result[4] = UPD765A.params[2] = id[1];
                this.result[5] = id[2];
                this.result[6] = UPD765A.params[4] = id[3];
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.rcount = 7;
            this.action = 0;
            this.next = this.count + this.getTiming();
            this.activeDrive.setActive(false);
        } else {
            UPD765A.params[3] = params[3] + 1 & 0xFF;
            this.sector[this.actualDrive] = params[3];
            this.getNextSector(direction);
        }
    }

    protected final void writeSector() {
        if (this.setupResult()) {
            this.getNextSector(5);
        }
    }

    protected final void writeDeletedData() {
        if (this.setupResult()) {
            this.getNextSector(5);
        }
    }

    protected final void writeSectorByte() {
        if (this.data == -1) {
            this.overrun = true;
        }
        this.buffer[this.offset++] = this.data;
        this.activeDrive.notifyWriteSectorByte(this.data, params[1], params[2], params[3], params[4]);
        this.data = (byte)-1;
        if (this.offset == this.buffer.length) {
            this.endBuffer(5);
            this.saveCheck();
        } else {
            this.next = this.count + this.countMFM;
            this.status |= 0x80;
        }
    }

    protected final void writeFormatByte() {
        this.formatid[this.offset++] = this.data & 0xFF;
        this.data = (byte)-1;
        if (this.offset == 4) {
            this.endFormatID();
            this.saveCheck();
        } else {
            this.next = this.count + this.countMFM;
            this.status |= 0x80;
        }
    }

    public final void saveCheck() {
        switch (this.actualDrive) {
            case 0: {
                CPC.df0mod = true;
                break;
            }
            case 1: {
                CPC.df1mod = true;
                break;
            }
            case 2: {
                CPC.df2mod = true;
                break;
            }
            case 3: {
                CPC.df3mod = true;
            }
        }
        if (Switches.autosave && !error) {
            CPC.savetimer = 1;
        }
    }

    public final void cycle() {
        if (CPC.playvideo) {
            return;
        }
        ++this.displaydelay;
        if (this.displaydelay > 1000) {
            this.displaydelay = 0;
            if (this.nrw != this.irw || this.actualDrive != this.drv || this.cyl != this.pcn[this.actualDrive] || this.sec != this.sector[this.actualDrive]) {
                this.irw = this.nrw;
                this.drv = this.actualDrive;
                this.cyl = this.pcn[this.actualDrive];
                this.sec = this.sector[this.actualDrive];
                StatusPanel.SetDriveStatus(this.drv, this.cyl, this.sec, this.nrw);
            }
        }
        if (++this.count == this.next) {
            this.setStatusInfo();
            if (Switches.floppyturbo) {
                Display.turbotimer = 5;
            }
            switch (this.action) {
                case 1: {
                    this.nrw = 3;
                    this.seekStep();
                    break;
                }
                case 0: {
                    this.nrw = 0;
                    this.poll();
                    break;
                }
                case 2: {
                    this.nrw = 0;
                    this.getNextID();
                    break;
                }
                case 4: {
                    this.nrw = 1;
                    this.readSectorByte();
                    break;
                }
                case 8: {
                    this.nrw = 2;
                    this.writeScanByte();
                    break;
                }
                case 5: {
                    this.nrw = 2;
                    this.writeSectorByte();
                    break;
                }
                case 6: {
                    this.nrw = 2;
                    this.writeFormatByte();
                    break;
                }
            }
        }
    }

    public void setForcedHead(int head, int drive) {
        if (this.drives[drive] != null) {
            this.drives[drive].setForcedHead(head);
            this.driveChanged = true;
        }
    }

    public int getForcedHead(int drive) {
        if (this.drives[drive] != null) {
            return this.drives[drive].getForcedHead();
        }
        return 0;
    }

    public String[] getInfo(int drive) {
        try {
            this.drives[drive].setCylinder(0);
            this.poll();
            int cylinder = this.drives[drive].getCylinder();
            int[] disktype = null;
            byte[] info1 = null;
            byte[] info2 = null;
            byte[] info3 = null;
            byte[] info4 = null;
            byte[] info5 = null;
            byte[] info6 = null;
            byte[] info7 = null;
            byte[] info8 = null;
            byte[] info = null;
            int dumpsize = 64;
            int length = 0;
            int position = 0;
            this.parados = false;
            if (this.drives[drive] != null && (disktype = this.drives[drive].getNextSectorID()) != null) {
                if (disktype[2] > 64 && disktype[2] <= 73) {
                    this.systemdisk = true;
                    this.drives[drive].setCylinder(2);
                    info1 = this.drives[drive].getSector(2, 0, 65, 2);
                    info2 = this.drives[drive].getSector(2, 0, 66, 2);
                    info3 = this.drives[drive].getSector(2, 0, 67, 2);
                    info4 = this.drives[drive].getSector(2, 0, 68, 2);
                    info5 = this.drives[drive].getSector(2, 0, 69, 2);
                    info6 = this.drives[drive].getSector(2, 0, 70, 2);
                    info7 = this.drives[drive].getSector(2, 0, 71, 2);
                    info8 = this.drives[drive].getSector(2, 0, 72, 2);
                } else if (disktype[2] > 192 && disktype[2] <= 201) {
                    this.systemdisk = false;
                    this.drives[drive].setCylinder(0);
                    info1 = this.drives[drive].getSector(0, 0, 193, 2);
                    info2 = this.drives[drive].getSector(0, 0, 194, 2);
                    info3 = this.drives[drive].getSector(0, 0, 195, 2);
                    info4 = this.drives[drive].getSector(0, 0, 196, 2);
                    info5 = this.drives[drive].getSector(0, 0, 197, 2);
                    info6 = this.drives[drive].getSector(0, 0, 198, 2);
                    info7 = this.drives[drive].getSector(0, 0, 199, 2);
                    info8 = this.drives[drive].getSector(0, 0, 200, 2);
                } else if (disktype[2] > 144 && disktype[2] <= 159) {
                    this.systemdisk = false;
                    this.drives[drive].setCylinder(0);
                    info1 = this.drives[drive].getSector(0, 0, 145, 2);
                    info2 = this.drives[drive].getSector(0, 0, 146, 2);
                    info3 = this.drives[drive].getSector(0, 0, 147, 2);
                    info4 = this.drives[drive].getSector(0, 0, 148, 2);
                    info5 = this.drives[drive].getSector(0, 0, 149, 2);
                    info6 = this.drives[drive].getSector(0, 0, 150, 2);
                    info7 = this.drives[drive].getSector(0, 0, 151, 2);
                    info8 = this.drives[drive].getSector(0, 0, 152, 2);
                    this.parados = true;
                } else if (disktype[2] > 16 && disktype[2] <= 31) {
                    this.systemdisk = false;
                    this.drives[drive].setCylinder(0);
                    info1 = this.drives[drive].getSector(0, 0, 17, 2);
                    info2 = this.drives[drive].getSector(0, 0, 18, 2);
                    info3 = this.drives[drive].getSector(0, 0, 19, 2);
                    info4 = this.drives[drive].getSector(0, 0, 20, 2);
                    info5 = this.drives[drive].getSector(0, 0, 21, 2);
                    info6 = this.drives[drive].getSector(0, 0, 22, 2);
                    info7 = this.drives[drive].getSector(0, 0, 23, 2);
                    info8 = this.drives[drive].getSector(0, 0, 24, 2);
                    this.parados = true;
                } else {
                    this.systemdisk = false;
                    System.err.println("Unknown disk format: " + Util.hex(disktype[2]));
                    this.drives[drive].setCylinder(0);
                    info1 = this.drives[drive].getSector(0, 0, 193, 2);
                    info2 = this.drives[drive].getSector(0, 0, 194, 2);
                    info3 = this.drives[drive].getSector(0, 0, 195, 2);
                    info4 = this.drives[drive].getSector(0, 0, 196, 2);
                    info5 = this.drives[drive].getSector(0, 0, 197, 2);
                    info6 = this.drives[drive].getSector(0, 0, 198, 2);
                    info7 = this.drives[drive].getSector(0, 0, 199, 2);
                    info8 = this.drives[drive].getSector(0, 0, 200, 2);
                }
                this.drives[drive].setCylinder(cylinder);
                if (info1 != null && info2 != null && info3 != null && info4 != null) {
                    int i;
                    length += info1.length;
                    length += info2.length;
                    length += info3.length;
                    length += info4.length;
                    if (info5 != null) {
                        length += info5.length;
                    }
                    if (info6 != null) {
                        length += info6.length;
                    }
                    if (info7 != null) {
                        length += info7.length;
                    }
                    if (info8 != null) {
                        length += info8.length;
                    }
                    info = new byte[length];
                    for (i = 0; i < info1.length; ++i) {
                        info[position] = info1[i];
                        ++position;
                    }
                    for (i = 0; i < info2.length; ++i) {
                        info[position] = info2[i];
                        ++position;
                    }
                    for (i = 0; i < info3.length; ++i) {
                        info[position] = info3[i];
                        ++position;
                    }
                    for (i = 0; i < info4.length; ++i) {
                        info[position] = info4[i];
                        ++position;
                    }
                    if (info5 != null) {
                        dumpsize += 16;
                        for (i = 0; i < info5.length; ++i) {
                            info[position] = info5[i];
                            ++position;
                        }
                    }
                    if (info6 != null) {
                        dumpsize += 16;
                        for (i = 0; i < info6.length; ++i) {
                            info[position] = info6[i];
                            ++position;
                        }
                    }
                    if (info7 != null) {
                        dumpsize += 16;
                        for (i = 0; i < info7.length; ++i) {
                            info[position] = info7[i];
                            ++position;
                        }
                    }
                    if (info8 != null) {
                        dumpsize += 16;
                        for (i = 0; i < info8.length; ++i) {
                            info[position] = info8[i];
                            ++position;
                        }
                    }
                    return this.showDir(info, drive, dumpsize);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String[] showDir(byte[] info, int drive, int size) {
        int i;
        int i2;
        int counte;
        this.poll();
        String[] entry = new String[size];
        String[] output = null;
        Object[] endentries = null;
        int[] user = new int[size];
        int[] checkuser = null;
        int position = 0;
        int[] check = new int[size];
        int recount = 0;
        int arrayLength = 0;
        boolean sys = false;
        boolean readonly = false;
        boolean corrupt = false;
        this.enduser = null;
        for (counte = 0; counte < size; ++counte) {
            check[counte] = !this.parados ? info[position + 12] : 0;
            if (check[counte] == 0) {
                ++arrayLength;
            }
            entry[counte] = "";
            user[counte] = info[position++];
            for (i2 = 1; i2 < 9; ++i2) {
                int chk = info[position] & 0x7F;
                if (chk < 32 || chk > 127) {
                    corrupt = true;
                }
                int n = counte;
                entry[n] = entry[n] + (char)(info[position] & 0x7F);
                ++position;
            }
            int n = counte;
            entry[n] = entry[n] + ".";
            for (i2 = 0; i2 < 3; ++i2) {
                int n2 = counte;
                entry[n2] = entry[n2] + (char)(info[position] & 0x7F);
                if (i2 == 1 && info[position] < 0) {
                    sys = true;
                }
                if (i2 == 0 && info[position] < 0) {
                    readonly = true;
                }
                ++position;
            }
            if (readonly) {
                int n3 = counte;
                entry[n3] = entry[n3] + "<";
                readonly = false;
            }
            if (sys) {
                if (this.showSys) {
                    int n4 = counte;
                    entry[n4] = entry[n4] + ">";
                } else {
                    entry[counte] = null;
                }
                sys = false;
            }
            if (corrupt) {
                entry[counte] = null;
                corrupt = false;
            }
            position += 20;
        }
        output = new String[arrayLength];
        checkuser = new int[arrayLength];
        for (counte = 0; counte < size; ++counte) {
            if (entry[counte] == null || check[counte] != 0 || user[counte] < 0 || user[counte] > 65301) continue;
            output[recount] = entry[counte];
            checkuser[recount] = user[counte];
            ++recount;
        }
        for (i = 0; i < output.length; ++i) {
            if (output[i] != null) continue;
            --arrayLength;
        }
        endentries = new String[arrayLength];
        for (i = 0; i < arrayLength; ++i) {
            endentries[i] = output[i] + "|" + checkuser[i];
            System.out.println((String)endentries[i]);
        }
        HashSet<String> strings = new HashSet<String>();
        strings.addAll(Arrays.asList(endentries));
        endentries = strings.toArray(new String[0]);
        Arrays.sort(endentries);
        this.enduser = new int[endentries.length];
        for (i2 = 0; i2 < endentries.length; ++i2) {
            Object us = endentries[i2];
            while (((String)us).contains("|")) {
                us = ((String)us).substring(1);
            }
            this.enduser[i2] = Integer.parseInt((String)us);
            while (((String)endentries[i2]).contains("|")) {
                endentries[i2] = ((String)endentries[i2]).substring(0, ((String)endentries[i2]).length() - 1);
            }
        }
        this.poll();
        return endentries;
    }

    public boolean getSystem() {
        return this.systemdisk;
    }

    public int[] getUser() {
        return this.enduser;
    }

    static {
        commands = "";
    }
}

