/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device;

import jemu.core.device.Register;

public abstract class Device {
    public static final Register[] NO_REGISTERS = new Register[0];
    protected String type;
    protected String name;

    public Device(String type) {
        this.type = type;
    }

    public int readByte(int address) {
        return -1;
    }

    public int readWriteByte(int address) {
        return -1;
    }

    public int readWriteByte(int address, int forcedbank, boolean forced) {
        return -1;
    }

    public int writeByte(int address, int value) {
        return value & 0xFF;
    }

    public int writeByte(int address, int value, int forcedbank, boolean forced) {
        return value & 0xFF;
    }

    public int readPort(int port) {
        return -1;
    }

    public void writePort(int port, int value) {
    }

    public void cycle() {
    }

    public void reset() {
    }

    public void setInterrupt(int mask) {
    }

    public void clearInterrupt(int mask) {
    }

    public int event(int id) {
        return 0;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.type + (this.name == null ? "" : " - " + this.name);
    }

    public static void putLong(int[] buffer, int offs, int data) {
        buffer[offs] = (byte)(data & 0xFF);
        buffer[offs + 1] = (byte)(data >> 8 & 0xFF);
        buffer[offs + 2] = (byte)(data >> 16 & 0xFF);
        buffer[offs + 3] = (byte)(data >> 24 & 0xFF);
    }

    public static void putDWord(byte[] buffer, int offs, int data) {
        buffer[offs] = (byte)(data & 0xFF);
        buffer[offs + 1] = (byte)(data >> 8 & 0xFF);
        buffer[offs + 2] = (byte)(data >> 16 & 0xFF);
        buffer[offs + 3] = (byte)(data >> 24 & 0xFF);
    }

    public static int getWord(byte[] buffer, int offs) {
        return buffer[offs] & 0xFF | buffer[offs + 1] << 8 & 0xFF00;
    }

    public static void putWord(byte[] buffer, int offs, int data) {
        buffer[offs] = (byte)(data & 0xFF);
        buffer[offs + 1] = (byte)(data >> 8 & 0xFF);
    }

    public static int getDWord(byte[] buffer, int offs) {
        return buffer[offs] & 0xFF | (buffer[offs + 1] & 0xFF) << 8 | (buffer[offs + 2] & 0xFF) << 16 | (buffer[offs + 3] & 0xFF) << 24;
    }

    public static int getLWord(byte[] buffer, int offs) {
        return buffer[offs + 3] & 0xFF | (buffer[offs + 2] & 0xFF) << 8 | (buffer[offs + 1] & 0xFF) << 16 | (buffer[offs] & 0xFF) << 24;
    }

    public static void putLWord(byte[] buffer, int offs, int data) {
        buffer[offs] = (byte)(data & 0xFF);
        buffer[offs + 1] = (byte)(data >> 8 & 0xFF);
        buffer[offs + 2] = (byte)(data >> 16 & 0xFF);
        buffer[offs + 3] = (byte)(data >> 24 & 0xFF);
    }

    public static void putWordBigEndian(byte[] buffer, int offs, int data) {
        buffer[offs + 1] = (byte)(data & 0xFF);
        buffer[offs] = (byte)(data >> 8 & 0xFF);
    }

    public static void putLongBigEndian(byte[] buffer, int offs, int data) {
        buffer[offs + 3] = (byte)(data & 0xFF);
        buffer[offs + 2] = (byte)(data >> 8 & 0xFF);
        buffer[offs + 1] = (byte)(data >> 16 & 0xFF);
        buffer[offs] = (byte)(data >> 24 & 0xFF);
    }

    public static void putLongBigEndian(int[] buffer, int offs, int data) {
        buffer[offs + 3] = (byte)(data & 0xFF);
        buffer[offs + 2] = (byte)(data >> 8 & 0xFF);
        buffer[offs + 1] = (byte)(data >> 16 & 0xFF);
        buffer[offs] = (byte)(data >> 24 & 0xFF);
    }

    public static int getWordBE(byte[] buffer, int offs) {
        return buffer[offs + 1] & 0xFF | buffer[offs] << 8 & 0xFF00;
    }

    public Register[] getRegisters() {
        return NO_REGISTERS;
    }

    public int getRegisterValue(int index) {
        throw new RuntimeException(this.toString() + ": No such register: " + index);
    }

    public void setRegisterValue(int index, int value) {
        throw new RuntimeException(this.toString() + ": No such register: " + index);
    }
}

