/*
 * Decompiled with CFR 0.152.
 */
package JCPC.system.cpc;

import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Samples {
    MOTOR("JCPC/system/cpc/motor.wav"),
    SEEK("JCPC/system/cpc/seek.wav"),
    SEEKBACK("JCPC/system/cpc/seekback.wav"),
    TRACK("JCPC/system/cpc/track.wav"),
    TRACKBACK("JCPC/system/cpc/trackback.wav"),
    RELAIS("JCPC/system/cpc/relon.wav"),
    RELAISOFF("JCPC/system/cpc/reloff.wav"),
    TAPEMOTOR("JCPC/system/cpc/tapmotor.wav"),
    INSERT("JCPC/system/cpc/insert.wav");

    public static Volume volume;
    public boolean nosamples = false;
    public static boolean quiet;
    private Clip clip;

    private Samples(String soundFileName) {
        if (this.nosamples) {
            return;
        }
        try {
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(soundFileName);
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(url);
            AudioFormat format = audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            this.clip = (Clip)AudioSystem.getLine(info);
            this.clip.open(audioInputStream);
        }
        catch (Exception e) {
            this.nosamples = true;
        }
    }

    public void play() {
        if (quiet) {
            return;
        }
        if (this.nosamples) {
            return;
        }
        if (volume != Volume.MUTE) {
            if (this.clip.isRunning()) {
                this.clip.stop();
            }
            this.clip.setFramePosition(0);
            this.clip.start();
        }
    }

    public void click() {
        if (volume != Volume.MUTE) {
            if (this.clip.isRunning()) {
                this.clip.stop();
            }
            this.clip.setFramePosition(0);
            this.clip.start();
        }
    }

    public void loop() {
        if (quiet) {
            SEEK.stop();
            TRACK.stop();
            SEEKBACK.stop();
            TRACKBACK.stop();
            return;
        }
        if (this.nosamples) {
            return;
        }
        if (volume != Volume.MUTE) {
            if (this.clip.isRunning()) {
                this.clip.stop();
            }
            this.clip.setFramePosition(0);
            this.clip.loop(-1);
        }
    }

    public void turn() {
        if (volume != Volume.MUTE) {
            if (this.clip.isRunning()) {
                this.clip.stop();
            }
            this.clip.setFramePosition(0);
            this.clip.loop(-1);
        }
    }

    public void loop2() {
        if (quiet) {
            SEEK.stop();
            TRACK.stop();
            SEEKBACK.stop();
            TRACKBACK.stop();
            return;
        }
        if (this.nosamples) {
            return;
        }
        if (volume != Volume.MUTE && !this.clip.isRunning()) {
            this.clip.setFramePosition(0);
            this.clip.loop(-1);
        }
    }

    public void turn2() {
        if (this.nosamples) {
            return;
        }
        if (volume != Volume.MUTE && !this.clip.isRunning()) {
            this.clip.setFramePosition(0);
            this.clip.loop(-1);
        }
    }

    public void stop() {
        if (this.nosamples) {
            return;
        }
        if (this.clip.isRunning()) {
            this.clip.stop();
        }
        this.clip.setFramePosition(0);
        this.clip.stop();
    }

    static void init() {
        Samples.values();
    }

    static {
        volume = Volume.HIGH;
        quiet = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Volume {
        MUTE,
        LOW,
        MEDIUM,
        HIGH;

    }
}

