/*
 * Decompiled with CFR 0.152.
 */
package JCPC.system.cpc;

import JCPC.core.Util;
import JCPC.core.device.memory.DynamicMemory;
import JCPC.system.cpc.CPC;
import JCPC.system.cpc.GateArray;
import java.awt.image.BufferedImage;
import java.util.Calendar;

public class CPCMemory
extends DynamicMemory {
    protected Calendar cal = Calendar.getInstance();
    protected int ramtype = 0;
    public static final int TYPE_64K = 0;
    public static final int TYPE_128K = 1;
    public static final int TYPE_256K = 15;
    public static final int TYPE_SILICON_DISC = 240;
    public static final int TYPE_128_SILICON_DISC = 241;
    public static final int TYPE_512K = 255;
    protected int[] baseRAM = new int[8];
    protected int[] readMap = new int[8];
    protected int[] writeMap = new int[8];
    protected int ramTYPE;
    protected boolean lower = true;
    protected boolean upper = true;
    public boolean plus = false;
    protected int upperROM = 0;
    protected int plusROM = 0;
    protected int bankRAM = -1;
    public static final int BASE_RAM = 0;
    public static final int BASE_LOWROM = 9;
    public static final int BASE_UPROM = 10;
    public static final int BASE_CART = 26;
    public static final int BASE_ASIC = 58;
    public static final int BASE_MULTIFACE = 59;
    CPC cpc;
    GateArray gateArray;
    public boolean asiclocked = true;
    protected boolean asicRamActive = false;
    int lowRomLoc;
    int lowRomPage;
    int red;
    int green;
    int blue;
    byte[] posbuf = new byte[2];
    int[] spriteX = new int[16];
    int[] spriteY = new int[16];
    int spritepos;
    int posx;
    int posy;
    int[] magnify = new int[]{0, 1, 2, 4};
    int[] xmag = new int[16];
    int[] ymag = new int[16];
    protected int[] SpritePalette = new int[16];
    int[][] sprdata = new int[16][256];
    int[] spriteram = new int[4096];
    public BufferedImage[] spriteImg = new BufferedImage[16];
    String[] CheckInfo = new String[]{"reset", "setROM", "setLowerEnabled", "setMultiEnabled", "setUpperEnabled", "setUpperROM", "setRamBank"};
    boolean lowerROMInserted = false;
    boolean DEBUG_UPPER = false;
    boolean useplus;
    public int selInk;
    int oldInk;
    int spos;
    int oldd = -5;
    int div = 0;
    int delay;
    boolean DEBUG_MF2 = false;
    int[] lowRom = new int[]{0, 16384, 32768};
    boolean DEBUG_LOWER = false;
    int oldval;

    public void setCartridge(byte[] in) {
    }

    public CPCMemory(int type, CPC cpc, GateArray gateArray) {
        super("CPC Memory", 65536, 60);
        this.cpc = cpc;
        this.gateArray = gateArray;
        this.ramtype = type;
        this.setRAMType(type);
        this.reset();
    }

    public int[] getBaseRam() {
        return this.baseRAM;
    }

    public int getBaseAsic() {
        return 58;
    }

    public int readASIC(int address) {
        return this.mem[this.baseAddr[58] + (address & 0x3FFF)] & 0xFF;
    }

    public void writeASIC(int address, int value) {
        this.mem[this.baseAddr[58] + (address & 0x3FFF)] = (byte)value;
    }

    public void setSpritePalette(int i) {
        this.blue = this.readASIC(25634 + i * 2) << 4 & 0xFF;
        this.red = this.readASIC(25634 + i * 2) >> 4 << 4 & 0xFF;
        this.green = this.readASIC(25635 + i * 2) << 4 & 0xFF;
        this.SpritePalette[i] = this.red << 16 | this.green << 8 | this.blue;
    }

    public void eraseSprite(int index) {
        this.spriteX[index] = -2000;
        this.spriteY[index] = -2000;
        this.xmag[index] = 0;
        this.ymag[index] = 0;
    }

    public void setSpritePos2(int index) {
        this.spritepos = 24576 + index * 8;
        this.posbuf[0] = (byte)(this.readASIC(this.spritepos) & 0xFF);
        this.posbuf[1] = (byte)(this.readASIC(this.spritepos + 1) & 0xFF);
        if ((this.posbuf[1] & 3) == 3) {
            this.posbuf[1] = -1;
        }
        this.spriteX[index] = CPCMemory.getWord(this.posbuf, 0);
        if ((this.spriteX[index] & 0x300) == 768) {
            int n = index;
            this.spriteX[n] = this.spriteX[n] | 0xFF00;
        }
        if ((this.spriteX[index] & 0x8000) != 0) {
            this.spriteX[index] = -(0 - this.spriteX[index] & 0xFFFF);
        }
        this.posbuf[0] = (byte)this.readASIC(this.spritepos + 2);
        this.posbuf[1] = (byte)this.readASIC(this.spritepos + 3);
        if ((this.posbuf[1] & 1) == 1) {
            this.posbuf[1] = -1;
        }
        this.spriteY[index] = CPCMemory.getWord(this.posbuf, 0) & 0x1FF;
        if ((this.spriteY[index] & 0x100) == 256) {
            int n = index;
            this.spriteY[n] = this.spriteY[n] | 0xFF00;
        }
        if ((this.spriteY[index] & 0x8000) != 0) {
            this.spriteY[index] = -(0 - this.spriteY[index] & 0xFFFF);
        }
    }

    public void setSpritePos(int index) {
        this.spritepos = 24576 + index * 8;
        this.spriteX[index] = (this.readASIC(this.spritepos) | this.readASIC(this.spritepos + 1) << 8) & 0x3FF;
        if ((this.spriteX[index] & 0x300) == 768) {
            int n = index;
            this.spriteX[n] = this.spriteX[n] | 0xFF00;
        }
        if ((this.spriteX[index] & 0x8000) != 0) {
            this.spriteX[index] = -(0 - this.spriteX[index] & 0xFFFF);
        }
        this.spriteY[index] = (this.readASIC(this.spritepos + 2) | this.readASIC(this.spritepos + 3) << 8) & 0x1FF;
        if ((this.spriteY[index] & 0x100) == 256) {
            int n = index;
            this.spriteY[n] = this.spriteY[n] | 0xFF00;
        }
        if ((this.spriteY[index] & 0x8000) != 0) {
            this.spriteY[index] = -(0 - this.spriteY[index] & 0xFFFF);
        }
    }

    public void setSpriteX(int index, int value) {
        this.spriteX[index] = value;
    }

    public void setSpriteY(int index, int value) {
        this.spriteY[index] = value;
    }

    public void setMag(int index, int value) {
        int mag = value & 0xF;
        this.xmag[index] = this.magnify[mag >> 2 & 3];
        this.ymag[index] = this.magnify[mag & 3];
        this.gateArray.spritechanged[index] = true;
        this.gateArray.xm[index] = this.xmag[index];
        this.gateArray.ym[index] = this.ymag[index];
    }

    public int getSpriteX(int index) {
        return this.spriteX[index];
    }

    public int getSpriteY(int index) {
        return this.spriteY[index];
    }

    public int[] getSprite(int index) {
        return this.sprdata[index];
    }

    public void setSpriteData(int index) {
        for (int i = 0; i < this.sprdata[index].length; ++i) {
            int val = this.spriteram[index * 256 + i] & 0xF;
            this.sprdata[index][i] = val != 0 ? this.SpritePalette[val - 1] : -1234567890;
        }
    }

    public void destroySprite(int index) {
        int i;
        this.spritepos = 16384 + index * 256;
        for (i = 0; i < 256; ++i) {
            this.spriteram[index * 256 + i] = Util.random(15);
        }
        for (i = 0; i < this.sprdata[index].length; ++i) {
            this.writeASIC(i + this.spritepos, 0);
        }
    }

    public void putSpriteImg(int index) {
        BufferedImage spriteI = new BufferedImage(32, 32, 2);
        int xoff = 0;
        int yoff = 0;
        for (int y = 0; y < 32; y += 2) {
            for (int x = 0; x < 32; x += 2) {
                int rgb = this.sprdata[index][yoff * 16 + xoff];
                rgb = rgb == -123456789 ? 0xFFFFFF : (rgb -= 0x1000000);
                ++xoff;
                spriteI.setRGB(x, y, rgb);
                spriteI.setRGB(x + 1, y, rgb);
                spriteI.setRGB(x + 1, y + 1, rgb);
                spriteI.setRGB(x, y + 1, rgb);
            }
            xoff = 0;
            ++yoff;
        }
        try {
            this.spriteImg[index] = new BufferedImage(16 * (this.xmag[index] + 1), 16 * (this.ymag[index] + 1) * 2, 2);
            this.spriteImg[index].getGraphics().drawImage(spriteI, 0, 0, 16 * this.xmag[index], 16 * this.ymag[index] * 2, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pluspalette(int ink) {
        this.blue = this.readASIC(25600 + ink * 2) & 0xF;
        this.red = this.readASIC(25600 + ink * 2) >> 4 & 0xF;
        this.green = this.readASIC(25601 + ink * 2) & 0xF;
        GateArray.setPlusPalette(ink, this.red, this.green, this.blue);
    }

    public void setPlus(boolean pl) {
        this.plus = pl;
    }

    public void reset() {
        int i;
        this.lowRomLoc = 0;
        this.lowRomPage = 0;
        for (i = 0; i < 65536; ++i) {
            this.mem[i] = 0;
            this.writeASIC(i, 176);
        }
        this.killSprites();
        for (i = 0; i < 16; ++i) {
            this.setMag(i, 0);
        }
        System.out.println("Memory reset!");
        this.setRAMBank(192);
        this.asiclocked = true;
        this.asicRamActive = false;
        this.upper = false;
        this.lower = true;
        this.upperROM = 0;
        this.plusROM = 0;
        this.enableAsicRam(this.asicRamActive, this.lowRomLoc, this.lowRomPage);
        try {
            this.cpc.psg.resetRegisters();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.remap();
    }

    public void killSprites() {
        for (int i = 0; i < 16; ++i) {
            this.destroySprite(i);
        }
    }

    public void setRAMType(int value) {
        this.ramTYPE = value;
        this.getMem(0, 65536);
        for (int i = 1; i < 9; ++i) {
            if ((this.ramTYPE & 1) != 0) {
                this.getMem(i, 65536);
            } else {
                this.freeMem(i, 65536);
            }
            this.ramTYPE >>= 1;
        }
        this.getMem(58, 16384);
        this.getMem(59, 16384);
    }

    public int getRAMType() {
        return this.ramtype;
    }

    public void setLowerROM(byte[] data) {
        this.setROM(9, data);
    }

    public void setMultiROM(byte[] data) {
        this.setROM(59, data);
    }

    public void setUpperROM(int rom, byte[] data) {
        this.setROM(10 + (rom & 0xF), data);
    }

    public void setPlusROM(int rom, byte[] data) {
        this.lowerROMInserted = this.setROM(26 + rom, data);
    }

    protected boolean setROM(int base, byte[] data) {
        if (data == null || data.length == 0) {
            this.freeMem(base, 16384);
            return false;
        }
        base = this.getMem(base, 16384);
        System.arraycopy(data, 0, this.mem, base, Math.min(16384, data.length));
        return true;
    }

    public void setLowerEnabled(boolean value) {
        if (this.lower != value) {
            this.lower = value;
            this.remap();
        }
    }

    public void setUpperEnabled(boolean value) {
        if (this.upper != value) {
            this.upper = value;
            this.remap();
        }
    }

    public boolean getUpperEnabled() {
        return this.upper;
    }

    public void setUpperROM(int value) {
        this.useplus = false;
        if ((value &= 0xFF) > 127) {
            this.useplus = true;
            value &= 0x1F;
            if (this.DEBUG_UPPER) {
                System.err.println("plusmap:" + Util.hex((byte)value));
            }
            this.plusROM = value;
        } else if (this.plus) {
            this.useplus = true;
            value &= 0xF;
            if (this.DEBUG_UPPER) {
                System.err.println("normalmap:" + Util.hex((byte)value));
            }
            value = value == 7 ? 3 : 1;
            this.plusROM = value;
        } else {
            this.useplus = false;
            this.upperROM = value;
        }
        this.remap();
    }

    public int getUpperROM() {
        return this.upperROM;
    }

    public int getPlusROM() {
        return this.plusROM;
    }

    public void setRAMBank(int value) {
        if (this.bankRAM != (value &= 0x3F)) {
            this.bankRAM = value;
            this.remapRAM();
        }
    }

    public int getRAMBank() {
        return this.bankRAM | 0xC0;
    }

    public void remapRAM() {
        int mask = 0;
        boolean enable128k = false;
        boolean enable256k = false;
        boolean silicondiskenabled = false;
        if (this.ramtype == 1 || this.ramtype == 241) {
            enable128k = true;
        }
        if (this.ramtype == 15) {
            enable256k = true;
        }
        if (this.ramtype == 241 || this.ramtype == 240) {
            silicondiskenabled = true;
        }
        if (enable128k) {
            mask |= 7;
        }
        if (enable256k) {
            mask |= 0x1F;
        }
        if (silicondiskenabled) {
            mask |= 0x3F;
        }
        if (mask != 0) {
            this.bankRAM &= mask;
        }
        int bankBase = ((this.bankRAM & 0x38) >> 3) + 0 + 1;
        if ((bankBase = this.baseAddr[bankBase]) == -1) {
            bankBase = this.baseAddr[0];
            this.bankRAM = 0;
        }
        int base = (this.bankRAM & 7) == 2 ? bankBase : this.baseAddr[0];
        for (int i = 0; i < 8; ++i) {
            this.baseRAM[i] = base + i * 8192;
        }
        if ((this.bankRAM & 5) == 1) {
            this.baseRAM[6] = bankBase + 49152;
            this.baseRAM[7] = this.baseRAM[6] + 8192;
            if ((this.bankRAM & 2) == 2) {
                this.baseRAM[2] = base + 49152;
                this.baseRAM[3] = this.baseRAM[2] + 8192;
            }
        } else if ((this.bankRAM & 4) == 4) {
            this.baseRAM[2] = bankBase + (this.bankRAM & 3) * 16384;
            this.baseRAM[3] = this.baseRAM[2] + 8192;
        }
        if (this.asicRamActive) {
            this.baseRAM[2] = this.baseAddr[58];
            this.baseRAM[3] = this.baseRAM[2] + 8192;
        }
        this.remap();
    }

    public int readByte(int address) {
        try {
            return this.mem[this.readMap[address >> 13] + (address & 0x1FFF)] & 0xFF;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public byte readLowByte(int address) {
        return this.mem[this.baseAddr[0] + address];
    }

    public boolean getASICActive() {
        return this.baseRAM[2] == this.baseAddr[58] && this.baseRAM[3] == this.baseAddr[58] + 8192;
    }

    public int writeByte(int address, int value) {
        value &= 0xFF;
        if (this.asicRamActive && address > 16383 && address < 32768) {
            int d;
            if (address > 25599 && address < 25666 && (address & 1) != 0) {
                value &= 0xF;
            }
            if (address > 16383 && address < 20480) {
                d = (address - 16384) / 256;
                this.gateArray.spritechanged[d] = true;
                this.spriteram[address - 16384] = value & 0xF;
            }
            this.writeASIC(address, value);
            this.cpc.getAsic().ASIC_WriteRam(address, value);
            if (address > 25599 && address <= 25634) {
                this.pluspalette(address - 25600 >> 1);
            }
            if (address >= 24576 && address < 24704) {
                d = (address - 24576) / 8;
                this.gateArray.spritechanged[d] = true;
            }
        }
        this.mem[this.writeMap[address >> 13] + (address & 0x1FFF)] = (byte)value;
        return value & 0xFF;
    }

    public int writeByte(int address, int value, int forcedbank, boolean forced) {
        if (address > 16383 && address < 32768) {
            int g = this.getRAMBank();
            this.setRAMBank(forcedbank);
            try {
                this.mem[this.writeMap[address >> 13] + (address & 0x1FFF)] = (byte)value;
            }
            catch (Exception exception) {
                // empty catch block
            }
            int b = value & 0xFF;
            this.setRAMBank(g);
            return b;
        }
        return this.writeByte(address, value);
    }

    public void poke(int address, int value) {
        this.mem[address] = (byte)value;
    }

    public void remap() {
        this.mapRAM();
        this.mapROMs();
    }

    public int[] ReadMap() {
        return this.readMap;
    }

    protected void mapRAM() {
        for (int i = 0; i < this.baseRAM.length; ++i) {
            this.readMap[i] = this.baseRAM[i];
            this.writeMap[i] = this.baseRAM[i];
        }
        if (this.asicRamActive) {
            this.writeMap[2] = this.readMap[2] = this.baseAddr[58];
            this.writeMap[3] = this.readMap[3] = this.readMap[2] + 8192;
        }
    }

    public void enableAsicRam(boolean asicRamActive, int lowRomLoc, int lowRomPage) {
        this.asicRamActive = asicRamActive;
        this.lowRomLoc = lowRomLoc;
        this.lowRomPage = lowRomPage;
        this.remapRAM();
        this.remap();
    }

    protected void mapROMs() {
        int addr;
        if (!this.plus && this.lower && (addr = this.baseAddr[9]) != -1) {
            this.readMap[0] = addr;
            this.readMap[1] = addr + 8192;
        }
        if (this.plus && this.lower) {
            if (this.DEBUG_LOWER) {
                System.err.println("plusROM lower = " + this.plusROM);
            }
            if ((addr = this.baseAddr[26 + this.lowRomPage]) == -1) {
                addr = this.baseAddr[26];
            }
            if (addr != -1) {
                this.readMap[this.lowRomLoc] = addr;
                this.readMap[this.lowRomLoc + 1] = addr + 8192;
            }
        }
        if (this.upper && !this.useplus) {
            addr = this.baseAddr[10 + this.upperROM];
            if (addr == -1) {
                addr = this.baseAddr[10];
            }
            if (addr != -1) {
                this.readMap[6] = addr;
                this.readMap[7] = addr + 8192;
            }
        }
        if (this.upper && this.useplus) {
            addr = this.baseAddr[26 + this.plusROM];
            if (addr == -1) {
                addr = this.baseAddr[26];
            }
            if (addr != -1) {
                this.readMap[6] = addr;
                this.readMap[7] = addr + 8192;
            }
        }
    }

    public int readPort(int port) {
        this.cal = Calendar.getInstance();
        int result = 255;
        if (port == 65278) {
            result = 160;
        }
        return result;
    }

    public int readByte(int address, Object config) {
        return this.readByte(address);
    }
}

