/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.device.crtc;

import JCPC.core.Util;
import JCPC.core.device.Register;
import JCPC.core.device.crtc.CRTC;
import JCPC.core.device.crtc.Slider;
import JCPC.system.cpc.CPC;
import JCPC.system.cpc.plus.ASIC;
import JCPC.ui.Display;

public class Basic6845
extends CRTC {
    protected boolean DEBUG = false;
    public static boolean patch = false;
    boolean ignore;
    boolean debug = false;
    boolean hitech;
    boolean camemb4;
    boolean skoh;
    boolean tomate;
    boolean special = false;
    public int CRTCType = 1;
    public static int CRTC = 1;
    public static int HCC;
    int[] AsicCRTC_ReadMaskTable = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
    int[] AsicCRTC_WriteMaskTable = new int[]{255, 255, 255, 255, 127, 31, 127, 127, 243, 31, 127, 31, 63, 255, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
    protected int[] HD6845S_ReadMaskTable = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
    protected int[] HD6845S_WriteMaskTable = new int[]{255, 255, 255, 255, 127, 31, 127, 127, 243, 31, 127, 31, 63, 255, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
    protected int[] UM6845R_ReadMaskTable = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0};
    protected int[] UM6845R_WriteMaskTable = new int[]{255, 255, 255, 255, 127, 31, 127, 127, 3, 31, 127, 31, 63, 255, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
    protected final Register[] REGISTERS = new Register[]{new Register("Horizontal Total"), new Register("Horizontal Displayed"), new Register("HSync Position"), new Register("Sync Width"), new Register("Vertical Total"), new Register("Vertical Total Adjust"), new Register("Vertical Displayed"), new Register("VSync Position"), new Register("Interlace and Delay"), new Register("Max Scan Line"), new Register("Cursor Start"), new Register("Cursor End"), new Register("Display Start Address (High)", 16), new Register("Display Start Address (Low)", 16), new Register("Cursor Address (High)", 16), new Register("Cursor Address (Low)", 16), new Register("Lightpen Address (High)", 16), new Register("Lightpen Address (High)", 16)};
    protected CPC cpc;
    protected final int EVENT_HSYNC_START = 1;
    protected final int EVENT_HDISP_END = 2;
    protected final int EVENT_HDISP_START = 4;
    protected final int EVENT_VSYNC_START = 8;
    protected final int EVENT_VSYNC_END = 16;
    public static boolean CRTCCollision;
    protected int lastReg = 0;
    public boolean Scratch;
    public boolean Scratchdemo = false;
    protected static final int[] CURSOR_FLASH_MASKS;
    public int RasterCounter;
    public int hCC;
    public int LineCounter;
    protected int hCCMask = 127;
    protected static int[] reg;
    protected static int[] regs;
    protected int[] orig = new int[32];
    protected int[] rdMask;
    protected int[] wrMask;
    protected int[] eventMask = new int[256];
    protected int registerSelectMask = 3;
    protected int registerSelectTest = 0;
    protected int registerWriteMask = 3;
    protected int registerWriteTest = 0;
    protected int registerReadMask = 3;
    protected int registerReadTest = 0;
    protected int registerStatusMask = 3;
    protected int registerStatusTest = 0;
    protected int selReg;
    protected int hChars = 1;
    protected int hSyncStart;
    protected int hDispEnd;
    protected int hSyncWidth;
    protected int hSyncCount;
    protected int vSyncCount;
    protected int vSyncWidth;
    protected boolean inHSync = false;
    protected boolean inVSync = false;
    public boolean hDisp = true;
    public boolean vDisp = true;
    protected boolean interlace = false;
    protected int interlaceVideo = 0;
    protected int scanAdd = 1;
    protected int maxRaster = 0;
    protected int frame = 0;
    public int maStore = 0;
    public int maCurrent = 0;
    public int maRegister = 0;
    public int vtAdj = 0;
    protected int halfR0 = 0;
    protected int hDispDelay = 0;
    protected int cursorMA = 0;
    protected int cursorStart = 0;
    protected int cursorEnd = 0;
    protected boolean cursor = false;
    protected int cursorCount = 0;
    protected int cursorFlash = 0;
    protected int cursorDelay = 0;
    protected int cursorWait = 0;
    int keepMA;
    int oldline;
    int tick;
    int lc;
    int rc;
    Slider slider;
    public boolean asicsync;
    boolean dosync = false;
    int maBase = 0;
    boolean wasHSync;
    int asicSync = 0;
    int maScroll;
    protected boolean repaint = true;
    ASIC asic;
    boolean ASIC_DoScreenSplit = false;
    boolean ASIC_DoScreenSplitDelayed = false;
    boolean CRTC_VTOT_FLAG = true;
    boolean ASIC_RasterLineMatch;
    protected int maLightpen = 0;
    public boolean lightgun = false;
    int lpx = 0;
    int lpy = 0;
    boolean ll;
    boolean lf;
    boolean trigger;
    boolean nocomment = false;
    public int addline = 0;
    boolean gunTriggered = false;
    byte[] lpenreg = new byte[2];
    int realreg3;
    int[] scrolls = new int[]{0, 7, 6, 5, 4, 3, 2, 1};
    boolean vbit;
    int maVCC;
    int oldc;
    int oldn;
    int oldl;
    int newl;

    public Basic6845(CPC cpc) {
        super("Basic 6845");
        this.cpc = cpc;
        this.wrMask = new int[32];
        this.rdMask = this.wrMask;
        this.setMasks();
        this.reset();
    }

    public void init() {
        this.setMasks();
        this.Scratch = false;
        this.Scratchdemo = false;
        this.special = false;
        this.tomate = false;
        this.skoh = false;
        this.camemb4 = false;
        this.hitech = false;
        this.setReg3(142);
    }

    public void reset() {
        this.maScroll = 0;
        this.special = false;
        this.tomate = false;
        this.skoh = false;
        this.camemb4 = false;
        this.hitech = false;
        this.hCC = 0;
        this.selReg = 0;
        this.maCurrent = this.maStore;
        this.hSyncCount = 0;
        this.hSyncWidth = 0;
        this.inHSync = false;
        for (int i = 0; i < this.eventMask.length; ++i) {
            this.eventMask[i] = 0;
        }
        Basic6845.reg[0] = 0x3F & this.wrMask[0];
        Basic6845.regs[0] = 0x3F & this.wrMask[0];
        this.setEvents();
    }

    public void setWriteMask(int reg, int mask) {
        this.wrMask[reg] = mask;
    }

    public void setMasks() {
        for (int i = 0; i < 32; ++i) {
            if (this.CRTCType == 0) {
                this.rdMask[i] = 0xFF | this.HD6845S_ReadMaskTable[i];
                this.wrMask[i] = 0xFF & this.HD6845S_WriteMaskTable[i];
            } else if (this.CRTCType == 1) {
                this.rdMask[i] = 0xFF | this.UM6845R_ReadMaskTable[i];
                this.wrMask[i] = 0xFF & this.UM6845R_WriteMaskTable[i];
            } else if (this.CRTCType == 3) {
                this.rdMask[i] = 0xFF | this.AsicCRTC_ReadMaskTable[i];
                this.wrMask[i] = 0xFF & this.AsicCRTC_WriteMaskTable[i];
            }
            this.setRegister(i, this.orig[i]);
        }
    }

    void checkSlider() {
        if (this.slider == null) {
            this.slider = new Slider();
            this.slider.slider.setMaximum(16);
            this.slider.slider.setMinimum(0);
            this.slider.setVisible(true);
        }
    }

    public void asicHSync() {
        if (this.asic == null) {
            this.asic = this.cpc.getAsic();
        }
        this.asic.ASIC_HSync(this.LineCounter, this.RasterCounter);
    }

    public int getHSyncWidth() {
        return this.hSyncWidth;
    }

    public int gethSyncCount() {
        return this.hSyncCount;
    }

    public void cycle() {
        int mask;
        if (this.asic == null) {
            this.asic = this.cpc.getAsic();
        }
        if (this.asicSync == 7) {
            // empty if block
        }
        ++this.asicSync;
        if (this.wasHSync != this.inHSync) {
            this.wasHSync = this.inHSync;
            if (!this.wasHSync) {
                // empty if block
            }
        }
        if (this.hCC == reg[0]) {
            this.hCC = 0;
            this.scanStart();
            if (this.maScroll == 0) {
                this.maCurrent = this.maStore & 0x3FFF;
            }
        } else {
            this.hCC = this.hCC + 1 & this.hCCMask;
            this.maCurrent = this.maStore + this.hCC & 0x3FFF;
        }
        if (this.inHSync) {
            if (this.oldline != this.getLine()) {
                this.asicSync = 0;
                this.asicHSync();
                this.oldline = this.getLine();
            }
            this.hSyncCount = this.hSyncCount + 1 & 0xF;
            if (this.hSyncCount == this.hSyncWidth) {
                this.dosync = true;
            }
        }
        if (this.inHSync && this.hSyncCount == this.hSyncWidth) {
            this.inHSync = false;
            this.listener.hSyncEnd();
        }
        if ((mask = this.eventMask[this.hCC]) != 0) {
            if ((mask & 8) != 0) {
                int n = this.hCC;
                this.eventMask[n] = this.eventMask[n] & 0xFFFFFFF7;
                this.inVSync = true;
                this.listener.vSyncStart();
            } else if ((mask & 0x10) != 0) {
                int n = this.hCC;
                this.eventMask[n] = this.eventMask[n] & 0xFFFFFFEF;
                this.inVSync = false;
                this.listener.vSyncEnd();
            }
            if ((mask & 1) != 0) {
                this.hSyncCount = 0;
                if (this.hDisp && this.CRTCType == 1 && this.hSyncWidth == (reg[3] & 0xF)) {
                    this.vDisp = reg[6] != 0;
                    this.hSyncCount = 1;
                }
                this.inHSync = true;
                this.listener.hSyncStart();
            }
            if (this.vDisp) {
                if ((mask & 4) != 0) {
                    this.hDisp = true;
                    this.hDispStart();
                }
                if ((mask & 2) != 0) {
                    this.hDisp = false;
                    this.listener.hDispEnd();
                    if ((this.getRA() | this.interlaceVideo) == this.maxRaster) {
                        this.maStore = this.maStore + reg[1] & 0x3FFF;
                    }
                }
            }
        }
        this.checkHSync(false);
        if (this.cursor) {
            if (this.cursorWait > 0) {
                if (--this.cursorWait == 0) {
                    this.listener.cursor();
                }
            } else if (this.maCurrent == this.cursorMA && this.getRA() >= this.cursorStart && this.getRA() <= this.cursorEnd && this.hDisp && (this.cursorWait = this.cursorDelay) == 0) {
                this.listener.cursor();
            }
        }
        HCC = this.hCC;
    }

    protected void hDispStart() {
        this.maCurrent = this.maStore & 0x3FFF;
        if (this.CRTCType == 0 && this.LineCounter == 0 && this.RasterCounter == 0 && this.maScroll == 0 && reg[1] < 48) {
            this.updateScreen();
        }
        if (this.CRTCType == 1 && this.LineCounter == 0 && !this.camemb4) {
            this.updateScreen();
        }
        this.listener.hDispStart();
    }

    protected void newFrame() {
        this.LineCounter = 0;
        this.frame = this.interlace ? this.frame ^ 1 : 0;
        this.CRTC_ClearFlag();
        this.RasterCounter = this.frame & this.interlaceVideo & 7;
        this.vDisp = reg[6] != 0;
        this.vDisp = true;
        this.updateScreen();
        this.listener.vDispStart();
        this.checkVSync(false);
        this.cursorCount = this.cursorCount + 1 | 0x40;
        this.cursor = (this.cursorCount & this.cursorFlash) != 0 && this.cursorDelay != 3;
    }

    public void updateScreen() {
        this.maCurrent = this.maStore = (this.maRegister = reg[13] + (reg[12] << 8) & 0x3FFF);
        this.maBase = this.maRegister;
    }

    protected void checkVSync(boolean vcc) {
        if (this.special && this.CRTCType == 0) {
            vcc = true;
        } else if (vcc && (reg[6] != this.RasterCounter && this.special || !this.special)) {
            if (this.vtAdj == 0 || this.CRTCType == 1) {
                this.LineCounter = this.LineCounter + 1 & 0x7F;
            }
            vcc = false;
        }
        if (this.LineCounter == reg[7] && !this.inVSync) {
            this.vSyncCount = 0;
            if (this.interlace && this.frame == 0) {
                int n = this.halfR0;
                this.eventMask[n] = this.eventMask[n] | 8;
            } else {
                this.inVSync = true;
                this.listener.vSyncStart();
            }
        }
        if (vcc && this.vtAdj == 0) {
            this.LineCounter = this.LineCounter + 1 & 0x7F;
        }
    }

    public void checkHDisp() {
        if (this.hDisp) {
            if (this.CRTCType == 0) {
                if ((reg[8] & 0x30) == 48) {
                    this.listener.hDispEnd();
                } else if ((reg[8] & 0x30) == 0) {
                    this.listener.hDispStart();
                }
            } else if (reg[6] != 0) {
                this.listener.hDispStart();
            } else {
                this.listener.hDispEnd();
            }
        }
    }

    public void avoidCollision() {
        if (this.inVSync && reg[4] <= reg[7]) {
            if (this.LineCounter == reg[7]) {
                this.vSyncCount = 0;
            }
            this.repaint = true;
            CRTCCollision = true;
        } else {
            CRTCCollision = false;
            if (this.LineCounter == 0 && this.hCC == reg[1] && !this.inVSync && !this.inHSync && this.lastReg == 4) {
                CRTCCollision = true;
                if (this.repaint) {
                    this.repaint = false;
                }
            }
        }
        if (reg[9] == 0 && reg[4] == 0 && this.inVSync) {
            this.vtAdj = 1;
        }
        CRTCCollision = false;
    }

    protected void scanStart() {
        this.updateLightpen();
        if (CRTC != this.CRTCType) {
            this.CRTCType = CRTC;
            System.out.println("Changed CRTC type to " + CRTC);
            this.setMasks();
        }
        if (reg[9] == 0 && reg[4] == 0 && (this.CRTCType == 0 || this.CRTCType == 3)) {
            this.vtAdj = 1;
        }
        this.demoDetect();
        if (this.inVSync && (this.vSyncCount = this.vSyncCount + 1 & 0xF) == this.vSyncWidth) {
            if (this.interlace && this.frame == 0) {
                int n = this.halfR0;
                this.eventMask[n] = this.eventMask[n] | 0x10;
            } else {
                this.inVSync = false;
                this.listener.vSyncEnd();
            }
        } else if (this.vSyncCount == 0 && (this.CRTCType == 0 || this.CRTCType == 3) && this.LineCounter == 0 && this.RasterCounter == 0 && this.maScroll == 0) {
            this.updateScreen();
        }
        if (this.vtAdj > 0 && --this.vtAdj == 0) {
            this.newFrame();
        } else if ((this.RasterCounter | this.interlaceVideo) == this.maxRaster) {
            if (this.LineCounter == reg[4] && this.vtAdj == 0) {
                this.CRTC_SetFlag();
                this.vtAdj = reg[5] & 0x1F;
                if (this.interlace && this.frame == 0) {
                    ++this.vtAdj;
                }
                if (this.vtAdj == 0) {
                    this.newFrame();
                    return;
                }
                if (this.CRTCType == 0) {
                    this.LineCounter = this.LineCounter + 1 & 0x7F;
                }
            }
            if (reg[7] < reg[6] && this.LineCounter == reg[7] && this.vSyncCount == reg[7]) {
                this.vtAdj = 1;
                this.vSyncWidth = 0;
            }
            this.checkVSync(true);
            if (this.LineCounter == reg[6]) {
                this.vDisp = false;
            }
            this.RasterCounter = this.frame & this.interlaceVideo & 7;
        } else {
            this.RasterCounter = this.RasterCounter + this.scanAdd & 7;
        }
        this.ASICCRTC_ScreenSplit();
    }

    public void ASICCRTC_ScreenSplit() {
        if (this.ASIC_DoScreenSplit) {
            this.ASIC_DoScreenSplit = false;
            this.maCurrent = this.maStore = this.asic.ASIC_ScreenMA();
        }
        if (this.ASIC_DoScreenSplitDelayed) {
            this.ASIC_DoScreenSplitDelayed = false;
            this.ASIC_DoScreenSplit = true;
        }
        if (this.asic.ASIC_RasterSplitLineMatch(this.LineCounter, this.RasterCounter)) {
            if (!this.CRTC_VTOT_FLAG) {
                this.ASIC_DoScreenSplit = true;
            } else {
                this.ASIC_DoScreenSplitDelayed = true;
            }
        }
    }

    public void CRTC_SetFlag() {
        this.CRTC_VTOT_FLAG = true;
    }

    public void CRTC_ClearFlag() {
        this.CRTC_VTOT_FLAG = false;
    }

    public void writePort(int port, int value) {
        if ((port & this.registerSelectMask) == this.registerSelectTest) {
            this.selReg = value & 0x1F;
            if (this.asic == null) {
                this.asic = this.cpc.getAsic();
            }
            this.asic.ASIC_EnableDisable(value);
        } else if ((port & this.registerWriteMask) == this.registerWriteTest) {
            this.setRegister(this.selReg, value);
        }
        this.lastReg = this.selReg;
    }

    public void setLightpen(int x, int y, boolean large, boolean fullscreen, boolean trigger) {
        if (this.lightgun) {
            this.gunTriggered = trigger;
            if (!large && !fullscreen) {
                x *= 2;
                y *= 2;
            }
            if (!fullscreen && Display.drawmonitor) {
                x -= 60;
                y -= 80;
            }
            int[] field = this.listener.getField();
            this.lpx = x -= field[0];
            this.lpy = y -= field[2];
            this.ll = large;
            this.lf = fullscreen;
        }
    }

    public void updateLightpen() {
        if (this.trigger != this.gunTriggered) {
            this.trigger = this.gunTriggered;
            System.out.println(this.trigger ? "Triggered" : "Not triggered");
        }
        if (!this.gunTriggered) {
            this.maLightpen = this.maBase;
        } else if (this.lpx > -8 && this.lpx < 623 && this.lpy > -8 && this.lpy < 408) {
            int pos = (this.lpx >> 4) + (this.lpy >> 4) * reg[1];
            this.maLightpen = 12288 + pos + 45 & 0x3FFF;
        }
        this.nocomment = true;
        this.setRegister(16, this.maLightpen >> 8 & 0xFF);
        this.setRegister(17, this.maLightpen & 0xFF);
        this.nocomment = false;
    }

    public void addLine() {
        ++this.addline;
    }

    public void releaseGun() {
        this.gunTriggered = false;
    }

    public int readPort(int port) {
        if (this.cpc.memory.plus) {
            if ((this.selReg == 16 || this.selReg == 17) && this.lightgun) {
                switch (this.selReg) {
                    case 16: {
                        return reg[16] & 0xFF;
                    }
                    case 17: {
                        return reg[17] & 0xFF;
                    }
                }
            }
            if ((port & this.registerStatusMask) == this.registerStatusTest) {
                return reg[this.selReg];
            }
            return 255;
        }
        if ((port & this.registerStatusMask) == this.registerStatusTest && this.CRTCType == 1) {
            if (this.LineCounter == 0) {
                if (this.DEBUG) {
                    System.out.println("Status register read: 32");
                }
                return 32;
            }
            return 0;
        }
        if ((port & this.registerReadMask) == this.registerReadTest) {
            if (this.DEBUG) {
                System.out.println("register read: " + this.selReg);
            }
            int value = reg[this.selReg];
            if (this.selReg < 10 || this.selReg > 17) {
                return 0;
            }
            if (this.CRTCType == 0) {
                switch (this.selReg) {
                    case 10: 
                    case 11: {
                        return value & 0x1F;
                    }
                    case 12: 
                    case 14: 
                    case 16: {
                        return value & 0x3F;
                    }
                }
                return value & 0xFF;
            }
            if (this.CRTCType == 1) {
                switch (this.selReg) {
                    case 11: {
                        return value & 0x1F;
                    }
                    case 12: 
                    case 13: {
                        return 0;
                    }
                    case 16: {
                        return value & 0x3F;
                    }
                }
                return value & 0xFF;
            }
        }
        return 0;
    }

    public void setRegister(int index, int value) {
        this.orig[index] = value & 0xFF;
        if (reg[index] != (value &= this.wrMask[index])) {
            Basic6845.reg[index] = value;
            Basic6845.regs[index] = value;
            switch (index) {
                case 0: {
                    if (this.inHSync && value == 49) {
                        this.checkHSync(true);
                    }
                }
                case 1: 
                case 2: {
                    this.setEvents();
                    break;
                }
                case 3: {
                    this.setReg3(value);
                    this.setEvents();
                    break;
                }
                case 8: {
                    this.setReg8(value);
                    break;
                }
                case 9: {
                    this.maxRaster = value | this.interlaceVideo;
                    break;
                }
                case 10: {
                    this.cursorStart = value & 0x1F;
                    this.cursorFlash = CURSOR_FLASH_MASKS[value >> 5 & 3];
                    break;
                }
                case 11: {
                    this.cursorEnd = value & 0x1F;
                    break;
                }
                case 12: 
                case 13: {
                    this.maRegister = reg[13] + (reg[12] << 8) & 0x3FFF;
                    break;
                }
                case 14: 
                case 15: {
                    this.cursorMA = reg[15] + (reg[14] << 8) & 0x3FFF;
                    System.out.println("Register 14 write " + Util.hex((short)this.cursorMA));
                    break;
                }
                case 16: {
                    Basic6845.reg[16] = value;
                    if (this.nocomment) break;
                    System.out.println("Register 16 write " + Util.hex((short)value));
                    break;
                }
                case 17: {
                    Basic6845.reg[17] = value;
                    if (this.nocomment) break;
                    System.out.println("Register 17 write " + Util.hex((short)value));
                }
            }
        }
    }

    protected void demoDetect() {
        if (!patch) {
            return;
        }
        this.special = this.listener.PEEK(3554) == 68 && this.listener.PEEK(3555) == 85 && this.listener.PEEK(3556) == 79 || this.listener.PEEK(3554) == 229 && this.listener.PEEK(3555) == 58 && this.listener.PEEK(3556) == 184 || this.listener.PEEK(33474) == 55 && this.listener.PEEK(33475) == 56 && this.listener.PEEK(33476) == 55 || this.listener.PEEK(9216) == 75 && this.listener.PEEK(9218) == 77 && this.listener.PEEK(9224) == 78;
        this.camemb4 = this.listener.PEEK(34816) == 148 && this.listener.PEEK(34817) == 76 && this.listener.PEEK(34818) == 148;
        if (this.listener.PEEK(13527) == 72 && this.listener.PEEK(13528) == 97 && this.listener.PEEK(13531) == 122) {
            this.tomate = true;
            this.setReg3(142);
        } else {
            this.tomate = false;
        }
        this.hitech = this.listener.PEEK(6772) == 64 && this.listener.PEEK(6777) == 70 && this.listener.PEEK(2656) == 120;
        if (!this.Scratch && this.listener.PEEK(492) == 50 && this.listener.PEEK(493) == 48 && this.listener.PEEK(495) == 57) {
            this.Scratchdemo = true;
            this.setReg3(143);
            this.Scratch = true;
        }
        this.skoh = this.listener.PEEK(44528) == 108 && this.listener.PEEK(16272) == 77 && this.listener.PEEK(16273) == 79 && this.listener.PEEK(16274) == 75;
    }

    protected void demoPatch() {
        if (!patch) {
            return;
        }
        if (this.hitech && reg[2] != 49 && reg[2] != 0) {
            Basic6845.reg[2] = 35;
        }
        if (this.camemb4) {
            if (reg[1] == 24) {
                Basic6845.reg[1] = 23;
                Basic6845.reg[0] = 255;
            }
            if (reg[12] == 18) {
                this.vDisp = false;
            }
        }
        if (this.skoh) {
            this.hSyncCount = 12;
        }
    }

    protected void setEvents() {
        try {
            int n = this.hSyncStart;
            this.eventMask[n] = this.eventMask[n] & 0xFFFFFFFE;
            int n2 = this.hDispDelay;
            this.eventMask[n2] = this.eventMask[n2] & 0xFFFFFFFB;
            int n3 = this.hDispEnd;
            this.eventMask[n3] = this.eventMask[n3] & 0xFFFFFFFD;
            this.demoPatch();
            this.hChars = reg[0] + 1;
            this.halfR0 = this.hChars >> 1;
            this.hSyncStart = reg[2];
            this.hDispDelay = reg[8] >> 4 & 4;
            this.hDispDelay = 0;
            this.hDispEnd = reg[1] + this.hDispDelay;
            int n4 = this.hSyncStart;
            this.eventMask[n4] = this.eventMask[n4] | 1;
            int n5 = this.hDispDelay;
            this.eventMask[n5] = this.eventMask[n5] | 4;
            int n6 = this.hDispEnd;
            this.eventMask[n6] = this.eventMask[n6] | 2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getVSyncWidth() {
        return this.vSyncWidth;
    }

    protected void setReg3(int value) {
        this.realreg3 = value;
        if (value != 143 && this.Scratchdemo) {
            this.Scratchdemo = false;
        }
        this.vSyncWidth = this.CRTCType == 1 ? 0 : value >> 4 & 0xF;
        boolean debug3 = false;
        if (this.tomate && patch && this.CRTCType != 3 && value == 142) {
            value = 141;
        }
        if (patch && this.CRTCType != 3 && value != 13 && value > 3) {
            --value;
        }
        this.hSyncWidth = value & 0xF;
        if (debug3) {
            System.err.println("setReg3: value is:" + value + " hSyncWidth is:" + this.hSyncWidth + " vSyncWidth is:" + this.vSyncWidth);
        }
    }

    protected void checkHSync(boolean force) {
        if (this.hSyncWidth == 0 || force) {
            this.inHSync = false;
            this.hSyncCount = 0;
            try {
                this.listener.hSyncEnd();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void setReg8(int value) {
        this.interlace = (value & 1) != 0;
        this.interlaceVideo = (value & 3) == 3 ? 1 : 0;
        this.scanAdd = this.interlaceVideo + 1;
        this.maxRaster = reg[9] | this.interlaceVideo;
        this.cursorDelay = value >> 6 & 3;
        this.setEvents();
    }

    public void setRegisterSelectMask(int mask, int test2) {
        this.registerSelectMask = mask;
        this.registerSelectTest = test2;
    }

    public void setRegisterWriteMask(int mask, int test2) {
        this.registerWriteMask = mask;
        this.registerWriteTest = test2;
    }

    public void setRegisterReadMask(int mask, int test2) {
        this.registerReadMask = mask;
        this.registerReadTest = test2;
    }

    public void setRegisterStatusMask(int mask, int test2) {
        this.registerStatusMask = mask;
        this.registerStatusTest = test2;
    }

    public int getHCC() {
        return this.hCC;
    }

    public int getHPOS() {
        return this.hCC * 8;
    }

    public int getNum() {
        return this.LineCounter + this.RasterCounter;
    }

    public int getVPOS() {
        return this.LineCounter * reg[9] + this.RasterCounter;
    }

    public int getVVPOS() {
        return ((this.LineCounter & 0x1F) << 3) + this.RasterCounter;
    }

    public boolean isVDisp() {
        return this.vDisp;
    }

    public boolean isVSync() {
        return this.inVSync;
    }

    public boolean isHSync() {
        return this.inHSync;
    }

    public boolean isHDisp() {
        return this.hDisp;
    }

    public int getMA() {
        return this.maCurrent & 0x3FFF;
    }

    public int getScreenMA() {
        return this.maStore;
    }

    public void setVerticalScroll(int value) {
        this.maScroll = value;
    }

    public int getRA() {
        return this.RasterCounter + this.maScroll & 7;
    }

    public int getRa() {
        return this.RasterCounter & 7;
    }

    public int getVCC() {
        return this.LineCounter;
    }

    public int getLineNumber() {
        return (this.RasterCounter & 7) + ((this.LineCounter & 0x7F) << 3);
    }

    public int getLine() {
        return (this.RasterCounter & 7) + ((this.LineCounter & 0x7F) << 3) & 0x1FF;
    }

    public int getVal() {
        return ((this.LineCounter & 0x1F) << 3) + (this.RasterCounter & 7);
    }

    public int getRasterLine() {
        return this.LineCounter * 8 + this.RasterCounter & 0xFFF;
    }

    public int getVLC() {
        return this.RasterCounter;
    }

    public int getReg(int index) {
        return reg[index];
    }

    public int getRegs(int index) {
        return regs[index];
    }

    public static String getRegister(int index) {
        return Util.hex(reg[index]).substring(6);
    }

    public static int getR(int index) {
        return reg[index];
    }

    public int getSelectedRegister() {
        return this.selReg;
    }

    public void setSelectedRegister(int value) {
        this.selReg = value & 0x1F;
    }

    public boolean isInterlace() {
        return this.interlace;
    }

    public boolean isInterlaceVideo() {
        return this.interlaceVideo == 1;
    }

    public int getFrame() {
        return this.frame;
    }

    public int getCRTC() {
        return this.CRTCType;
    }

    public void setCRTC(int value) {
        this.CRTCType = value & 1;
        CRTC = value & 1;
        this.setMasks();
    }

    public int getRegisterValue(int index) {
        int result = reg[index];
        if (index == 12) {
            result = reg[12] << 8 | reg[13];
        } else if (index == 13) {
            result = reg[14] << 8 | reg[15];
        }
        return result;
    }

    static {
        CRTCCollision = false;
        CURSOR_FLASH_MASKS = new int[]{64, 0, 16, 32};
        reg = new int[32];
        regs = new int[32];
    }
}

