/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.device;

import JCPC.core.Util;
import JCPC.core.cpu.Processor;
import JCPC.core.device.ComputerTimer;
import JCPC.core.device.Device;
import JCPC.core.device.floppy.Drive;
import JCPC.core.device.memory.Memory;
import JCPC.ui.Display;
import JCPC.util.diss.Disassembler;
import java.applet.Applet;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Vector;
import java.util.zip.ZipInputStream;

public abstract class Computer
extends Device
implements Runnable {
    protected int currentDrive = 0;
    public static final String DEFAULT_COMPUTER = "CPC6128";
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_SNAPSHOT = 1;
    public static final int TYPE_DISC_IMAGE = 2;
    public static final int TYPE_TAPE_IMAGE = 3;
    public static final int STOP = 0;
    public static final int STEP = 1;
    public static final int STEP_OVER = 2;
    public static final int RUN = 3;
    public static final int MAX_FRAME_SKIP = 20;
    public static final int MAX_FILE_SIZE = 0xD00000;
    public byte[][] disks = new byte[30][];
    public String[] disknames = new String[30];
    int index = 0;
    protected Applet applet;
    protected Thread thread = new Thread(this);
    protected boolean stopped = false;
    protected int action = 0;
    protected boolean running = false;
    protected boolean waiting = false;
    protected long startTime;
    protected long startCycles;
    protected String name;
    protected String romPath;
    protected String filePath;
    protected Vector files = null;
    protected Display display;
    protected int frameSkip = 0;
    protected int runTo = -1;
    protected int mode = 0;
    protected long maxResync = 200L;
    protected Vector devices = new Vector();
    protected Vector listeners = new Vector(1);
    protected static byte[] SKIP_BUFFER = new byte[1024];

    public static Computer createComputer(Applet applet, String name) throws Exception {
        Class cl = Util.findClass(null, "JCPC.system.cpc.CPC");
        Constructor con = cl.getConstructor(Applet.class, String.class);
        return (Computer)con.newInstance(applet, name);
    }

    public Computer(Applet applet, String name) {
        super("Computer: " + name);
        this.applet = applet;
        this.name = name;
        this.thread.start();
    }

    protected void setBasePath(String path) {
        this.romPath = "rom/";
        this.filePath = "file/";
    }

    public void initialise() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Computer.this.reset();
            }
        });
    }

    public Device addDevice(Device device) {
        return this.addDevice(device, null);
    }

    public Device addDevice(Device device, String name) {
        if (name != null) {
            device.setName(name);
        }
        this.devices.addElement(device);
        return device;
    }

    public Vector getDevices() {
        return this.devices;
    }

    public InputStream openFile(String name) throws Exception {
        InputStream result;
        System.out.println("File: " + name);
        try {
            result = name.startsWith("http:") ? new URL(name).openStream() : new URL(this.applet.getCodeBase(), name).openStream();
        }
        catch (Exception e) {
            result = new FileInputStream(name);
        }
        if (name.toLowerCase().endsWith(".zip")) {
            ZipInputStream str = new ZipInputStream(result);
            str.getNextEntry();
            result = str;
            return result;
        }
        return result;
    }

    protected int readStream(InputStream stream, byte[] buffer, int offs, int size) throws Exception {
        return this.readStream(stream, buffer, offs, size, true);
    }

    protected int readStream(InputStream stream, byte[] buffer, int offs, int size, boolean error) throws Exception {
        while (size > 0) {
            int read = stream.read(buffer, offs, size);
            if (read == -1) {
                if (!error) break;
                throw new Exception("Unexpected end of stream");
            }
            offs += read;
            size -= read;
        }
        return offs;
    }

    protected void skipStream(InputStream stream, int size) throws Exception {
        while (size > 0) {
            int bytes = size > 1024 ? 1024 : size;
            stream.read(SKIP_BUFFER, 0, bytes);
            size -= bytes;
        }
    }

    public Disassembler getDisassembler() {
        return null;
    }

    public byte[] getFile(String name) {
        return this.getFile(name, 0xD00000, true);
    }

    public byte[] getFile(String name, int size) {
        return this.getFile(name, size, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFile(String name, int size, boolean crop) {
        byte[] buffer = new byte[size];
        int offs = 0;
        try {
            InputStream stream = null;
            try {
                stream = this.openFile(name);
                while (size > 0) {
                    int read = stream.read(buffer, offs, size);
                    if (read == -1) {
                        break;
                    }
                    offs += read;
                    size -= read;
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println("File not found: " + name);
        }
        if (crop && offs < buffer.length) {
            byte[] result = new byte[offs];
            System.arraycopy(buffer, 0, result, 0, offs);
            buffer = result;
        }
        return buffer;
    }

    public abstract void AutoType(String var1);

    public void setDisplay(Display value) {
        this.display = value;
        this.displaySet();
    }

    public Display getDisplay() {
        return this.display;
    }

    protected void displaySet() {
    }

    public abstract Processor getProcessor();

    public abstract void reSync();

    public abstract Memory getMemory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRom(String name, int size) {
        byte[] buffer = new byte[size];
        int offs = 0;
        try {
            InputStream stream = null;
            try {
                InputStream is;
                stream = is = this.getClass().getResourceAsStream(name);
                while (size > 0) {
                    int read = stream.read(buffer, offs, size);
                    if (read == -1) {
                        break;
                    }
                    offs += read;
                    size -= read;
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public abstract void prepareAutotype(String var1);

    public void processKeyEvent(KeyEvent e) {
        if (this.mode == 3) {
            if (e.getID() == 401) {
                this.keyPressed(e);
            } else if (e.getID() == 402) {
                this.keyReleased(e);
            }
        }
    }

    public abstract void keyPressed(KeyEvent var1);

    public abstract void keyReleased(KeyEvent var1);

    public abstract void keyPressed(int var1);

    public abstract void keyReleased(int var1);

    public abstract void loadEntry(int var1);

    public void loadFile(int type, String name) throws Exception {
    }

    public abstract Dimension getDisplaySize(boolean var1);

    public void setLarge(boolean value) {
    }

    public Dimension getDisplayScale(boolean large) {
        return Display.SCALE_1x2;
    }

    public void start() {
        this.setAction(3);
    }

    public void stop() {
        this.setAction(0);
    }

    public void step() {
        this.setAction(1);
    }

    public void stepOver() {
        this.setAction(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setAction(int value) {
        if (this.running && value != 3) {
            this.action = 0;
            this.getProcessor().stop();
            while (this.running) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Thread thread = this.thread;
        synchronized (thread) {
            this.action = value;
            this.thread.notify();
        }
    }

    public void dispose() {
        this.stopped = true;
        this.stop();
        try {
            this.thread.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.thread = null;
        this.display = null;
        this.applet = null;
    }

    protected void emulate(int mode) {
        switch (mode) {
            case 1: {
                this.getProcessor().step();
                break;
            }
            case 2: {
                this.getProcessor().stepOver();
                break;
            }
            case 3: {
                if (this.runTo == -1) {
                    this.getProcessor().run();
                    break;
                }
                this.getProcessor().runTo(this.runTo);
            }
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.removeElement(listener);
    }

    protected void fireActionEvent() {
        ActionEvent e = new ActionEvent(this, 0, null);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ActionListener)this.listeners.elementAt(i)).actionPerformed(e);
        }
    }

    public String getROMPath() {
        return this.romPath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void reset() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stopped) {
            try {
                Thread thread;
                if (this.action == 0) {
                    thread = this.thread;
                    synchronized (thread) {
                        try {
                            this.thread.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (this.action == 0) continue;
                try {
                    this.running = true;
                    thread = this.thread;
                    synchronized (thread) {
                        this.mode = this.action;
                        this.action = 0;
                    }
                    this.startCycles = this.getProcessor().getCycles();
                    this.startTime = System.currentTimeMillis();
                    this.emulate(this.mode);
                }
                finally {
                    this.running = false;
                    this.fireActionEvent();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void syncProcessor() {
        this.syncProcessor(null, ((this.getProcessor().getCycles() - this.startCycles) * 2000L / this.getProcessor().getCyclesPerSecond() + 1L) / 2L, 200L);
    }

    protected void syncProcessor(ComputerTimer timer) {
        this.syncProcessor(timer, timer.getUpdates(), timer.getDeviation());
    }

    protected void syncProcessor(ComputerTimer timer, long count, long deviation) {
        long time;
        this.startTime += count;
        this.startCycles = this.getProcessor().getCycles();
        long l = time = timer != null ? timer.getCount() : System.currentTimeMillis();
        if (time < this.startTime - deviation) {
            this.setFrameSkip(0);
            this.startTime = time;
        } else if (time > this.startTime) {
            if (this.frameSkip == 20) {
                this.setFrameSkip(0);
                if (timer != null) {
                    timer.resync();
                }
                this.startTime = timer != null ? timer.getCount() : System.currentTimeMillis();
            } else {
                this.setFrameSkip(this.frameSkip + 1);
            }
        } else {
            try {
                this.setFrameSkip(0);
                long start = System.currentTimeMillis();
                while ((time = timer != null ? timer.getCount() : System.currentTimeMillis()) < this.startTime) {
                    if (timer != null && System.currentTimeMillis() - start > this.maxResync) {
                        timer.resync();
                        System.out.println("resync 2");
                        this.startTime = timer.getCount();
                        break;
                    }
                    Thread.sleep(1L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public void setMaxResync(long value) {
        this.maxResync = value;
    }

    public void setFrameSkip(int value) {
        this.frameSkip = value;
    }

    public void displayLostFocus() {
    }

    public void updateDisplay(boolean wait) {
    }

    public String getName() {
        return this.name;
    }

    public void setRunToAddress(int value) {
        this.runTo = value;
    }

    public void clearRunToAddress() {
        this.runTo = -1;
    }

    public int getMode() {
        return this.mode;
    }

    public Drive[] getFloppyDrives() {
        return null;
    }

    public int getCurrentDrive() {
        return this.currentDrive;
    }

    public void setCurrentDrive(int drive) {
        this.currentDrive = drive;
    }

    public int getIndex() {
        return this.index;
    }
}

