/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;

public class GamePadViewer
extends JFrame {
    private static final int DELAY = 40;
    private GamePadController gpController = new GamePadController();
    private CompassPanel xyPanel;
    private CompassPanel zrzPanel;
    private CompassPanel hatPanel;
    private ButtonsPanel buttonsPanel;
    private JCheckBox rumblerCheck;
    private Timer pollTimer;

    public GamePadViewer() {
        super("GamePad Viewer");
        this.makeGUI();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                GamePadViewer.this.pollTimer.stop();
                System.exit(0);
            }
        });
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
        this.startPolling();
    }

    private void makeGUI() {
        Container c = this.getContentPane();
        c.setLayout(new BoxLayout(c, 1));
        this.buttonsPanel = new ButtonsPanel();
        c.add(this.buttonsPanel);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.hatPanel = new CompassPanel("POV");
        p.add(this.hatPanel);
        this.xyPanel = new CompassPanel("xy");
        p.add(this.xyPanel);
        this.zrzPanel = new CompassPanel("zRz");
        p.add(this.zrzPanel);
        c.add(p);
        this.rumblerCheck = new JCheckBox("Rumbler");
        this.rumblerCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    GamePadViewer.this.gpController.setRumbler(true);
                } else {
                    GamePadViewer.this.gpController.setRumbler(false);
                }
            }
        });
        c.add(this.rumblerCheck);
    }

    private void startPolling() {
        ActionListener pollPerformer = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GamePadViewer.this.gpController.poll();
                int compassDir = GamePadViewer.this.gpController.getHatDir();
                GamePadViewer.this.hatPanel.setCompass(compassDir);
                compassDir = GamePadViewer.this.gpController.getXYStickDir();
                GamePadViewer.this.xyPanel.setCompass(compassDir);
                compassDir = GamePadViewer.this.gpController.getZRZStickDir();
                GamePadViewer.this.zrzPanel.setCompass(compassDir);
                boolean[] buttons = GamePadViewer.this.gpController.getButtons();
                GamePadViewer.this.buttonsPanel.setButtons(buttons);
            }
        };
        this.pollTimer = new Timer(40, pollPerformer);
        this.pollTimer.start();
    }

    public static void main(String[] args) {
        new GamePadViewer();
    }
}

