/*
    CaPriCe for Palm OS - Amstrad CPC 464/664/6128 emulator for Palm devices
    Copyright (C) 2009  Frdric Coste

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SOUND_H
#define SOUND_H

#include "..\NativeCode\Native_CPC.h"
#include "Sections.h"

extern Err SoundStart(tUChar* contextP) SECTION_SOUND;
extern tVoid SoundStop(tNativeCPC* NativeCPC) SECTION_SOUND;
extern tVoid SoundPlay(tNativeCPC* NativeCPC) SECTION_SOUND;
extern tVoid SoundPause(tNativeCPC* NativeCPC) SECTION_SOUND;
extern tVoid Sound_Calculate_Level_Tables(tULong Param) SECTION_SOUND;
extern tVoid SoundInitAYCounterVars(tULong Param) SECTION_SOUND;

extern tBool IsBufferRead(tUChar* contextP) SECTION_SOUND;

extern tVoid SoundIncreaseVolume(tUChar step) SECTION_SOUND;
extern tVoid SoundDecreaseVolume(tUChar step) SECTION_SOUND;

#ifdef _DEBUG
extern void ResetSoundDebugInfo(tUChar* contextP) SECTION_SOUND;
extern tULong GetSoundDebugInfo_Count(tUChar* contextP) SECTION_SOUND;
extern tULong GetSoundDebugInfo_Samples(tUChar* contextP) SECTION_SOUND;
#endif /* _DEBUG */

#endif // SOUND_H
