/*
    CaPriCe for Palm OS - Amstrad CPC 464/664/6128 emulator for Palm devices
    Copyright (C) 2009  Frdric Coste

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef ROUTINES_H
#define ROUTINES_H

#include "types.h"
#include "Sections.h"


typedef struct
{
  UInt32 srcContextBase;
  UInt32 dstContextBase;
  UInt32 contextSize;
  void** srcAreaP;
  void** dstAreaP;
  UInt32 areaSize;
  Boolean native;
} tReindexOperationParameters;


extern Err MemPtrNewLarge(UInt32 size,
                          void **newPtr) SECTION_ROUTINES;
extern UInt32 PceNativeCallResource(DmResID resID,
#ifdef __SIMU__
                                    char* DLLEntryPointP,
#endif /* __SIMU__ */
                                    void* userDataP) SECTION_ROUTINES;
extern UInt32 PceNativeCallMemPtr(MemPtr resP,
#ifdef __SIMU__
                                  char* DLLEntryPointP, 
#endif /* __SIMU__ */
                                  void* userDataP) SECTION_ROUTINES;
extern MemPtr DmCreateLargeResource(UInt32 AppCreator,
                                    UInt32 resFtrNum,
                                    DmResType type,
                                    DmResID FirstID,
                                    tULong FinalSize) SECTION_ROUTINES;
extern tULong ComputeCRC32(tUChar* memP,
                           tULong size) SECTION_ROUTINES;
extern void ReindexPointersArea(tReindexOperationParameters* paramP) SECTION_ROUTINES;

#ifdef _TESTU
extern Err Routines_PerformTestU(void) SECTION_ROUTINES;
#endif /* _TESTU */

#endif /* ROUTINES_H */
