/*
    CaPriCe for Palm OS - Amstrad CPC 464/664/6128 emulator for Palm devices
    Copyright (C) 2009  Frdric Coste

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef FORMS_H
#define FORMS_H

#include "Caprice.h"
#include "Sections.h"


typedef enum
{
  noDrive,
  DriveA,
  DriveB
} tDriveEnum;


typedef struct
{
	UInt32 StatAttributes;
  UInt16 InputAreaState;
  UInt16 InputTriggerState;
  UInt16 Orientation;
  UInt16 OrientationTriggerState;
} tDIAState;

#ifndef REMOVE_MAINFORMH
extern WinHandle mainFormH;
#endif /* REMOVE_MAINFORMH */
#ifndef _REMOVE_GLOBAL_VAR
extern tDriveEnum DriveSelected;
#endif /* _REMOVE_GLOBAL_VAR */

extern UInt8 LandscapeActive;
extern UInt16 DexLibRefNum;

extern void SetDIAPolicy(FormPtr frmP,
                         UInt16 DIATriggerState,
                         UInt16 ExtentDisplayLibRef,
                         tUChar Display320x480) SECTION_GUI;
                         
extern void SaveDIAState(tDIAState* DIAStateP) SECTION_GUI;
extern void RestoreDIAState(const tDIAState* DIAStateP) SECTION_GUI;

extern Boolean MainFormHandleEvent(EventPtr eventP);
extern Boolean FilesFormHandleEvent(EventPtr eventP);
extern Boolean AboutFormHandleEvent(EventPtr eventP);
extern Boolean DeviceSettingsFormHandleEvent(EventPtr eventP) SECTION_GUI;
extern Boolean EmulatorSettingsFormHandleEvent(EventPtr eventP) SECTION_GUI;
extern Boolean ScreenOffsetFormHandleEvent(EventPtr eventP) SECTION_GUI;
extern Boolean HardKeysFormHandleEvent(EventPtr eventP) SECTION_GUI;

extern void ChangeDriveAContent(void) SECTION_GUI;
extern void ChangeDriveBContent(void) SECTION_GUI;

#endif /* FORMS_H */
