/*
    CaPriCe for Palm OS - Amstrad CPC 464/664/6128 emulator for Palm devices
    Copyright (C) 2009  Frdric Coste

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef DISPLAY_H
#define DISPLAY_H

#include "types.h"
#include "Sections.h"
#include "Files.h"
#include "..\NativeCode\Native_CPC.h"


#define SCREEN_PALM_WIDTH               320
#define SCREEN_PALM_HEIGHT              232
#define SCREEN_PALM_HEIGHT_FS           320
#define SCREEN_PALM_LANDSCAPE_WIDTH     480
#define SCREEN_PALM_LANDSCAPE_HEIGHT    320

#define SCREEN_CPC_WIDTH                SCREEN_PALM_WIDTH
#define SCREEN_CPC_WIDTH_FS             SCREEN_PALM_WIDTH
#define SCREEN_CPC_WIDTH_LANDSCAPE      CPC_SCR_WIDTH
#define SCREEN_CPC_HEIGHT               SCREEN_PALM_HEIGHT
#define SCREEN_CPC_HEIGHT_FS            CPC_VISIBLE_SCR_HEIGHT
#define SCREEN_CPC_HEIGHT_LANDSCAPE     CPC_VISIBLE_SCR_HEIGHT

#define Y_SIZE_EMULATOR_PANEL           48
#define Y_SIZE_SUB_PANEL                40
#define Y_SIZE_MINI_KEYBOARD_PANEL      (Y_SIZE_EMULATOR_PANEL + Y_SIZE_SUB_PANEL)
#define Y_SIZE_KEYBOARD_PANEL           128


#define OFFSCREEN_VISIBLE_X             0
#define OFFSCREEN_VISIBLE_Y             1

#define OFFSCREEN_OFFSET_X              (((CPC_SCR_WIDTH - SCREEN_CPC_WIDTH) / 2))
#define OFFSCREEN_OFFSET_X_FS           (((CPC_SCR_WIDTH - SCREEN_CPC_WIDTH_FS) / 2))
#define OFFSCREEN_OFFSET_Y              (OFFSCREEN_VISIBLE_Y + ((SCREEN_CPC_HEIGHT_FS - SCREEN_PALM_HEIGHT) / 2))
#define OFFSCREEN_OFFSET_Y_FS           OFFSCREEN_VISIBLE_Y

#define ONSCREEN_OFFSET_X               0
#define ONSCREEN_OFFSET_Y               0
#define ONSCREEN_OFFSET_X_FS            0
#define ONSCREEN_OFFSET_Y_FS            ((SCREEN_PALM_HEIGHT_FS - SCREEN_CPC_HEIGHT_FS) / 2)
#define ONSCREEN_OFFSET_LANDSCAPE_X     ((SCREEN_PALM_LANDSCAPE_WIDTH - CPC_SCR_WIDTH) / 2)
#define ONSCREEN_OFFSET_LANDSCAPE_Y     ((SCREEN_PALM_LANDSCAPE_HEIGHT - CPC_VISIBLE_SCR_HEIGHT) / 2)

#define MESSAGE_START_X                 8
#define MESSAGE_START_Y                 211


extern void PrepareLandscapeScreenCopy(tNativeCPC* NativeCPC,
                                       UInt16 LibraryRef) SECTION_DISPLAY;

extern tResult DisplayCPCScreen(const tUChar offsetX,
                                const tUChar offsetY) SECTION_DISPLAY;
extern tVoid ClearFullscreen(tVoid) SECTION_DISPLAY;
extern tVoid DisplayStartupScreen(tVoid) SECTION_DISPLAY;
extern tVoid DisplayShutdownScreen(tVoid) SECTION_DISPLAY;
extern tResult DisplayEmulatorCommandPanel(tVoid) SECTION_DISPLAY;
extern tResult DisplaySubPanel(UInt8 SubButtonsActive) SECTION_DISPLAY;
extern tResult DisplayKey(tKey* keyP) SECTION_DISPLAY;
extern tResult DisplayOnScreenFDCLed(tUChar led) SECTION_DISPLAY;
extern tResult DisplayOffScreenDisk(tVoid) SECTION_DISPLAY;
extern tVoid DisplayOffScreenEmulatorSpeed(tULong percentage) SECTION_DISPLAY;
extern tVoid DisplayOffscreenMessage(const char* messageP) SECTION_DISPLAY;
extern tResult DisplayDIAKeyboard(tUChar CPCModel) SECTION_DISPLAY;
extern tResult DisplayMiniKeyboard(tVoid) SECTION_DISPLAY;
extern tVoid DisplayOffScreenAutoToggleSpeed(UInt8 index) SECTION_DISPLAY;
extern tVoid DisplayOffScreenSoundVolumeAdjust(tUChar volume) SECTION_DISPLAY;
extern tVoid DisplayOffScreenRockerHelp(tVoid) SECTION_DISPLAY;
extern tVoid DisplayOffScreenKeyStatus(tVoid) SECTION_DISPLAY;

extern Coord GetYBaseSubPanel(tVoid) SECTION_DISPLAY;
extern Coord GetYBaseEmulatorPanel(tVoid) SECTION_DISPLAY;
extern Coord GetYBaseKeyBoardPanel(tVoid) SECTION_DISPLAY;

extern void DisplayRestoreError(tCPCRestoreReturnCode ErrorCode,
                                tPreferences* ReqPrefP) SECTION_DISPLAY;


#ifdef _TRACE
extern tVoid DisplayTraceInfo(tNativeCPC* NativeCPC) SECTION_DISPLAY;
extern tVoid DisplayNativeTrace(tULong Trace) SECTION_DISPLAY;
#endif /* _TRACE */

#ifdef _DEBUG
extern tVoid DisplayOffscreenSoundData(tULong NativeSamples,
                                       tULong CbCount,
                                       tULong CbSamples) SECTION_DISPLAY;
#endif /* _DEBUG */

#if defined(_DEBUG) || defined(_SHOW_KEYS)
extern tVoid DisplayOffscreenKeyState(tVoid) SECTION_DISPLAY;
#endif /* _DEBUG || _SHOW_KEYS */

#ifdef _SHOW_FPS
extern tVoid DisplayOffscreenFPS(tULong FPS) SECTION_DISPLAY;
#endif /* _SHOW_FPS */


#if defined(_DEBUG) || defined(_SHOW_DATA)
extern tVoid DisplayOffscreenDATA(tChar* titleP, 
                                  tULong data,
                                  tULong x,
                                  tULong y) SECTION_DISPLAY;
                                  
#define DISPLAY_OFFSCREEN_DATA(title, data, x, y) DisplayOffscreenDATA(title, data, x, y);
#else /* _DEBUG || _SHOW_DATA */
#define DISPLAY_OFFSCREEN_DATA(title, data, x, y) 
#endif /* _DEBUG || _SHOW_DATA */


#endif /* DISPLAY_H */
