/*
    CaPriCe for Palm OS - Amstrad CPC 464/664/6128 emulator for Palm devices
    Copyright (C) 2009  Frdric Coste

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef CAPRICE_H
#define CAPRICE_H

#include "..\NativeCode\Native_CPC.h"


// =============================================================================
// Caprice version string is defined into Resources "App Version String" Id=1000
// =============================================================================

#define appFileCreator            'pCPC'
#define appVersionNum             (0x01)

#define CPCExecuteFtrNum          ((UInt16)100)

#define ROOT_PATH                 "/"
#define PARENT_PATH               "/.."

#define DEFAULT_DISK_PATH         "/PALM/Amstrad/"
#define DEFAULT_PALM_PATH         "/PALM/programs"
#define DEFAULT_CAPRICE_PATH      "/PALM/programs/CaPriCe/"
#define DEFAULT_SCREENSHOT_PATH   "/PALM/programs/CaPriCe/Screens/"

#define NODISK_FILENAME           ""
#define CONTEXT_EXTENSION         ".cpc"
#define DISK_EXTENSION_SHORT      "dsk"
#define DISK_EXTENSION            "." DISK_EXTENSION_SHORT
#define SCREENSHOT_EXTENSION      ".bmp"
#define NEW_DISK_FILENAME         "New Disk" DISK_EXTENSION
#define LASTSESSION_FILENAME      "LastSession" CONTEXT_EXTENSION

#define DISK_EXTENSION_DESCRIPTION     "Amstrad CPC Disk Image"

#define SAVE_SESSION_TITLE        "Session saving"
#define SAVE_SCREENSHOT_TITLE     "Screenshot saving"

#define DEBOUNCETIME_MS           50     // Key down duration following to key down event (ms)
#define SHOWMESSAGETIME_S         2      // Message display duration (s)
#define SHOWSPLASHTIME_S          1      // Startup screen display duration (s)
#define SHOWSHUTDOWNTIME_S        1      // Shutdown screen display duration (s)
#define AUTOSTARTHOLDTIME_MS      100    // Key pressed duration for autostart (ms)
#define AUTOSTARTRELEASETIME_MS   50     // Key released duration for autostart (ms)
#define AUTOSTARTRESETTIME_MS     1500   // Time to wait from Reset before sending keys for autostart (ms)


#define TRACE_BREAKPOINT          0x0c13


typedef enum
{
  JOYSTICK_ON_MSG = 0,
  JOYSTICK_OFF_MSG,
  CPC_TRUE_SPEED_MSG,
  FULL_SPEED_MSG,
  AUDIO_MSG,
  MUTE_MSG,
  FX_KEYS_MSG,
  NUM_KEYS_MSG
} tMessageIndex;


typedef enum
{
	COLORINDEX_BLACK = 0,
	COLORINDEX_DARK_BLUE,
	COLORINDEX_YELLOW,
	COLORINDEX_WHITE,
	COLORINDEX_RED,
	COLORINDEX_BLUE,
	//
	COLORINDEX_COUNT // Must be the last
} tColorIndexEnum;


typedef struct
{
  UInt32 magicID;
  UInt32 descriptionOffset;
  UInt32 descriptionSize;
  UInt32 fileOffset;
  UInt32 fileSize;
} CmdToGoLaunchParamHeader;


// Event Codes
#define volumeUnmountedEvent              0x6100
#define volumeMountedEvent                0x6101
#define debugBreakpointEvent              firstUserEvent
//
#define screenRedrawUpdateCode            0x0001
#define emulatorRedrawUpdateCode          0x0002
#define SubPanelRedrawUpdateCode          0x0004
#define keyboardRedrawUpdateCode          0x0008

#define FontCPC                           fntAppFontCustomBase


extern UInt8 SystemHalt;

extern UInt8 collapsibleIA;

extern UInt8 CPCStarted;
extern UInt32 u32DebounceInTicks;
extern UInt8 DisplayEmuSpeed;
extern UInt8 AllowSaveSession;
extern UInt8 OnScreenRockerHelpDisplay;
extern UInt8 FullscreenActive;
extern UInt8 MiniKeyboardActive;
extern UInt32 oldHardKeyMask;
extern UInt32 emulatorHardKeyMask;
extern UInt8 SubPanelActive;
extern UInt8 Navigation5WaysActive;
extern UInt8 ScreenshotRequested;
extern UInt8 VideoFrameInitialDelay;
extern UInt32 WestPhaserTriggerActiveDelay;


extern tPreferences* prefP;
extern RGBColorType *originalPaletteP;
extern IndexedColorType* colorIndexP;
extern CmdToGoLaunchParamHeader* CmdToGoParamsP;

extern char AutoStartCommand[];

extern char* sessionFilenameP;

extern tVoid ShowMessage(tUChar noMessage);
extern tVoid HideMessage(tVoid);

extern tVoid UpdateFDCLedOffScreenDisplay(tVoid);

extern tUChar GetShowCPCKeycodes(tVoid);
extern tVoid  SetShowCPCKeycodes(tUChar show);


#endif // CAPRICE_H
