/*
    CaPriCe for Palm OS - Amstrad CPC 464/664/6128 emulator for Palm devices
    Copyright (C) 2009  Frdric Coste

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef CPC_H
#define CPC_H

#include "types.h"
#include "Sections.h"


typedef enum
{
  NoLoad,
  AutomaticLoad,
  LoadWithConfirmation
} tAutomaticLoadType;

extern tNativeCPC* NativeCPC;
extern tUChar* contextP;

extern MemPtr PNOCPCExecuteP;

extern WinHandle OffScreen;

extern Err  CPCFirstStart(void);
extern void CPCLastStop(void);

extern void CPCStop(void);
extern void CPCReset(void);
extern void CPCResetWithConfirmation(void);
extern Err  CPCColdReset(const char* pathP,
                         const char* filenameP,
                         tAutomaticLoadType Load);

#ifndef _USE_MACROS
  extern UInt32 CPCExecute(void);
#else /* USE_MACROS */
  #ifdef __SIMU__
    #define CPCEXECUTE_SIMU "Native_CPCExecute.dll\0PNOMain",
  #else /* __SIMU__ */
    #define CPCEXECUTE_SIMU
  #endif /* __SIMU__ */
  #define CPCExecute() \
    PceNativeCallMemPtr(PNOCPCExecuteP, \
                        CPCEXECUTE_SIMU \
                        NativeCPC);
#endif /* USE_MACROS */

extern UInt32 CPCSetColor(void);
extern void EmulatorFreeze(void);
extern void EmulatorUnfreeze(void);
extern void CPCSwapDrive(void);
extern void CPCEjectBoth(void);

extern Boolean CPCHandleEvent(EventPtr Event);

extern void SetRenderingParameters(tUChar Rendering);

extern void SetLightGunParameters(tPreferences* prefP,
                                  tNativeCPC* NativeCPC);

#endif /* ! CPC_H */
