// 15 August 1997, Rick Huebner:  Small changes made to adapt for MathLib

/* @(#)s_rint.c 5.1 93/09/24 */
/*
 * ====================================================
 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
 *
 * Developed at SunPro, a Sun Microsystems, Inc. business.
 * Permission to use, copy, modify, and distribute this
 * software is freely granted, provided that this notice
 * is preserved.
 * ====================================================
 */

/*
 * rint(x)
 * Return x rounded to integral value according to the prevailing
 * rounding mode.
 * Method:
 *	Using floating addition.
 * Exception:
 *	Inexact flag raised if x not equal to rint(x).
 */

#include "Math.h"
#include "../src/types.h"
#include "../src/sections.h"


// 68k Big endian
#define __HI32(x) *((tULong*)&x)			// return first tULong
#define __LO32(x) *((tULong*)&x + 1)	// return second tULong

/* Get two 32 bit ints from a double.  */
#define EXTRACT_WORDS(ix0,ix1,d) \
			(ix0) = __HI32(d); \
			(ix1) = __LO32(d);

/* Set a double from two 32 bit ints.  */
#define INSERT_WORDS(d,ix0,ix1) \
			__HI32(d) = (ix0); \
			__LO32(d) = (ix1);

#define GET_HIGH_WORD(i,d) \
			(i) = __HI32(d);

#define SET_HIGH_WORD(d,v) \
			__HI32(d) = (v);



tDouble rint(tDouble x)
/***********************************************************************
 *
 *	rint
 *
 ***********************************************************************/
{
tDouble TWO52[2] = {	 4.50359962737049600000e+15, /* 0x43300000, 0x00000000 */
											-4.50359962737049600000e+15 /* 0xC3300000, 0x00000000 */ };
tDouble w,t;
tLong i0,j0,sx;
tULong i,i1;
	
	EXTRACT_WORDS(i0,i1,x);
	
	// Rcuprer le signe
	sx = (i0 >> 31) & 1;			
	
	// Rcuprer la mantisse
	j0 = ((i0 >> 20) & 0x7ff) - 0x3ff;	
	
	if (j0 < 20)
	{
	  if (j0 < 0)
	  {
			if (((i0 & 0x7fffffff) | i1) == 0) 
				return x;
			
			i1 |= (i0 & 0x0fffff);
			i0 &= 0xfffe0000;
			i0 |= ((i1 | -i1) >> 12) & 0x80000;
			
			SET_HIGH_WORD(x, i0);
			
	    w = TWO52[sx] + x;
	    t = w - TWO52[sx];
			
			GET_HIGH_WORD(i0, t);
			SET_HIGH_WORD(t, (i0 & 0x7fffffff) | (sx << 31));
			
	    return t;
	  } 
	  else
	  {
			i = (0x000fffff) >> j0;
			if (((i0 & i) | i1) == 0)  /* x is integral */
				return x;
				
			i >>= 1;
			
			if(((i0 & i) | i1) != 0)
			{
		    if (j0==19) 
		    	i1 = 0x40000000;
		    else
		    	i0 = (i0&(~i))|((0x20000)>>j0);
			}
	  }
	} 
	else if (j0 > 51) 
	{
	  if (j0 == 0x400) 	
	  	return x+x; /* inf or NaN */
	  else 
	  	return x;		/* x is integral */
	} 
	else 
	{
	  i = ((tULong)(0xffffffff)) >> (j0 - 20);
	  
	  if ((i1 & i) == 0) 
	  	return x;	/* x is integral */
	  	
	  i >>= 1;
	  
	  if ((i1 & i) != 0) 
	  	i1 = (i1 & (~i)) | ((0x40000000) >> (j0 - 20));
	}
	
	INSERT_WORDS(x, i0, i1);
	w = TWO52[sx] + x;
	
	return (w - TWO52[sx]);
}
