/***************************************/
/**                                   **/
/** AMSTRAD/Schneider CPC-Emulator    **/
/** for Linux and X11                 **/
/**                                   **/
/** GNU GENERAL PUBLIC LICENSE        **/
/** 1999, 2000, 2001                  **/
/** Ulrich Cordes                     **/
/** Vor der Dorneiche 1               **/
/** 34317 HABICHTSWALD / Germany      **/
/**                                   **/
/** email:  ulrich.cordes@gmx.de      **/
/** WWW:    http://www.amstrad-cpc.de **/
/**                                   **/
/***************************************/

/*
 *  If you want to make changes, please do not(!) use TABs !!!!!
 */

#include "cpc.h"
#include "Z80.h"
#include "defines.h"

byte Ink[17];
byte InkNum;
byte AktInk[17];

/* 32 color pixels and 32 green pixels */
unsigned long PixColor[64];
unsigned long ToolBarColor;
/* 32=green pixels and 0=color pixels */
int MonoScreen;


/* Marco Vieth, author of CPCEMU 1.x, gave his permition to me to use */
/* the colors in his color table file CPCEMU.DAT. Thanks Marco        */
long GreenRGBs [32][3] = {
  { 0x00, 0x24, 0x00 },  { 0x00, 0x24, 0x00 },  { 0x00, 0x30, 0x00 },  { 0x00, 0x3C, 0x00 },
  { 0x00, 0x0C, 0x00 },  { 0x00, 0x18, 0x00 },  { 0x00, 0x1E, 0x00 },  { 0x00, 0x2A, 0x00 },
  { 0x00, 0x18, 0x00 },  { 0x00, 0x3c, 0x00 },  { 0x00, 0x3a, 0x00 },  { 0x00, 0x3e, 0x00 },
  { 0x00, 0x16, 0x00 },  { 0x00, 0x1a, 0x00 },  { 0x00, 0x28, 0x00 },  { 0x00, 0x2c, 0x00 },
  { 0x00, 0x0c, 0x00 },  { 0x00, 0x30, 0x00 },  { 0x00, 0x2e, 0x00 },  { 0x00, 0x32, 0x00 },
  { 0x00, 0x0a, 0x00 },  { 0x00, 0x0e, 0x00 },  { 0x00, 0x1c, 0x00 },  { 0x00, 0x20, 0x00 },
  { 0x00, 0x12, 0x00 },  { 0x00, 0x36, 0x00 },  { 0x00, 0x34, 0x00 },  { 0x00, 0x38, 0x00 },
  { 0x00, 0x10, 0x00 },  { 0x00, 0x14, 0x00 },  { 0x00, 0x22, 0x00 },  { 0x00, 0x26, 0x00 }
};

long ColorRGBs [32][3] = {
  { 0x29, 0x29, 0x29 },  { 0x29, 0x29, 0x29 },  { 0x1c, 0x39, 0x20 },  { 0x3c, 0x31, 0x14 },
  { 0x00, 0x00, 0x2b },  { 0x3f, 0x00, 0x28 },  { 0x00, 0x28, 0x32 },  { 0x3f, 0x26, 0x26 },
  { 0x3f, 0x00, 0x38 },  { 0x3c, 0x31, 0x14 },  { 0x3a, 0x3a, 0x00 },  { 0x3e, 0x3e, 0x3e },
  { 0x3f, 0x00, 0x00 },  { 0x3f, 0x00, 0x3a },  { 0x3c, 0x2a, 0x00 },  { 0x3b, 0x1a, 0x3b },
  { 0x00, 0x00, 0x2b },  { 0x1c, 0x39, 0x20 },  { 0x00, 0x39, 0x00 },  { 0x00, 0x2f, 0x3f },
  { 0x00, 0x00, 0x00 },  { 0x00, 0x00, 0x3c },  { 0x00, 0x2e, 0x00 },  { 0x1e, 0x1e, 0x3e },
  { 0x30, 0x00, 0x30 },  { 0x20, 0x3d, 0x21 },  { 0x2b, 0x3c, 0x00 },  { 0x1f, 0x1a, 0x3f },
  { 0x29, 0x05, 0x05 },  { 0x30, 0x00, 0x3f },  { 0x30, 0x2b, 0x00 },  { 0x26, 0x26, 0x3c }
};


void InitColors (void) {
  Colormap cmap;
  XColor color;
  int i;
  color.flags = DoRed | DoGreen | DoBlue;
  cmap = DefaultColormap (mydisplay,myscreen);
  /* The first 32 are the color pixels. To chose set ink num = CPC color num logical OR <MonoScreen> */
  /* If MonoScreen=0 then the color pixels will be used */
  for (i=0; i<=31; i++) {
    color.red   = ColorRGBs [i][0]*0xFFFF/0x3F; /* Expand Marco's colors to real RGB */
    color.green = ColorRGBs [i][1]*0xFFFF/0x3F;
    color.blue  = ColorRGBs [i][2]*0xFFFF/0x3F;
    XAllocColor (mydisplay, cmap, &color);
    PixColor[i]=color.pixel;
  }
  /* The 2nd 32 are the green pixels. To chose set ink num = CPC color num logical OR <MonoScreen> */
  /* If MonoScreen=32 then the green pixels will be used */
  for (i=32; i<=63; i++) {
    color.red   = GreenRGBs [i-32][0]*0xFFFF/0x3F; /* Expand Marco's colors to real RGB */
    color.green = GreenRGBs [i-32][1]*0xFFFF/0x3F;
    color.blue  = GreenRGBs [i-32][2]*0xFFFF/0x3F;
    XAllocColor (mydisplay, cmap, &color);
    PixColor[i]=color.pixel;
  }
  /* Get the grey color for the toolbar */
  color.red   = 0xC000;
  color.green = 0xC000;
  color.blue  = 0xC000;
  XAllocColor (mydisplay, cmap, &color);
  ToolBarColor=color.pixel;
}

unsigned long GetRGBColor(byte R, byte G, byte B) {
  return ((long)R<<16 | (long)G<<8 | (long)B);
}

